/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.jsp.util;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.opencms.json.JSONArray;
import org.opencms.json.JSONException;
import org.opencms.json.JSONObject;
import org.opencms.util.CmsStringUtil;

public class CmsJspJsonWrapper
extends AbstractCollection<Object> {
    private Object m_value;

    public CmsJspJsonWrapper(Object value) {
        this.m_value = value;
    }

    public static void removePathInJson(Object obj, List<String> pathComponents) {
        block8: {
            List<String> remainingPath;
            String key;
            block7: {
                if (pathComponents.isEmpty()) {
                    return;
                }
                key = pathComponents.get(0);
                remainingPath = pathComponents.subList(1, pathComponents.size());
                if (CmsStringUtil.isEmptyOrWhitespaceOnly(key)) {
                    CmsJspJsonWrapper.removePathInJson(obj, remainingPath);
                    return;
                }
                if (!(obj instanceof JSONArray)) break block7;
                JSONArray array = (JSONArray)obj;
                for (int i = 0; i < array.length(); ++i) {
                    CmsJspJsonWrapper.removePathInJson(array.opt(i), pathComponents);
                }
                break block8;
            }
            if (!(obj instanceof JSONObject)) break block8;
            List<JSONObjectEntry> childrenForKey = JSONObjectEntry.getEntriesForKey((JSONObject)obj, key);
            if (pathComponents.size() == 1) {
                for (JSONObjectEntry child : childrenForKey) {
                    child.remove();
                }
            } else {
                for (JSONObjectEntry child : childrenForKey) {
                    CmsJspJsonWrapper.removePathInJson(child.getValue(), remainingPath);
                }
            }
        }
    }

    public String getCompact() {
        try {
            return JSONObject.valueToString(this.m_value);
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
    }

    public Object getJson() {
        return this.getObject();
    }

    public Object getObject() {
        return this.m_value;
    }

    public String getPretty() {
        try {
            return JSONObject.valueToString(this.m_value, 4, 0);
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
    }

    public String getVerbose() {
        return this.getPretty();
    }

    @Override
    public boolean isEmpty() {
        if (this.m_value instanceof JSONObject) {
            return ((JSONObject)this.m_value).length() < 1;
        }
        if (this.m_value instanceof JSONArray) {
            return ((JSONArray)this.m_value).length() < 1;
        }
        if (this.m_value instanceof String) {
            return CmsStringUtil.isEmptyOrWhitespaceOnly((String)this.m_value);
        }
        return this.m_value == null;
    }

    @Override
    public Iterator<Object> iterator() {
        Iterator<Object> it = new Iterator<Object>(){
            private boolean isFirst = true;

            @Override
            public boolean hasNext() {
                return this.isFirst && !CmsJspJsonWrapper.this.isEmpty();
            }

            @Override
            public Object next() {
                this.isFirst = false;
                return CmsJspJsonWrapper.this.getObject();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
        return it;
    }

    public void removePath(String path) {
        path = path.trim();
        CmsJspJsonWrapper.removePathInJson(this.m_value, Arrays.asList(path.split("/")));
    }

    @Override
    public int size() {
        return this.isEmpty() ? 0 : 1;
    }

    @Override
    public String toString() {
        return this.getCompact();
    }

    private static class JSONObjectEntry {
        private String m_key;
        private JSONObject m_object;

        public JSONObjectEntry(JSONObject obj, String key) {
            this.m_object = obj;
            this.m_key = key;
        }

        static List<JSONObjectEntry> getEntriesForKey(JSONObject obj, String key) {
            ArrayList<JSONObjectEntry> result = new ArrayList<JSONObjectEntry>();
            if ("*".equals(key)) {
                for (String actualKey : obj.keySet()) {
                    result.add(new JSONObjectEntry(obj, actualKey));
                }
                return result;
            }
            Object child = obj.opt(key);
            if (child != null) {
                return Collections.singletonList(new JSONObjectEntry(obj, key));
            }
            return Collections.emptyList();
        }

        public String getKey() {
            return this.m_key;
        }

        public Object getValue() {
            return this.m_object.opt(this.m_key);
        }

        public void remove() {
            this.m_object.remove(this.m_key);
        }
    }
}

