/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.jsp.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.collections.Transformer;
import org.dom4j.Element;
import org.dom4j.Node;
import org.opencms.ade.contenteditor.CmsContentService;
import org.opencms.file.CmsObject;
import org.opencms.i18n.CmsLocaleManager;
import org.opencms.json.JSONException;
import org.opencms.jsp.util.A_CmsJspValueWrapper;
import org.opencms.jsp.util.CmsJspContentAccessBean;
import org.opencms.jsp.util.CmsJspDateSeriesBean;
import org.opencms.jsp.util.CmsJspJsonWrapper;
import org.opencms.main.CmsException;
import org.opencms.util.CmsCollectionsGenericWrapper;
import org.opencms.util.CmsConstantMap;
import org.opencms.util.CmsMacroResolver;
import org.opencms.util.CmsStringUtil;
import org.opencms.xml.CmsXmlUtils;
import org.opencms.xml.I_CmsXmlDocument;
import org.opencms.xml.content.CmsXmlContent;
import org.opencms.xml.types.I_CmsXmlContentValue;
import org.opencms.xml.xml2json.CmsXmlContentTree;
import org.opencms.xml.xml2json.renderer.CmsJsonRendererXmlContent;

public final class CmsJspContentAccessValueWrapper
extends A_CmsJspValueWrapper {
    protected static final CmsJspContentAccessValueWrapper NULL_VALUE_WRAPPER = new CmsJspContentAccessValueWrapper();
    public static final String TEMP_XML2JSON_TREE = "xml2json.tree";
    private I_CmsXmlContentValue m_contentValue;
    private CmsJspDateSeriesBean m_dateSeries;
    private int m_hashCode;
    private Map<String, Boolean> m_hasValue;
    private CmsMacroResolver m_macroResolver;
    private List<String> m_names;
    private NullValueInfo m_nullValueInfo;
    private Map<String, String> m_parameters;
    private Map<String, String> m_rdfa;
    private Map<String, List<CmsJspContentAccessValueWrapper>> m_subValueList;
    private Map<String, CmsJspContentAccessValueWrapper> m_value;
    private Map<String, List<CmsJspContentAccessValueWrapper>> m_valueList;
    private Map<String, String> m_xml;

    private CmsJspContentAccessValueWrapper() {
        this((CmsObject)null, (I_CmsXmlContentValue)null);
    }

    private CmsJspContentAccessValueWrapper(CmsJspContentAccessValueWrapper base, CmsMacroResolver macroResolver) {
        this.m_cms = base.m_cms;
        this.m_contentValue = base.m_contentValue;
        this.m_hashCode = base.m_hashCode;
        this.m_hasValue = base.m_hasValue;
        this.m_macroResolver = macroResolver;
        this.m_value = base.m_value;
        this.m_valueList = base.m_valueList;
    }

    private CmsJspContentAccessValueWrapper(CmsObject cms, I_CmsXmlContentValue value) {
        this.m_cms = cms;
        this.m_contentValue = value;
        if (this.m_contentValue == null || this.m_contentValue.isSimpleType()) {
            this.m_hasValue = CmsConstantMap.CONSTANT_BOOLEAN_FALSE_MAP;
            this.m_value = CmsJspContentAccessBean.CONSTANT_NULL_VALUE_WRAPPER_MAP;
            this.m_valueList = CmsConstantMap.CONSTANT_EMPTY_LIST_MAP;
        }
    }

    public static CmsJspContentAccessValueWrapper createWrapper(CmsObject cms, I_CmsXmlContentValue value, I_CmsXmlContentValue parentValue, String valueName) {
        if (value != null && cms != null) {
            return new CmsJspContentAccessValueWrapper(cms, value);
        }
        if (parentValue != null && valueName != null && cms != null) {
            CmsJspContentAccessValueWrapper wrapper = new CmsJspContentAccessValueWrapper();
            wrapper.m_nullValueInfo = new NullValueInfo(parentValue, valueName);
            wrapper.m_cms = cms;
            return wrapper;
        }
        return NULL_VALUE_WRAPPER;
    }

    public static CmsJspContentAccessValueWrapper createWrapper(CmsObject cms, I_CmsXmlContentValue value, I_CmsXmlDocument content, String valueName, Locale locale) {
        if (value != null && cms != null) {
            return new CmsJspContentAccessValueWrapper(cms, value);
        }
        if (content != null && valueName != null && locale != null && cms != null) {
            CmsJspContentAccessValueWrapper wrapper = new CmsJspContentAccessValueWrapper();
            wrapper.m_nullValueInfo = new NullValueInfo(content, valueName, locale);
            wrapper.m_cms = cms;
            return wrapper;
        }
        return NULL_VALUE_WRAPPER;
    }

    static boolean isDirectEditEnabled(CmsObject cms) {
        return !cms.getRequestContext().getCurrentProject().isOnlineProject() && cms.getRequestContext().getAttribute("__disableDirectEdit") == null;
    }

    public I_CmsXmlContentValue getContentValue() {
        return this.m_contentValue;
    }

    @Override
    public boolean getExists() {
        return this.m_contentValue != null;
    }

    public Map<String, Boolean> getHasValue() {
        if (this.m_hasValue == null) {
            this.m_hasValue = CmsCollectionsGenericWrapper.createLazyMap(new CmsHasValueTransformer());
        }
        return this.m_hasValue;
    }

    public String getImageDndAttr() {
        String result = "";
        CmsObject cms = this.getCmsObject();
        if (cms != null && this.m_contentValue != null && CmsJspContentAccessValueWrapper.isDirectEditEnabled(cms) && this.m_contentValue.getDocument().getFile() != null) {
            result = CmsJspContentAccessBean.createImageDndAttr(this.m_contentValue.getDocument().getFile().getStructureId(), this.m_contentValue.getPath(), String.valueOf(this.m_contentValue.getLocale()));
        }
        return result;
    }

    public int getIndex() {
        if (this.m_contentValue == null) {
            return -1;
        }
        return this.m_contentValue.getIndex();
    }

    @Override
    public boolean getIsEmpty() {
        if (this.m_contentValue == null) {
            return true;
        }
        if (this.m_contentValue.isSimpleType()) {
            return CmsStringUtil.isEmpty(this.m_contentValue.getStringValue(this.m_cms));
        }
        return this.m_contentValue.getElement().elements().size() > 0;
    }

    @Override
    public boolean getIsEmptyOrWhitespaceOnly() {
        if (this.m_contentValue == null) {
            return true;
        }
        if (this.m_contentValue.isSimpleType()) {
            return CmsStringUtil.isEmptyOrWhitespaceOnly(this.m_contentValue.getStringValue(this.m_cms));
        }
        return this.m_contentValue.getElement().elements().isEmpty();
    }

    public CmsJspJsonWrapper getJson() throws CmsException {
        if (!this.getExists()) {
            return new CmsJspJsonWrapper(null);
        }
        CmsXmlContent content = (CmsXmlContent)this.m_contentValue.getDocument();
        CmsXmlContentTree tree = (CmsXmlContentTree)content.getTempDataCache().get(TEMP_XML2JSON_TREE);
        CmsXmlContentTree.Node node = null;
        if (tree == null) {
            tree = new CmsXmlContentTree(content, this.getLocale());
            content.getTempDataCache().put(TEMP_XML2JSON_TREE, tree);
        }
        if ((node = tree.getNodeForValue(this.m_contentValue)) == null) {
            return new CmsJspJsonWrapper(null);
        }
        CmsJsonRendererXmlContent renderer = new CmsJsonRendererXmlContent(this.getCmsObject());
        try {
            Object jsonObj = renderer.renderNode(node);
            return new CmsJspJsonWrapper(jsonObj);
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
    }

    public Locale getLocale() {
        if (this.m_contentValue == null) {
            return CmsLocaleManager.getDefaultLocale();
        }
        return this.m_contentValue.getLocale();
    }

    public String getName() {
        if (this.m_contentValue == null) {
            return null;
        }
        return this.m_contentValue.getName();
    }

    public List<String> getNames() {
        if (this.m_names == null) {
            this.m_names = new ArrayList<String>();
            if (!this.m_contentValue.isSimpleType()) {
                for (I_CmsXmlContentValue value : this.m_contentValue.getDocument().getSubValues(this.getPath(), this.getLocale())) {
                    this.m_names.add(CmsXmlUtils.createXpathElement(value.getName(), value.getXmlIndex() + 1));
                }
            }
        }
        return this.m_names;
    }

    @Override
    public Object getObjectValue() {
        return this.m_contentValue;
    }

    public String getPath() {
        if (this.m_contentValue == null) {
            return "";
        }
        return this.m_contentValue.getPath();
    }

    public Map<String, String> getRdfa() {
        if (this.m_rdfa == null) {
            this.m_rdfa = CmsCollectionsGenericWrapper.createLazyMap(new CmsRdfaTransformer());
        }
        return this.m_rdfa;
    }

    public String getRdfaAttr() {
        String result = "";
        CmsObject cms = this.getCmsObject();
        if (cms != null && CmsJspContentAccessValueWrapper.isDirectEditEnabled(cms)) {
            if (this.m_contentValue != null) {
                result = CmsContentService.getRdfaAttributes(this.m_contentValue);
            } else if (this.m_nullValueInfo != null) {
                if (this.m_nullValueInfo.getParentValue() != null) {
                    result = CmsContentService.getRdfaAttributes(this.m_nullValueInfo.getParentValue(), this.m_nullValueInfo.getValueName());
                } else if (this.m_nullValueInfo.getContent() != null) {
                    result = CmsContentService.getRdfaAttributes(this.m_nullValueInfo.getContent(), this.m_nullValueInfo.getLocale(), this.m_nullValueInfo.getValueName());
                }
            }
        }
        return result;
    }

    public CmsJspContentAccessValueWrapper getResolve() {
        return this.getResolveMacros();
    }

    public CmsJspContentAccessValueWrapper getResolveMacros() {
        if (this.m_macroResolver == null) {
            CmsMacroResolver macroResolver = CmsMacroResolver.newInstance();
            macroResolver.setCmsObject(this.m_cms);
            macroResolver.setKeepEmptyMacros(true);
            return new CmsJspContentAccessValueWrapper(this, macroResolver);
        }
        return this;
    }

    public Map<String, List<CmsJspContentAccessValueWrapper>> getSubValueList() {
        if (this.m_subValueList == null) {
            this.m_subValueList = CmsCollectionsGenericWrapper.createLazyMap(new CmsSubValueListTransformer());
        }
        return this.m_subValueList;
    }

    public CmsJspDateSeriesBean getToDateSeries() {
        if (this.m_dateSeries == null) {
            this.m_dateSeries = new CmsJspDateSeriesBean(this, this.m_cms.getRequestContext().getLocale());
        }
        return this.m_dateSeries;
    }

    public Map<String, String> getToParameters() {
        if (this.m_parameters == null) {
            I_CmsXmlContentValue xmlvalue = this.getContentValue();
            if (xmlvalue != null && !this.getContentValue().isSimpleType()) {
                List<I_CmsXmlContentValue> parameters = xmlvalue.getDocument().getValues(xmlvalue.getPath(), xmlvalue.getLocale());
                this.m_parameters = new HashMap<String, String>(parameters.size());
                for (I_CmsXmlContentValue params : parameters) {
                    List children = params.getElement().elements();
                    if (children.size() != 2) continue;
                    String key = ((Element)children.get(0)).getText();
                    String value = ((Element)children.get(1)).getText();
                    this.m_parameters.put(key, value);
                }
            }
            if (this.m_parameters == null) {
                this.m_parameters = Collections.emptyMap();
            }
        }
        return this.m_parameters;
    }

    public String getTypeName() {
        if (this.m_contentValue != null) {
            return this.m_contentValue.getTypeName();
        }
        return null;
    }

    public Map<String, CmsJspContentAccessValueWrapper> getValue() {
        if (this.m_value == null) {
            this.m_value = CmsCollectionsGenericWrapper.createLazyMap(new CmsValueTransformer());
        }
        return this.m_value;
    }

    public Map<String, List<CmsJspContentAccessValueWrapper>> getValueList() {
        if (this.m_valueList == null) {
            this.m_valueList = CmsCollectionsGenericWrapper.createLazyMap(new CmsValueListTransformer());
        }
        return this.m_valueList;
    }

    public Map<String, String> getXmlText() {
        if (this.m_xml == null) {
            this.m_xml = CmsCollectionsGenericWrapper.createLazyMap(new CmsXmlValueTransformer());
        }
        return this.m_xml;
    }

    @Override
    public int hashCode() {
        if (this.m_contentValue == null) {
            return 0;
        }
        if (this.m_hashCode == 0) {
            StringBuffer result = new StringBuffer(64);
            result.append(this.m_contentValue.getDocument().getFile().getStructureId().toString());
            result.append('/');
            result.append(this.m_contentValue.getLocale());
            result.append('/');
            result.append(this.m_contentValue.getPath());
            this.m_hashCode = result.toString().hashCode();
        }
        return this.m_hashCode;
    }

    @Deprecated
    public CmsObject obtainCmsObject() {
        return this.m_cms;
    }

    @Deprecated
    public I_CmsXmlContentValue obtainContentValue() {
        return this.m_contentValue;
    }

    @Override
    public String toString() {
        if (this.m_contentValue == null) {
            return "";
        }
        if (this.m_contentValue.isSimpleType()) {
            String value = this.m_contentValue.getStringValue(this.m_cms);
            if (this.m_macroResolver == null) {
                return value;
            }
            return this.m_macroResolver.resolveMacros(value);
        }
        return "";
    }

    protected String createPath(Object input) {
        return CmsXmlUtils.concatXpath(this.m_contentValue.getPath(), String.valueOf(input));
    }

    protected static class NullValueInfo {
        private I_CmsXmlDocument m_content;
        private Locale m_locale;
        private I_CmsXmlContentValue m_parentValue;
        private String m_valueName;

        protected NullValueInfo(I_CmsXmlContentValue parentValue, String valueName) {
            this.m_parentValue = parentValue;
            this.m_valueName = valueName;
        }

        protected NullValueInfo(I_CmsXmlDocument content, String valueName, Locale locale) {
            this.m_content = content;
            this.m_valueName = valueName;
            this.m_locale = locale;
        }

        public I_CmsXmlDocument getContent() {
            return this.m_content;
        }

        public Locale getLocale() {
            return this.m_locale;
        }

        public I_CmsXmlContentValue getParentValue() {
            return this.m_parentValue;
        }

        public String getValueName() {
            return this.m_valueName;
        }
    }

    public class CmsHasValueTransformer
    implements Transformer {
        public Object transform(Object input) {
            return CmsJspContentAccessValueWrapper.this.getContentValue().getDocument().hasValue(CmsJspContentAccessValueWrapper.this.createPath(input), CmsJspContentAccessValueWrapper.this.getContentValue().getLocale());
        }
    }

    public class CmsRdfaTransformer
    implements Transformer {
        public Object transform(Object input) {
            if (CmsJspContentAccessValueWrapper.isDirectEditEnabled(CmsJspContentAccessValueWrapper.this.getCmsObject())) {
                return CmsContentService.getRdfaAttributes(CmsJspContentAccessValueWrapper.this.getContentValue(), String.valueOf(input));
            }
            return "";
        }
    }

    public class CmsSubValueListTransformer
    implements Transformer {
        public Object transform(Object input) {
            List<I_CmsXmlContentValue> values = CmsJspContentAccessValueWrapper.this.getContentValue().getDocument().getSubValues(CmsJspContentAccessValueWrapper.this.createPath(input), CmsJspContentAccessValueWrapper.this.getContentValue().getLocale());
            ArrayList<CmsJspContentAccessValueWrapper> result = new ArrayList<CmsJspContentAccessValueWrapper>();
            for (I_CmsXmlContentValue value : values) {
                result.add(CmsJspContentAccessValueWrapper.createWrapper(CmsJspContentAccessValueWrapper.this.getCmsObject(), value, CmsJspContentAccessValueWrapper.this.getContentValue(), value.getName()));
            }
            return result;
        }
    }

    public class CmsValueTransformer
    implements Transformer {
        public Object transform(Object input) {
            if (CmsJspContentAccessValueWrapper.this.getContentValue() != null) {
                I_CmsXmlContentValue value = CmsJspContentAccessValueWrapper.this.getContentValue().getDocument().getValue(CmsJspContentAccessValueWrapper.this.createPath(input), CmsJspContentAccessValueWrapper.this.getContentValue().getLocale());
                return CmsJspContentAccessValueWrapper.createWrapper(CmsJspContentAccessValueWrapper.this.getCmsObject(), value, CmsJspContentAccessValueWrapper.this.getContentValue(), (String)input);
            }
            return NULL_VALUE_WRAPPER;
        }
    }

    public class CmsValueListTransformer
    implements Transformer {
        public Object transform(Object input) {
            List<I_CmsXmlContentValue> values = CmsJspContentAccessValueWrapper.this.getContentValue().getDocument().getValues(CmsJspContentAccessValueWrapper.this.createPath(input), CmsJspContentAccessValueWrapper.this.getContentValue().getLocale());
            ArrayList<CmsJspContentAccessValueWrapper> result = new ArrayList<CmsJspContentAccessValueWrapper>();
            for (I_CmsXmlContentValue value : values) {
                result.add(CmsJspContentAccessValueWrapper.createWrapper(CmsJspContentAccessValueWrapper.this.getCmsObject(), value, CmsJspContentAccessValueWrapper.this.getContentValue(), (String)input));
            }
            return result;
        }
    }

    public class CmsXmlValueTransformer
    implements Transformer {
        public Object transform(Object input) {
            Node node = CmsJspContentAccessValueWrapper.this.getContentValue().getElement().selectSingleNode(input.toString());
            if (node != null) {
                return node.getStringValue();
            }
            return "";
        }
    }
}

