/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.jsp.util;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.opencms.ade.configuration.CmsADEConfigData;
import org.opencms.ade.containerpage.shared.CmsFormatterConfig;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.flex.CmsFlexController;
import org.opencms.jsp.CmsJspTagContainer;
import org.opencms.jsp.util.CmsJspContentAccessBean;
import org.opencms.jsp.util.CmsJspElementSettingValueWrapper;
import org.opencms.jsp.util.CmsJspStandardContextBean;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsUUID;
import org.opencms.xml.containerpage.CmsContainerBean;
import org.opencms.xml.containerpage.CmsContainerElementBean;
import org.opencms.xml.containerpage.CmsContainerPageBean;
import org.opencms.xml.containerpage.CmsFormatterConfiguration;
import org.opencms.xml.containerpage.I_CmsFormatterBean;
import org.opencms.xml.content.CmsXmlContentProperty;

public class CmsJspContainerPageWrapper {
    private static final Log LOG = CmsLog.getLog(CmsJspContainerPageWrapper.class);
    private CmsContainerPageBean m_page;
    private CmsObject m_cms;

    public CmsJspContainerPageWrapper(CmsObject cms, CmsContainerPageBean page) {
        this.m_cms = cms;
        this.m_page = page;
    }

    public boolean containsElement(CmsUUID elementId) {
        return this.m_page.containsElement(elementId);
    }

    public Map<String, CmsContainerBean> getContainers() {
        return this.m_page.getContainers();
    }

    public Map<CmsUUID, Boolean> getContainsElement() {
        return this.m_page.getContainsElement();
    }

    public List<CmsUUID> getElementIds() {
        return this.m_page.getElementIds();
    }

    public List<CmsContainerElementBean> getElements() {
        return this.m_page.getElements();
    }

    public List<String> getNames() {
        return this.m_page.getNames();
    }

    public Map<?, ?> getSettingsForElement(String elementInstanceId) {
        for (CmsContainerBean container : this.m_page.getContainers().values()) {
            for (CmsContainerElementBean element : container.getElements()) {
                String formatterConfigId;
                I_CmsFormatterBean dynamicFmt;
                if (!Objects.equals(element.getInstanceId(), elementInstanceId)) continue;
                String containerName = container.getName();
                Map<String, String> settings = element.getSettings();
                I_CmsFormatterBean formatter = null;
                CmsADEConfigData config = OpenCms.getADEManager().lookupConfigurationWithCache(this.m_cms, this.m_cms.getRequestContext().addSiteRoot(this.m_cms.getRequestContext().getUri()));
                if (settings != null && (dynamicFmt = config.findFormatter(formatterConfigId = settings.get(CmsFormatterConfig.getSettingsKeyForContainer(containerName)))) != null) {
                    formatter = dynamicFmt;
                }
                if (formatter == null) {
                    try {
                        CmsResource resource = this.m_cms.readResource(element.getId(), CmsResourceFilter.ignoreExpirationOffline(this.m_cms));
                        CmsFormatterConfiguration formatters = config.getFormatters(this.m_cms, resource);
                        int width = -2;
                        try {
                            width = Integer.parseInt(container.getWidth());
                        }
                        catch (Exception e) {
                            LOG.debug((Object)e.getLocalizedMessage(), (Throwable)e);
                        }
                        formatter = formatters.getDefaultSchemaFormatter(container.getType(), width);
                    }
                    catch (CmsException e1) {
                        if (LOG.isWarnEnabled()) {
                            LOG.warn((Object)e1.getLocalizedMessage(), (Throwable)e1);
                        }
                    }
                    catch (Exception e) {
                        LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                    }
                }
                I_CmsFormatterBean finalFormatter = formatter;
                Map<String, CmsXmlContentProperty> formatterSettingsConfig = OpenCms.getADEManager().getFormatterSettings(this.m_cms, config, formatter, element.getResource(), this.m_cms.getRequestContext().getLocale(), null);
                HashSet<String> keys = new HashSet<String>(element.getSettings().keySet());
                HashMap<String, CmsJspElementSettingValueWrapper> result = new HashMap<String, CmsJspElementSettingValueWrapper>();
                for (String key : keys) {
                    String value = element.getSettings().get(key);
                    boolean exists = finalFormatter != null ? formatterSettingsConfig.get(key) != null || finalFormatter.getSettings(config).containsKey(key) : value != null;
                    result.put(key, new CmsJspElementSettingValueWrapper(this.m_cms, element.getSettings().get(key), exists));
                }
                return result;
            }
        }
        return CmsJspContentAccessBean.CONSTANT_NULL_VALUE_WRAPPER_MAP;
    }

    public Set<String> getTypes() {
        return this.m_page.getTypes();
    }

    public String renderContainer(CmsJspStandardContextBean context, String name) {
        CmsContainerBean container = this.findContainer(name);
        if (container == null) {
            return null;
        }
        return this.render(context, container);
    }

    private CmsContainerBean findContainer(String name) {
        CmsContainerBean result = this.m_page.getContainers().get(name);
        if (result == null) {
            for (Map.Entry<String, CmsContainerBean> entry : this.m_page.getContainers().entrySet()) {
                if (!entry.getKey().endsWith("-" + name)) continue;
                result = entry.getValue();
                break;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String render(CmsJspStandardContextBean context, CmsContainerBean container) {
        CmsFlexController controller = CmsFlexController.getController(context.getRequest());
        CmsObject m_cms = context.getCmsObject();
        CmsContainerBean oldContainer = context.getContainer();
        CmsContainerElementBean oldElement = context.getRawElement();
        CmsContainerPageBean oldPage = context.getPage();
        boolean oldForceDisableEdit = context.isForceDisableEditMode();
        Locale locale = m_cms.getRequestContext().getLocale();
        context.getRequest();
        try {
            String resultHtml;
            context.setContainer(container);
            context.setPage(this.m_page);
            context.setForceDisableEditMode(true);
            int containerWidth = -1;
            try {
                containerWidth = Integer.parseInt(container.getWidth());
            }
            catch (Exception e) {
                LOG.debug((Object)e.getLocalizedMessage(), (Throwable)e);
            }
            CmsADEConfigData adeConfig = context.getSitemapConfigInternal();
            StringBuilder buffer = new StringBuilder();
            for (CmsContainerElementBean element : container.getElements()) {
                try {
                    element.initResource(m_cms);
                    I_CmsFormatterBean formatterBean = CmsJspTagContainer.ensureValidFormatterSettings(m_cms, element, adeConfig, container.getName(), container.getType(), containerWidth);
                    element.initSettings(m_cms, adeConfig, formatterBean, locale, (ServletRequest)controller.getCurrentRequest(), null);
                    context.setElement(element);
                    CmsResource formatterRes = m_cms.readResource(formatterBean.getJspStructureId(), CmsResourceFilter.IGNORE_EXPIRATION);
                    byte[] formatterOutput = OpenCms.getResourceManager().getLoader(formatterRes).dump(m_cms, formatterRes, null, locale, (HttpServletRequest)controller.getCurrentRequest(), (HttpServletResponse)controller.getCurrentResponse());
                    String encoding = controller.getCurrentResponse().getEncoding();
                    String formatterOutputStr = new String(formatterOutput, encoding);
                    buffer.append(formatterOutputStr);
                }
                catch (Exception e) {
                    LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                }
            }
            String string = resultHtml = buffer.toString();
            return string;
        }
        finally {
            context.setPage(oldPage);
            context.setContainer(oldContainer);
            context.setElement(oldElement);
            context.setForceDisableEditMode(oldForceDisableEdit);
        }
    }
}

