/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.jsp.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.collections.Transformer;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.relations.CmsCategory;
import org.opencms.relations.CmsCategoryService;
import org.opencms.util.CmsCollectionsGenericWrapper;

public class CmsJspCategoryAccessBean {
    private static final Log LOG = CmsLog.getLog(CmsJspCategoryAccessBean.class);
    List<CmsCategory> m_categories;
    String m_mainCategoryPath;
    Map<String, CmsJspCategoryAccessBean> m_subCategories;
    private CmsObject m_cms;

    public CmsJspCategoryAccessBean(CmsObject cms, CmsResource resource) {
        this(cms, CmsJspCategoryAccessBean.getCategories(cms, resource), "");
    }

    CmsJspCategoryAccessBean(CmsObject cms, List<CmsCategory> categories, String mainCategoryPath) {
        this.m_cms = cms;
        String string = this.m_mainCategoryPath = mainCategoryPath.isEmpty() || mainCategoryPath.endsWith("/") ? mainCategoryPath : mainCategoryPath + "/";
        if (this.m_mainCategoryPath.isEmpty()) {
            this.m_categories = categories;
        } else {
            ArrayList<CmsCategory> filteredCategories = new ArrayList<CmsCategory>();
            for (CmsCategory category : categories) {
                if (!category.getPath().startsWith(this.m_mainCategoryPath) || category.getPath().equals(this.m_mainCategoryPath)) continue;
                filteredCategories.add(category);
            }
            this.m_categories = filteredCategories;
        }
        this.m_categories = CmsCategoryService.getInstance().localizeCategories(cms, this.m_categories, cms.getRequestContext().getLocale());
    }

    private static List<CmsCategory> getCategories(CmsObject cms, CmsResource resource) {
        if (null != resource && null != cms) {
            try {
                return CmsCategoryService.getInstance().readResourceCategories(cms, resource);
            }
            catch (CmsException e) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        return new ArrayList<CmsCategory>(0);
    }

    public boolean contains(String categoryPath) {
        if (null != this.m_categories && categoryPath != null) {
            return this.m_categories.stream().anyMatch(c -> categoryPath.equals(c.getPath()));
        }
        return false;
    }

    public boolean containsAll(Collection<String> categoryPaths) {
        if (categoryPaths == null || categoryPaths.size() == 0) {
            return true;
        }
        return categoryPaths.stream().allMatch(path -> this.contains((String)path));
    }

    public boolean containsAny(Collection<String> categoryPaths) {
        if (categoryPaths == null || categoryPaths.size() == 0) {
            return false;
        }
        return categoryPaths.stream().anyMatch(path -> this.contains((String)path));
    }

    public List<CmsCategory> getAllItems() {
        return this.m_categories;
    }

    public boolean getIsEmpty() {
        return this.m_categories.isEmpty();
    }

    public List<CmsCategory> getLeafItems() {
        ArrayList<CmsCategory> result = new ArrayList<CmsCategory>();
        if (this.m_categories.isEmpty()) {
            return result;
        }
        Iterator<CmsCategory> it = this.m_categories.iterator();
        CmsCategory current = it.next();
        while (it.hasNext()) {
            CmsCategory next = it.next();
            if (!next.getPath().startsWith(current.getPath())) {
                result.add(current);
            }
            current = next;
        }
        result.add(current);
        return result;
    }

    public Map<String, CmsJspCategoryAccessBean> getSubCategories() {
        if (this.m_subCategories == null) {
            this.m_subCategories = CmsCollectionsGenericWrapper.createLazyMap(new Transformer(){

                public Object transform(Object pathPrefix) {
                    return new CmsJspCategoryAccessBean(CmsJspCategoryAccessBean.this.m_cms, CmsJspCategoryAccessBean.this.m_categories, (String)pathPrefix);
                }
            });
        }
        return this.m_subCategories;
    }

    public List<CmsCategory> getTopItems() {
        ArrayList<CmsCategory> categories = new ArrayList<CmsCategory>();
        String matcher = Pattern.quote(this.m_mainCategoryPath) + "[^/]*/";
        for (CmsCategory category : this.m_categories) {
            if (!category.getPath().matches(matcher)) continue;
            categories.add(category);
        }
        return categories;
    }
}

