/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.jsp.util;

import java.io.IOException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import org.apache.commons.logging.Log;
import org.opencms.ade.configuration.CmsADEConfigData;
import org.opencms.cache.CmsVfsMemoryObjectCache;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.flex.CmsFlexController;
import org.opencms.jsp.CmsJspTagInclude;
import org.opencms.jsp.util.CmsJspStandardContextBean;
import org.opencms.jsp.util.CmsMacroFormatterResolver;
import org.opencms.jsp.util.Messages;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.CmsRuntimeException;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsRequestUtil;
import org.opencms.util.CmsUUID;
import org.opencms.xml.containerpage.CmsContainerElementBean;
import org.opencms.xml.containerpage.CmsDynamicFunctionBean;
import org.opencms.xml.containerpage.CmsDynamicFunctionParser;
import org.opencms.xml.containerpage.CmsFunctionFormatterBean;
import org.opencms.xml.containerpage.I_CmsFormatterBean;
import org.opencms.xml.content.CmsXmlContent;
import org.opencms.xml.content.CmsXmlContentFactory;

public class CmsFunctionRenderer {
    private static final Log LOG = CmsLog.getLog(CmsFunctionRenderer.class);
    private CmsObject m_cms;
    private PageContext m_context;
    private CmsJspStandardContextBean m_contextBean;
    private CmsContainerElementBean m_element;
    private HttpServletRequest m_request;
    private HttpServletResponse m_response;

    public CmsFunctionRenderer(PageContext context, HttpServletRequest req, HttpServletResponse res) {
        this.m_context = context;
        this.m_request = req;
        this.m_response = res;
        CmsFlexController controller = CmsFlexController.getController((ServletRequest)req);
        if (controller == null) {
            this.handleMissingFlexController();
            return;
        }
        this.m_cms = controller.getCmsObject();
        this.m_contextBean = CmsJspStandardContextBean.getInstance((ServletRequest)this.m_request);
        this.m_element = this.m_contextBean.getElement();
    }

    public static String defaultHtml(HttpServletRequest request) {
        CmsObject cms = CmsFlexController.getController((ServletRequest)request).getCmsObject();
        if (cms.getRequestContext().getCurrentProject().isOnlineProject()) {
            return "<div><!--Dynamic function not configured--></div>";
        }
        Locale locale = OpenCms.getWorkplaceManager().getWorkplaceLocale(cms);
        String message = Messages.get().getBundle(locale).key("GUI_FUNCTION_DEFAULT_HTML_0");
        return "<div style=\"border: 2px solid red; padding: 10px;\">" + message + "</div>";
    }

    public static CmsResource getDefaultFunctionInstance(CmsObject cms) {
        String path = "/system/modules/org.opencms.base/formatters/function-default.xml";
        return CmsFunctionRenderer.getDefaultResource(cms, path);
    }

    public static CmsResource getDefaultFunctionJsp(CmsObject cms) {
        return CmsFunctionRenderer.getDefaultResource(cms, "/system/modules/org.opencms.base/formatters/function-default.jsp");
    }

    private static CmsResource getDefaultResource(CmsObject cms, String path) {
        CmsResource resource = (CmsResource)CmsVfsMemoryObjectCache.getVfsMemoryObjectCache().getCachedObject(cms, path);
        if (resource == null) {
            try {
                resource = cms.readResource(path);
                CmsVfsMemoryObjectCache.getVfsMemoryObjectCache().putCachedObject(cms, path, resource);
            }
            catch (CmsException e) {
                LOG.warn((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        return resource;
    }

    public void render() throws IOException, JspException {
        boolean isNewFunctionType = OpenCms.getResourceManager().matchResourceType("function_config", this.m_element.getResource().getTypeId());
        if (isNewFunctionType) {
            CmsFunctionFormatterBean function = this.getFormatterBean(this.m_cms);
            if (function != null) {
                CmsUUID jspId = function.getRealJspId();
                if (jspId != null) {
                    CmsJspTagInclude.includeTagAction(this.m_context, this.m_cms.getRequestContext().removeSiteRoot(function.getRealJspRootPath()), null, this.m_cms.getRequestContext().getLocale(), false, this.m_cms.getRequestContext().getCurrentProject().isOnlineProject(), function.getParameters(), CmsRequestUtil.getAttributeMap((ServletRequest)this.m_request), (ServletRequest)this.m_request, (ServletResponse)this.m_response);
                } else {
                    this.m_context.getOut().print(CmsFunctionRenderer.defaultHtml(this.m_request));
                }
            } else {
                this.m_context.getOut().print(CmsFunctionRenderer.defaultHtml(this.m_request));
            }
        } else {
            CmsDynamicFunctionBean.Format format = this.getFunctionFormat();
            if (format != null && this.m_cms.existsResource(format.getJspStructureId())) {
                try {
                    CmsResource jspResource = this.m_cms.readResource(format.getJspStructureId());
                    HashMap<String, String[]> params = new HashMap<String, String[]>();
                    for (Map.Entry<String, String> paramEntry : format.getParameters().entrySet()) {
                        params.put(paramEntry.getKey(), new String[]{paramEntry.getValue()});
                    }
                    CmsJspTagInclude.includeTagAction(this.m_context, this.m_cms.getSitePath(jspResource), null, this.m_cms.getRequestContext().getLocale(), false, this.m_cms.getRequestContext().getCurrentProject().isOnlineProject(), params, CmsRequestUtil.getAttributeMap((ServletRequest)this.m_request), (ServletRequest)this.m_request, (ServletResponse)this.m_response);
                }
                catch (CmsException e) {
                    LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                }
            } else {
                this.m_context.getOut().print(CmsFunctionRenderer.defaultHtml(this.m_request));
            }
        }
    }

    private CmsFunctionFormatterBean getFormatterBean(CmsObject cms) {
        CmsADEConfigData config = OpenCms.getADEManager().lookupConfiguration(cms, cms.getRequestContext().getRootUri());
        I_CmsFormatterBean formatterConfig = config.findFormatter(this.m_element.getId());
        CmsFunctionFormatterBean function = (CmsFunctionFormatterBean)formatterConfig;
        return function;
    }

    private CmsDynamicFunctionBean.Format getFunctionFormat() {
        CmsDynamicFunctionBean functionBean = null;
        try {
            CmsXmlContent content = CmsXmlContentFactory.unmarshal(this.m_cms, this.m_cms.readFile(this.m_element.getResource()));
            CmsDynamicFunctionParser parser = new CmsDynamicFunctionParser();
            functionBean = parser.parseFunctionBean(this.m_cms, content);
        }
        catch (CmsException e) {
            LOG.debug((Object)e.getLocalizedMessage(), (Throwable)e);
            return null;
        }
        CmsJspStandardContextBean contextBean = CmsJspStandardContextBean.getInstance((ServletRequest)this.m_request);
        String type = contextBean.getContainer().getType();
        String width = contextBean.getContainer().getWidth();
        int widthNum = -1;
        try {
            widthNum = Integer.parseInt(width);
        }
        catch (NumberFormatException e) {
            LOG.debug((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        return functionBean.getFormatForContainer(this.m_cms, type, widthNum);
    }

    private void handleMissingFlexController() {
        throw new CmsRuntimeException(org.opencms.jsp.Messages.get().container("ERR_MISSING_CMS_CONTROLLER_1", CmsMacroFormatterResolver.class.getName()));
    }
}

