/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.jsp.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.opencms.ade.configuration.CmsADEConfigData;
import org.opencms.file.CmsObject;
import org.opencms.file.types.I_CmsResourceType;
import org.opencms.i18n.CmsMessages;
import org.opencms.i18n.CmsMultiMessages;
import org.opencms.jsp.util.CmsJspStandardContextBean;
import org.opencms.jsp.util.CmsKeyDummyMacroResolver;
import org.opencms.jsp.util.CmsSettingDefinitionWrapper;
import org.opencms.jsp.util.I_CmsFormatterInfo;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsMacroResolver;
import org.opencms.xml.CmsXmlContentDefinition;
import org.opencms.xml.containerpage.CmsFormatterBean;
import org.opencms.xml.containerpage.CmsFunctionFormatterBean;
import org.opencms.xml.containerpage.I_CmsFormatterBean;
import org.opencms.xml.content.CmsXmlContentProperty;

public class CmsFormatterInfoWrapper
implements I_CmsFormatterInfo {
    private CmsObject m_cms;
    private CmsADEConfigData m_config;
    private I_CmsFormatterBean m_formatter;
    private CmsMacroResolver m_macroResolver;

    public CmsFormatterInfoWrapper(CmsObject cms, CmsADEConfigData config, I_CmsFormatterBean formatter) {
        this.m_cms = cms;
        this.m_formatter = formatter;
        this.m_config = config;
    }

    public static CmsMacroResolver getMacroResolverForFormatter(CmsObject cms, Locale locale, I_CmsFormatterBean formatter) {
        CmsMacroResolver resolver = new CmsMacroResolver();
        resolver.setCmsObject(cms);
        CmsMultiMessages messages = new CmsMultiMessages(locale);
        messages.addMessages(OpenCms.getWorkplaceManager().getMessages(locale));
        for (String type : formatter.getResourceTypeNames()) {
            try {
                I_CmsResourceType typeObj = OpenCms.getResourceManager().getResourceType(type);
                String schema = typeObj.getConfiguration().getString("schema", null);
                if (schema == null) continue;
                CmsXmlContentDefinition contentDef = CmsXmlContentDefinition.unmarshal(cms, schema);
                CmsMessages schemaMessages = contentDef.getContentHandler().getMessages(locale);
                messages.addMessages(schemaMessages);
            }
            catch (Exception e) {
                CmsJspStandardContextBean.LOG.warn((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        resolver.setCmsObject(cms);
        resolver.setKeepEmptyMacros(true);
        resolver.setMessages(messages);
        return resolver;
    }

    public List<String> getContainerTypes() {
        return new ArrayList<String>(this.m_formatter.getContainerTypes());
    }

    public String getDefinition() {
        return this.m_formatter.getLocation();
    }

    @Override
    public String getDescription() {
        Locale locale = this.m_cms.getRequestContext().getLocale();
        return this.getDescription(locale);
    }

    @Override
    public String getDescription(Locale locale) {
        String result = this.m_formatter.getDescription(locale);
        return result;
    }

    @Override
    public String getDescriptionKey() {
        return CmsKeyDummyMacroResolver.getKey(this.m_formatter.getDescription(null), this.m_macroResolver);
    }

    public List<String> getDescriptionKeys() {
        return CmsKeyDummyMacroResolver.getKeys(this.m_formatter.getDescription(null), this.m_macroResolver);
    }

    @Override
    public String getDescriptionRaw() {
        return this.m_formatter.getDescription(null);
    }

    public String getDisplay() {
        return this.m_formatter.getDisplayType();
    }

    @Override
    public boolean getIsActive() {
        return true;
    }

    public boolean getIsDetailFormatter() {
        return this.m_formatter.isDetailFormatter();
    }

    public boolean getIsDisplayFormatter() {
        return this.m_formatter.isDisplayFormatter();
    }

    @Override
    public boolean getIsFormatter() {
        return this.m_formatter instanceof CmsFormatterBean;
    }

    @Override
    public boolean getIsFunction() {
        return this.m_formatter instanceof CmsFunctionFormatterBean;
    }

    @Override
    public boolean getIsResourceType() {
        return false;
    }

    public String getJsp() {
        if (this.m_formatter instanceof CmsFunctionFormatterBean) {
            return ((CmsFunctionFormatterBean)this.m_formatter).getRealJspRootPath();
        }
        return this.m_formatter.getJspRootPath();
    }

    public String getKey() {
        return this.m_formatter.getKey();
    }

    public int getMaxWidth() {
        return this.m_formatter.getMaxWidth();
    }

    public int getMinWidth() {
        return this.m_formatter.getMinWidth();
    }

    @Override
    public String getName() {
        return this.getKey();
    }

    @Override
    public String getNiceName() {
        return this.m_formatter.getNiceName(this.m_cms.getRequestContext().getLocale());
    }

    @Override
    public String getNiceNameKey() {
        return CmsKeyDummyMacroResolver.getKey(this.m_formatter.getNiceName(null), this.m_macroResolver);
    }

    @Override
    public String getNiceNameRaw() {
        return this.m_formatter.getNiceName(null);
    }

    public int getRank() {
        return this.m_formatter.getRank();
    }

    public List<CmsSettingDefinitionWrapper> getSettings() {
        Map<String, CmsXmlContentProperty> settingDefs = this.m_formatter.getSettings(this.m_config);
        ArrayList<CmsSettingDefinitionWrapper> result = new ArrayList<CmsSettingDefinitionWrapper>();
        for (Map.Entry<String, CmsXmlContentProperty> entry : settingDefs.entrySet()) {
            CmsSettingDefinitionWrapper setting = new CmsSettingDefinitionWrapper(this.m_cms, entry.getValue(), locale -> CmsFormatterInfoWrapper.getMacroResolverForFormatter(this.m_cms, locale, this.m_formatter));
            result.add(setting);
        }
        return result;
    }

    public List<String> getTypes() {
        ArrayList<String> result = new ArrayList<String>(this.m_formatter.getResourceTypeNames());
        Collections.sort(result);
        return result;
    }

    @Override
    public String niceName(Locale locale) {
        return this.m_formatter.getNiceName(locale);
    }
}

