/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.jsp.userdata;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.jsp.userdata.CmsUserDataRequestInfo;
import org.opencms.jsp.userdata.CmsUserDataRequestManager;
import org.opencms.main.CmsLog;
import org.opencms.main.CmsResourceInitException;
import org.opencms.main.I_CmsResourceInit;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsFileUtil;
import org.opencms.util.CmsStringUtil;

public class CmsUserDataResourceHandler
implements I_CmsResourceInit {
    public static final String PREFIX = "/userdatarequest/";
    private static boolean m_initialized;
    private static final Log LOG;

    public CmsUserDataResourceHandler() {
        m_initialized = true;
    }

    public static boolean isInitialized() {
        return m_initialized;
    }

    @Override
    public CmsResource initResource(CmsResource resource, CmsObject cms, HttpServletRequest req, HttpServletResponse res) throws CmsResourceInitException {
        if (resource != null || req == null || res == null) {
            return resource;
        }
        CmsUserDataRequestManager manager = OpenCms.getUserDataRequestManager();
        if (manager == null) {
            return null;
        }
        String uri = cms.getRequestContext().getUri();
        if (!uri.startsWith(PREFIX)) {
            return null;
        }
        String infoStr = uri.substring(PREFIX.length());
        String key = CmsFileUtil.removeTrailingSeparator(infoStr);
        if (key.indexOf("/") >= 0) {
            return null;
        }
        CmsUserDataRequestInfo requestInfo = OpenCms.getUserDataRequestManager().getRequestStore().load(infoStr).orElse(null);
        if (requestInfo == null) {
            return null;
        }
        String auth = req.getParameter("auth");
        if (requestInfo.isExpired() || !requestInfo.checkAuthCode(auth)) {
            return null;
        }
        String info = requestInfo.getInfoHtml();
        if (CmsStringUtil.isEmpty(info)) {
            LOG.info((Object)"Invalid user data request object.");
            return null;
        }
        res.setCharacterEncoding("UTF-8");
        res.addHeader("Content-Disposition", "attachment; filename=\"userdata.html\"");
        try {
            String html = "<html><body>" + requestInfo.getInfoHtml() + "</body></html>";
            res.getOutputStream().write(html.getBytes("UTF-8"));
            res.setStatus(200);
            CmsResourceInitException e = new CmsResourceInitException(CmsUserDataResourceHandler.class);
            e.setClearErrors(true);
            throw e;
        }
        catch (CmsResourceInitException e) {
            throw e;
        }
        catch (Exception e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            return null;
        }
    }

    static {
        LOG = CmsLog.getLog(CmsUserDataResourceHandler.class);
    }
}

