/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.jsp.userdata;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.mail.internet.AddressException;
import org.apache.commons.logging.Log;
import org.apache.commons.mail.EmailException;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProperty;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsUser;
import org.opencms.i18n.CmsEncoder;
import org.opencms.i18n.CmsMessages;
import org.opencms.jsp.userdata.CmsUserDataRequestConfig;
import org.opencms.jsp.userdata.CmsUserDataRequestException;
import org.opencms.jsp.userdata.CmsUserDataRequestInfo;
import org.opencms.jsp.userdata.CmsUserDataRequestManager;
import org.opencms.jsp.userdata.CmsUserDataRequestStore;
import org.opencms.jsp.userdata.CmsUserDataRequestType;
import org.opencms.jsp.userdata.CmsUserDataResourceHandler;
import org.opencms.jsp.userdata.Messages;
import org.opencms.jsp.util.CmsJspStandardContextBean;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.security.CmsAuthentificationException;
import org.opencms.security.CmsOrganizationalUnit;
import org.opencms.util.CmsCollectionsGenericWrapper;
import org.opencms.util.CmsStringUtil;

public class CmsJspUserDataRequestBean {
    public static final String ACTION_REQUEST = "request";
    public static final String ACTION_VIEW = "view";
    public static final String ACTION_VIEWAUTH = "viewauth";
    public static final String PARAM_ACTION = "action";
    public static final String PARAM_AUTH = "auth";
    public static final String PARAM_EMAIL = "email";
    public static final String PARAM_PASSWORD = "password";
    public static final String PARAM_ROOTPATH = "rootpath";
    public static final String PARAM_UDRID = "udrid";
    public static final String PARAM_USER = "user";
    private static final Log LOG = CmsLog.getLog(CmsJspUserDataRequestBean.class);
    private CmsUserDataRequestConfig m_config;
    private String m_downloadLink;
    private String m_errorHtml;
    private CmsUserDataRequestInfo m_info;
    private String m_infoHtml;
    private Map<String, String> m_params;
    private Map<String, String> m_texts;

    public CmsJspUserDataRequestBean() {
        LOG.debug((Object)"Creating user data request bean.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String action(CmsObject cms, Map<String, String[]> reqParameters) throws CmsException {
        this.init(reqParameters);
        CmsResource page = cms.readResource(cms.getRequestContext().getUri());
        List<CmsProperty> props = cms.readPropertyObjects(page, true);
        CmsProperty defaultOuProp = CmsProperty.get("udr.defaultou", props);
        String configuredOu = null;
        if (defaultOuProp != null) {
            configuredOu = defaultOuProp.getValue();
        }
        CmsProperty configPathProp = CmsProperty.get("udr.config", props);
        String configPath = configPathProp.getValue();
        CmsUserDataRequestManager manager = OpenCms.getUserDataRequestManager();
        CmsMessages messages = Messages.get().getBundle(cms.getRequestContext().getLocale());
        this.m_config = manager.loadConfig(cms, configPath).orElse(null);
        if (this.m_config == null) {
            this.m_errorHtml = messages.key("ERR_CONFIG_NOT_SET_0");
            return State.error.toString();
        }
        String functionDetail = CmsJspStandardContextBean.getFunctionDetailLink(cms, "function@", "userdatarequest", true);
        if (functionDetail.contains("[")) {
            this.m_errorHtml = messages.key("ERR_FUNCTION_DETAIL_PAGE_NOT_SET_0");
            return State.error.toString();
        }
        if (!CmsUserDataResourceHandler.isInitialized()) {
            this.m_errorHtml = messages.key("ERR_RESOURCE_INIT_HANDLER_NOT_CONFIGURED_0");
            return State.error.toString();
        }
        String email = this.m_params.get(PARAM_EMAIL);
        String user = this.m_params.get(PARAM_USER);
        String password = this.m_params.get(PARAM_PASSWORD);
        String path = this.m_params.get(PARAM_ROOTPATH);
        String udrid = CmsEncoder.escapeXml(this.m_params.get(PARAM_UDRID));
        boolean hasEmail = !CmsStringUtil.isEmptyOrWhitespaceOnly(email);
        boolean hasUser = !CmsStringUtil.isEmptyOrWhitespaceOnly(user);
        boolean hasPassword = !CmsStringUtil.isEmptyOrWhitespaceOnly(password);
        String action = CmsEncoder.escapeXml(this.m_params.get(PARAM_ACTION));
        if (!CmsStringUtil.isEmpty(udrid)) {
            this.m_info = manager.getRequestStore().load(udrid).orElse(null);
        }
        if (action == null) {
            return State.form.toString();
        }
        if (ACTION_REQUEST.equals(action)) {
            try {
                if (hasEmail && !hasUser && !hasPassword) {
                    manager.startUserDataRequest(cms, this.m_config, email);
                    return State.formOk.toString();
                }
                if (!hasEmail && hasUser && hasPassword) {
                    Optional<CmsUser> optUser = this.lookupUser(cms, configuredOu, path = CmsStringUtil.isEmpty(path) ? cms.getRequestContext().addSiteRoot(cms.getRequestContext().getUri()) : path.trim(), user, password);
                    if (optUser.isPresent()) {
                        manager.startUserDataRequest(cms, this.m_config, optUser.get());
                        return State.formOk.toString();
                    }
                    throw new CmsUserDataRequestException("Could not find user.");
                }
                this.m_errorHtml = "invalid combination of parameters.";
                return State.form.toString();
            }
            catch (CmsUserDataRequestException e) {
                this.m_errorHtml = e.getLocalizedMessage();
                return State.form.toString();
            }
            catch (AddressException | EmailException e) {
                LOG.warn((Object)e.getLocalizedMessage(), e);
                this.m_errorHtml = this.m_config.getText("EmailError");
                return State.error.toString();
            }
        }
        if (ACTION_VIEW.equals(action)) {
            CmsUserDataRequestInfo info = manager.getRequestStore().load(udrid).orElse(null);
            if (info == null || info.isExpired()) {
                this.m_errorHtml = this.m_config.getText("InvalidLink");
                return State.error.toString();
            }
            return State.view.toString();
        }
        if (ACTION_VIEWAUTH.equals(action)) {
            CmsUserDataRequestStore store = manager.getRequestStore();
            CmsUserDataRequestInfo info = store.load(udrid).orElse(null);
            if (info == null || info.isExpired()) {
                this.m_errorHtml = this.m_config.getText("InvalidLink");
                return State.error.toString();
            }
            this.m_infoHtml = info.getInfoHtml();
            boolean origForceAbsolute = cms.getRequestContext().isForceAbsoluteLinks();
            cms.getRequestContext().setForceAbsoluteLinks(true);
            try {
                this.m_downloadLink = OpenCms.getLinkManager().substituteLinkForUnknownTarget(cms, "/userdatarequest/" + info.getId() + "?auth=" + info.getAuthCode());
            }
            finally {
                cms.getRequestContext().setForceAbsoluteLinks(origForceAbsolute);
            }
            CmsUserDataRequestType type = info.getType();
            if (CmsUserDataRequestType.email.equals((Object)type)) {
                if (email == null) {
                    return State.view.toString();
                }
                if (email.equals(info.getEmail())) {
                    return State.viewOk.toString();
                }
                this.m_errorHtml = "email address error";
                return State.view.toString();
            }
            if (CmsUserDataRequestType.singleUser.equals((Object)type)) {
                if (hasUser && hasPassword) {
                    try {
                        CmsObject cloneCms = OpenCms.initCmsObject(cms);
                        String fullName = info.getUserName();
                        CmsUser readUser = cms.readUser(fullName);
                        if (!readUser.getSimpleName().equals(user)) {
                            this.m_errorHtml = "login error";
                            return State.view.toString();
                        }
                        cloneCms.loginUser(info.getUserName(), password);
                        return State.viewOk.toString();
                    }
                    catch (CmsException e) {
                        LOG.info((Object)e.getLocalizedMessage(), (Throwable)e);
                        this.m_errorHtml = "login error";
                        return State.view.toString();
                    }
                }
                this.m_errorHtml = "authentication error";
                return State.view.toString();
            }
        } else {
            this.m_errorHtml = "Invalid action: " + action;
            LOG.info((Object)("Invalid action: " + action));
            return State.error.toString();
        }
        return State.form.toString();
    }

    public String getDownloadLink() {
        return this.m_downloadLink;
    }

    public String getErrorHtml() {
        return this.m_errorHtml;
    }

    public String getInfoHtml() {
        return this.m_infoHtml;
    }

    public Map<String, String> getTexts() {
        if (this.m_texts == null) {
            this.m_texts = CmsCollectionsGenericWrapper.createLazyMap(obj -> {
                String key = (String)obj;
                return this.m_config.getText(key);
            });
        }
        return this.m_texts;
    }

    public boolean isError() {
        return this.m_errorHtml != null;
    }

    public boolean isOnlyEmailRequired() {
        return CmsUserDataRequestType.email == this.m_info.getType();
    }

    private void init(Map<String, String[]> requestParams) {
        this.m_params = new HashMap<String, String>();
        for (Map.Entry<String, String[]> entry : requestParams.entrySet()) {
            String[] vals = entry.getValue();
            if (vals.length <= 0) continue;
            String val = vals[0];
            this.m_params.put(entry.getKey(), val);
        }
    }

    private Optional<CmsUser> lookupUser(CmsObject cms, String configuredOu, String path, String user, String password) throws CmsException {
        List<CmsOrganizationalUnit> ous = configuredOu != null ? Collections.singletonList(OpenCms.getOrgUnitManager().readOrganizationalUnit(cms, configuredOu)) : OpenCms.getOrgUnitManager().getOrgUnitsForResource(cms, path);
        CmsObject loginCms = OpenCms.initCmsObject(OpenCms.getDefaultUsers().getUserGuest());
        for (CmsOrganizationalUnit ou : ous) {
            String fullName = CmsStringUtil.joinPaths(ou.getName(), user);
            try {
                loginCms.loginUser(fullName, password);
                return Optional.of(loginCms.getRequestContext().getCurrentUser());
            }
            catch (CmsAuthentificationException e) {
                LOG.debug((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        return Optional.empty();
    }

    static enum State {
        error,
        form,
        formOk,
        view,
        viewOk;

    }
}

