/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.jsp.userdata;

import java.util.List;
import org.jsoup.nodes.Element;
import org.opencms.configuration.CmsParameterConfiguration;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsUser;
import org.opencms.jsp.userdata.CmsUserDataRequestType;
import org.opencms.jsp.userdata.I_CmsUserDataDomain;
import org.opencms.jsp.userdata.Messages;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsStringUtil;
import org.opencms.workplace.CmsWorkplaceMessages;

public class CmsDefaultUserDataDomain
implements I_CmsUserDataDomain {
    private CmsParameterConfiguration m_config = new CmsParameterConfiguration();

    @Override
    public void addConfigurationParameter(String paramName, String paramValue) {
        this.m_config.put(paramName, paramValue);
    }

    @Override
    public void appendInfoHtml(CmsObject cms, CmsUserDataRequestType reqType, List<CmsUser> users, Element element) {
        Element main = element.appendElement("div");
        String headerText = Messages.get().getBundle(cms.getRequestContext().getLocale()).key("GUI_DEFAULT_USERDATA_SECTION_0");
        main.appendElement("h2").text(headerText);
        Element ul = main.appendElement("ul");
        for (CmsUser user : users) {
            Element section = ul.appendElement("li").appendElement("dl");
            Element dl = section.appendElement("dl");
            this.addField(cms, dl, "GUI_USERMANAGEMENT_USER_LOGIN_NAME_0", user.getSimpleName());
            this.addField(cms, dl, "GUI_USERMANAGEMENT_USER_DESCRIPTION_0", user.getDescription(cms.getRequestContext().getLocale()));
            this.addField(cms, dl, "GUI_USERMANAGEMENT_USER_OU_0", CmsStringUtil.joinPaths(user.getOuFqn(), "/"));
            this.addField(cms, dl, "GUI_USER_DATA_FIRSTNAME_0", user.getFirstname());
            this.addField(cms, dl, "GUI_USER_DATA_LASTNAME_0", user.getLastname());
            this.addField(cms, dl, "GUI_USER_DATA_ADDRESS_0", user.getAddress());
            this.addField(cms, dl, "GUI_USER_DATA_CITY_0", user.getCity());
            this.addField(cms, dl, "GUI_USER_DATA_COUNTRY_0", user.getCountry());
            this.addField(cms, dl, "GUI_USER_DATA_EMAIL_0", user.getEmail());
            this.addField(cms, dl, "GUI_USER_DATA_INSTITUTION_0", user.getInstitution());
            this.addField(cms, dl, "GUI_USER_DATA_ZIPCODE_0", user.getZipcode());
        }
    }

    @Override
    public CmsParameterConfiguration getConfiguration() {
        return this.m_config;
    }

    @Override
    public void initConfiguration() {
    }

    @Override
    public void initialize(CmsObject cms) {
    }

    @Override
    public boolean matchesUser(CmsObject cms, CmsUserDataRequestType reqType, CmsUser user) {
        return true;
    }

    public String toString() {
        return this.getClass().getName() + "[" + String.valueOf(this.m_config) + "]";
    }

    private boolean addField(CmsObject cms, Element dl, String key, String value) {
        CmsWorkplaceMessages messages = OpenCms.getWorkplaceManager().getMessages(cms.getRequestContext().getLocale());
        String keyText = messages.key(key);
        if (!CmsStringUtil.isEmpty(value)) {
            dl.appendElement("dt").text(keyText);
            dl.appendElement("dd").text(value);
            return true;
        }
        return false;
    }
}

