/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.jsp.search.config.parser.simplesearch.preconfiguredrestrictions;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.solr.client.solrj.util.ClientUtils;
import org.opencms.jsp.search.config.parser.simplesearch.preconfiguredrestrictions.CmsRestrictionRule;
import org.opencms.jsp.search.config.parser.simplesearch.preconfiguredrestrictions.CmsRestrictionRuleParser;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;

public class CmsRestrictionsBean {
    private static final Log LOG = CmsLog.getLog(CmsRestrictionsBean.class.getName());
    private static final String CONST_IGNORED_RULE = "none";
    private static final String PREFIX_PLAIN = "plain:";
    private Map<String, Map<CmsRestrictionRule, Collection<FieldValues>>> m_restrictions = new HashMap<String, Map<CmsRestrictionRule, Collection<FieldValues>>>();

    public void addRestriction(String ruleString, Collection<String> values) {
        Collection realValues = values.stream().map(v -> v == null || v.trim().length() == 0 ? null : v.trim()).filter(v -> v != null).collect(Collectors.toSet());
        if (realValues.size() > 0) {
            CmsRestrictionRule rule = null;
            if (CONST_IGNORED_RULE.equals(ruleString)) {
                return;
            }
            try {
                rule = CmsRestrictionRuleParser.parseRule(ruleString);
            }
            catch (CmsException e) {
                LOG.warn((Object)("Ignoring unparsable restriction rule '" + ruleString + "'."), (Throwable)e);
                return;
            }
            String type = rule.getType();
            if (null == this.m_restrictions.get(type)) {
                this.m_restrictions.put(type, new HashMap());
            }
            Map<CmsRestrictionRule, Collection<FieldValues>> mapForType = this.m_restrictions.get(type);
            HashSet<FieldValues> fieldValues = new HashSet<FieldValues>(realValues.size());
            for (String value : realValues) {
                if (value.startsWith(PREFIX_PLAIN)) {
                    String realValue = value.substring(PREFIX_PLAIN.length()).trim();
                    fieldValues.add(new FieldValues(FieldValues.FieldType.PLAIN, Collections.singleton(realValue)));
                    continue;
                }
                if (rule.getMatchType().equals((Object)CmsRestrictionRule.MatchType.EXACT)) {
                    fieldValues.add(new FieldValues(FieldValues.FieldType.DEFAULT, Collections.singleton(ClientUtils.escapeQueryChars((String)value))));
                    continue;
                }
                Collection finalValues = Arrays.asList(value.split(" ")).stream().map(word -> ClientUtils.escapeQueryChars((String)word.trim())).collect(Collectors.toSet());
                fieldValues.add(new FieldValues(FieldValues.FieldType.DEFAULT, finalValues));
            }
            mapForType.put(rule, fieldValues);
        } else {
            LOG.debug((Object)("Ignoring restriction with rule '" + ruleString + "' since no real values are provided."));
        }
    }

    public Map<CmsRestrictionRule, Collection<FieldValues>> getRestrictionsForType(String type) {
        return this.m_restrictions.get(type);
    }

    public boolean hasRestrictionForType(String type) {
        return null != this.m_restrictions.get(type);
    }

    public boolean hasRestrictions() {
        return this.m_restrictions.size() > 0;
    }

    public static class FieldValues {
        private FieldType m_type;
        private Collection<String> m_values;

        public FieldValues(FieldType type, Collection<String> values) {
            this.m_type = type;
            this.m_values = Collections.unmodifiableCollection(values);
        }

        public FieldType getFieldType() {
            return this.m_type;
        }

        public Collection<String> getValues() {
            return this.m_values;
        }

        public static enum FieldType {
            PLAIN,
            DEFAULT;

        }
    }
}

