/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.jsp.search.config.parser.simplesearch.daterestrictions;

import java.util.Date;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.jsp.search.config.parser.simplesearch.daterestrictions.CmsDateFromTodayRestriction;
import org.opencms.jsp.search.config.parser.simplesearch.daterestrictions.CmsDatePastFutureRestriction;
import org.opencms.jsp.search.config.parser.simplesearch.daterestrictions.CmsDateRangeRestriction;
import org.opencms.jsp.search.config.parser.simplesearch.daterestrictions.I_CmsDateRestriction;
import org.opencms.main.CmsLog;
import org.opencms.util.CmsStringUtil;
import org.opencms.xml.content.CmsXmlContentValueLocation;

public class CmsDateRestrictionParser {
    public static final String N_RANGE = "Range";
    public static final String N_PAST_FUTURE = "PastFuture";
    public static final String N_FROM_TODAY = "FromToday";
    public static final String N_TO = "To";
    public static final String N_FROM = "From";
    public static final String N_DIRECTION = "Direction";
    public static final String N_UNIT = "Unit";
    public static final String N_COUNT = "Count";
    public static final Log LOG = CmsLog.getLog(CmsDateRestrictionParser.class);
    public CmsObject m_cms;

    public CmsDateRestrictionParser(CmsObject cms) {
        this.m_cms = cms;
    }

    public I_CmsDateRestriction parse(CmsXmlContentValueLocation dateRestriction) {
        I_CmsDateRestriction result = null;
        result = this.parseRange(dateRestriction);
        if (result != null) {
            return result;
        }
        result = this.parseFromToday(dateRestriction);
        if (result != null) {
            return result;
        }
        result = this.parsePastFuture(dateRestriction);
        return result;
    }

    private Date parseDate(CmsXmlContentValueLocation dateLoc) {
        if (dateLoc == null) {
            return null;
        }
        String dateStr = dateLoc.getValue().getStringValue(this.m_cms);
        if (CmsStringUtil.isEmptyOrWhitespaceOnly(dateStr)) {
            return null;
        }
        try {
            return new Date(Long.parseLong(dateStr));
        }
        catch (Exception e) {
            LOG.info((Object)(e.getLocalizedMessage() + " date = " + dateStr), (Throwable)e);
            return null;
        }
    }

    private I_CmsDateRestriction.TimeDirection parseDirection(CmsXmlContentValueLocation location) {
        try {
            return I_CmsDateRestriction.TimeDirection.valueOf(location.getValue().getStringValue(this.m_cms));
        }
        catch (Exception e) {
            return null;
        }
    }

    private I_CmsDateRestriction parseFromToday(CmsXmlContentValueLocation dateRestriction) {
        CmsXmlContentValueLocation location = dateRestriction.getSubValue(N_FROM_TODAY);
        if (location == null) {
            return null;
        }
        CmsXmlContentValueLocation countLoc = location.getSubValue(N_COUNT);
        CmsXmlContentValueLocation unitLoc = location.getSubValue(N_UNIT);
        CmsXmlContentValueLocation directionLoc = location.getSubValue(N_DIRECTION);
        I_CmsDateRestriction.TimeDirection direction = this.parseDirection(directionLoc);
        Integer count = this.parsePositiveNumber(countLoc);
        I_CmsDateRestriction.TimeUnit unit = this.parseUnit(unitLoc);
        if (count == null) {
            return null;
        }
        return new CmsDateFromTodayRestriction(count, unit, direction);
    }

    private I_CmsDateRestriction parsePastFuture(CmsXmlContentValueLocation dateRestriction) {
        CmsXmlContentValueLocation location = dateRestriction.getSubValue(N_PAST_FUTURE);
        if (location == null) {
            return null;
        }
        CmsXmlContentValueLocation directionLoc = location.getSubValue(N_DIRECTION);
        I_CmsDateRestriction.TimeDirection direction = this.parseDirection(directionLoc);
        return new CmsDatePastFutureRestriction(direction);
    }

    private Integer parsePositiveNumber(CmsXmlContentValueLocation loc) {
        if (loc == null) {
            return null;
        }
        try {
            Integer result = Integer.valueOf(loc.getValue().getStringValue(this.m_cms).trim());
            if (result < 0) {
                return null;
            }
            return result;
        }
        catch (Exception e) {
            LOG.info((Object)e.getLocalizedMessage(), (Throwable)e);
            return null;
        }
    }

    private I_CmsDateRestriction parseRange(CmsXmlContentValueLocation dateRestriction) {
        CmsXmlContentValueLocation location = dateRestriction.getSubValue(N_RANGE);
        if (location == null) {
            return null;
        }
        CmsXmlContentValueLocation fromLoc = location.getSubValue(N_FROM);
        CmsXmlContentValueLocation toLoc = location.getSubValue(N_TO);
        Date fromDate = this.parseDate(fromLoc);
        Date toDate = this.parseDate(toLoc);
        if (fromDate != null || toDate != null) {
            return new CmsDateRangeRestriction(fromDate, toDate);
        }
        return null;
    }

    private I_CmsDateRestriction.TimeUnit parseUnit(CmsXmlContentValueLocation location) {
        if (location == null) {
            return null;
        }
        return I_CmsDateRestriction.TimeUnit.valueOf(location.getValue().getStringValue(this.m_cms));
    }
}

