/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.jsp.search.config.parser.simplesearch;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.i18n.CmsLocaleManager;
import org.opencms.jsp.search.config.parser.simplesearch.CmsCategoryFolderRestrictionBean;
import org.opencms.jsp.search.config.parser.simplesearch.CmsConfigurationBean;
import org.opencms.jsp.search.config.parser.simplesearch.CmsGeoFilterBean;
import org.opencms.jsp.search.config.parser.simplesearch.daterestrictions.CmsDateRestrictionParser;
import org.opencms.jsp.search.config.parser.simplesearch.daterestrictions.I_CmsDateRestriction;
import org.opencms.jsp.search.config.parser.simplesearch.preconfiguredrestrictions.CmsRestrictionsBean;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.relations.CmsCategoryService;
import org.opencms.relations.CmsLink;
import org.opencms.util.CmsGeoUtil;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;
import org.opencms.xml.CmsXmlUtils;
import org.opencms.xml.content.CmsXmlContent;
import org.opencms.xml.content.CmsXmlContentFactory;
import org.opencms.xml.content.CmsXmlContentValueLocation;
import org.opencms.xml.types.CmsXmlVfsFileValue;
import org.opencms.xml.types.I_CmsXmlContentValue;

public final class CmsConfigParserUtils {
    static final Log LOG = CmsLog.getLog(CmsConfigParserUtils.class.getName());
    public static final String N_BLACKLIST = "Blacklist";
    public static final String N_CATEGORY = "Category";
    private static final String N_CATEGORY_FOLDER_RESTRICTION = "CategoryFolderFilter";
    private static final String N_COORDINATES = "Coordinates";
    private static final String N_FOLDER = "Folder";
    public static final String N_CATEGORY_MODE = "CategoryMode";
    public static final String N_DATE_RESTRICTION = "DateRestriction";
    public static final String N_DISPLAY_TYPE = "TypesToCollect";
    public static final String N_FILTER_MULTI_DAY = "FilterMultiDay";
    public static final String N_FILTER_QUERY = "FilterQuery";
    public static final String N_GEO_FILTER = "GeoFilter";
    public static final String N_KEY = "Key";
    public static final String N_PARAMETER = "Parameter";
    public static final String N_RADIUS = "Radius";
    public static final String N_SEARCH_FOLDER = "SearchFolder";
    public static final String N_SHOW_EXPIRED = "ShowExpired";
    public static final String N_SORT_ORDER = "SortOrder";
    public static final String N_TITLE = "Title";
    public static final String N_VALUE = "Value";
    public static final String N_MAX_RESULTS = "MaxResults";
    public static final String N_PRECONFIGURED_FILTER_QUERY = "PreconfiguredFilterQuery";
    public static final String N_RULE = "Rule";
    public static final String[] PARAMETER_FIELDS = new String[]{"Title", "Category", "FilterMultiDay", "FilterQuery", "SortOrder", "ShowExpired", "MaxResults"};
    private static Map<String, String> PARAMS_MAP = CmsConfigParserUtils.createParamsMap();

    public static CmsConfigurationBean parseListConfiguration(CmsObject cms, CmsResource res) {
        CmsConfigurationBean result = new CmsConfigurationBean();
        try {
            List<I_CmsXmlContentValue> list;
            I_CmsXmlContentValue geoFilterValue;
            CmsFile configFile = cms.readFile(res);
            CmsXmlContent content = CmsXmlContentFactory.unmarshal(cms, configFile);
            Locale locale = CmsLocaleManager.MASTER_LOCALE;
            if (!content.hasLocale(locale)) {
                locale = content.getLocales().get(0);
            }
            for (String field : PARAMETER_FIELDS) {
                String val = content.getStringValue(cms, field, locale);
                if (N_CATEGORY.equals(field)) {
                    if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(val)) {
                        result.setCategories(Arrays.asList(val.split(",")));
                        continue;
                    }
                    result.setCategories(Collections.emptyList());
                    continue;
                }
                String param = PARAMS_MAP.get(field);
                if (param != null) {
                    result.setParameterValue(param, val);
                    continue;
                }
                LOG.error((Object)("Parameter value for field \"" + field + "\" is unknown and hence ignored."));
            }
            I_CmsXmlContentValue restrictValue = content.getValue(N_DATE_RESTRICTION, locale);
            if (restrictValue != null) {
                CmsDateRestrictionParser parser = new CmsDateRestrictionParser(cms);
                I_CmsDateRestriction restriction = parser.parse(new CmsXmlContentValueLocation(restrictValue));
                if (restriction == null) {
                    LOG.warn((Object)("Improper date restriction configuration in content " + content.getFile().getRootPath() + ", online=" + cms.getRequestContext().getCurrentProject().isOnlineProject()));
                }
                result.setDateRestriction(restriction);
            }
            if ((geoFilterValue = content.getValue(N_GEO_FILTER, locale)) != null) {
                String coordinatesPath = geoFilterValue.getPath() + "/Coordinates";
                String radiusPath = geoFilterValue.getPath() + "/Radius";
                I_CmsXmlContentValue coordinatesValue = content.getValue(coordinatesPath, locale);
                I_CmsXmlContentValue radiusValue = content.getValue(radiusPath, locale);
                String coordinates = CmsGeoUtil.parseCoordinates(coordinatesValue.getStringValue(cms));
                String radius = radiusValue.getStringValue(cms);
                boolean radiusValid = false;
                try {
                    Float.parseFloat(radius);
                    radiusValid = true;
                }
                catch (NumberFormatException e) {
                    radiusValid = false;
                }
                if (coordinates != null && radiusValid) {
                    CmsGeoFilterBean listGeoFilterBean = new CmsGeoFilterBean(coordinates, radius);
                    result.setGeoFilter(listGeoFilterBean);
                } else {
                    LOG.warn((Object)("Improper Geo filter in content " + content.getFile().getRootPath() + ", online=" + cms.getRequestContext().getCurrentProject().isOnlineProject()));
                }
            }
            I_CmsXmlContentValue categoryModeVal = content.getValue(N_CATEGORY_MODE, locale);
            CmsConfigurationBean.CombinationMode categoryMode = CmsConfigurationBean.CombinationMode.OR;
            if (categoryModeVal != null) {
                try {
                    categoryMode = CmsConfigurationBean.CombinationMode.valueOf(categoryModeVal.getStringValue(cms));
                }
                catch (Exception e) {
                    LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                }
            }
            result.setCategoryMode(categoryMode);
            LinkedHashMap<String, String> parameters = new LinkedHashMap<String, String>();
            for (I_CmsXmlContentValue parameter : content.getValues(N_PARAMETER, locale)) {
                I_CmsXmlContentValue keyVal = content.getValue(parameter.getPath() + "/Key", locale);
                I_CmsXmlContentValue valueVal = content.getValue(parameter.getPath() + "/Value", locale);
                if (keyVal == null || !CmsStringUtil.isNotEmptyOrWhitespaceOnly(keyVal.getStringValue(cms)) || valueVal == null) continue;
                parameters.put(keyVal.getStringValue(cms), valueVal.getStringValue(cms));
            }
            result.setAdditionalParameters(parameters);
            ArrayList<String> displayTypes = new ArrayList<String>();
            List<I_CmsXmlContentValue> typeValues = content.getValues(N_DISPLAY_TYPE, locale);
            if (!typeValues.isEmpty()) {
                for (I_CmsXmlContentValue value : typeValues) {
                    displayTypes.add(value.getStringValue(cms));
                }
            }
            result.setDisplayTypes(displayTypes);
            ArrayList<String> folders = new ArrayList<String>();
            List<I_CmsXmlContentValue> folderValues = content.getValues(N_SEARCH_FOLDER, locale);
            if (!folderValues.isEmpty()) {
                for (I_CmsXmlContentValue value : folderValues) {
                    CmsLink val = ((CmsXmlVfsFileValue)value).getLink(cms);
                    if (val == null) continue;
                    folders.add(cms.getRequestContext().addSiteRoot(val.getSitePath(cms)));
                }
            }
            result.setFolders(folders);
            ArrayList<CmsUUID> blackList = new ArrayList<CmsUUID>();
            List<I_CmsXmlContentValue> blacklistValues = content.getValues(N_BLACKLIST, locale);
            if (!blacklistValues.isEmpty()) {
                for (I_CmsXmlContentValue i_CmsXmlContentValue : blacklistValues) {
                    CmsLink link = ((CmsXmlVfsFileValue)i_CmsXmlContentValue).getLink(cms);
                    if (link == null) continue;
                    blackList.add(link.getStructureId());
                }
            }
            result.setBlacklist(blackList);
            List<I_CmsXmlContentValue> categoryFolderRestrictions = content.getValues(N_CATEGORY_FOLDER_RESTRICTION, locale);
            if (!categoryFolderRestrictions.isEmpty()) {
                for (I_CmsXmlContentValue restriction : categoryFolderRestrictions) {
                    ArrayList<String> restrictionFolders = new ArrayList<String>();
                    List<I_CmsXmlContentValue> folderVals = content.getValues(CmsXmlUtils.concatXpath(restriction.getPath(), N_FOLDER), locale);
                    for (I_CmsXmlContentValue folderVal : folderVals) {
                        CmsLink val = ((CmsXmlVfsFileValue)folderVal).getLink(cms);
                        if (val == null) continue;
                        restrictionFolders.add(cms.getRequestContext().addSiteRoot(val.getSitePath(cms)));
                    }
                    I_CmsXmlContentValue categoryVal = content.getValue(CmsXmlUtils.concatXpath(restriction.getPath(), N_CATEGORY), locale);
                    String categoryString = null != categoryVal ? categoryVal.getStringValue(cms) : "";
                    List<Object> restrictionCategorySitePaths = CmsStringUtil.isNotEmptyOrWhitespaceOnly(categoryString) ? Arrays.asList(categoryString.split(",")) : Collections.emptyList();
                    ArrayList<String> restrictionCategories = new ArrayList<String>(restrictionCategorySitePaths.size());
                    for (String string : restrictionCategorySitePaths) {
                        try {
                            String path = CmsCategoryService.getInstance().getCategory(cms, cms.getRequestContext().addSiteRoot(string)).getPath();
                            restrictionCategories.add(path);
                        }
                        catch (CmsException e) {
                            LOG.warn((Object)e.getLocalizedMessage(), (Throwable)e);
                        }
                    }
                    String restrictionCategoryMode = content.getValue(CmsXmlUtils.concatXpath(restriction.getPath(), N_CATEGORY_MODE), locale).getStringValue(cms);
                    result.addCategoryFolderFilter(new CmsCategoryFolderRestrictionBean(restrictionCategories, restrictionFolders, null == restrictionCategoryMode ? null : CmsConfigurationBean.CombinationMode.valueOf(restrictionCategoryMode)));
                }
            }
            if (!(list = content.getValues(N_PRECONFIGURED_FILTER_QUERY, locale)).isEmpty()) {
                CmsRestrictionsBean restrictionBean = new CmsRestrictionsBean();
                for (I_CmsXmlContentValue restriction : list) {
                    String restrictionRule = content.getValue(CmsXmlUtils.concatXpath(restriction.getPath(), N_RULE), locale).getStringValue(cms);
                    List<I_CmsXmlContentValue> restrictionVals = content.getValues(CmsXmlUtils.concatXpath(restriction.getPath(), N_VALUE), locale);
                    List<String> restrictionValues = restrictionVals.stream().map(v -> v.getStringValue(cms)).collect(Collectors.toList());
                    restrictionBean.addRestriction(restrictionRule, restrictionValues);
                }
                result.setPreconfiguredRestrictions(restrictionBean);
            }
        }
        catch (CmsException e) {
            e.printStackTrace();
        }
        return result;
    }

    public static CmsXmlContent updateBlackList(CmsObject cms, CmsXmlContent content, CmsConfigurationBean configBean) {
        Locale locale = CmsLocaleManager.MASTER_LOCALE;
        int count = 0;
        while (content.hasValue(N_BLACKLIST, locale)) {
            content.removeValue(N_BLACKLIST, locale, 0);
        }
        for (CmsUUID hiddenId : configBean.getBlacklist()) {
            CmsXmlVfsFileValue contentVal = (CmsXmlVfsFileValue)content.addValue(cms, N_BLACKLIST, locale, count);
            contentVal.setIdValue(cms, hiddenId);
            ++count;
        }
        return content;
    }

    private static Map<String, String> createParamsMap() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put(N_TITLE, N_TITLE);
        result.put(N_FILTER_MULTI_DAY, N_FILTER_MULTI_DAY);
        result.put(N_FILTER_QUERY, N_FILTER_QUERY);
        result.put(N_SORT_ORDER, N_SORT_ORDER);
        result.put(N_SHOW_EXPIRED, N_SHOW_EXPIRED);
        result.put(N_MAX_RESULTS, N_MAX_RESULTS);
        return Collections.unmodifiableMap(result);
    }
}

