/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.jsp.search.config.parser;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.opencms.file.CmsObject;
import org.opencms.i18n.CmsEncoder;
import org.opencms.json.JSONException;
import org.opencms.jsp.search.config.CmsSearchConfigurationFacetField;
import org.opencms.jsp.search.config.CmsSearchConfigurationFacetRange;
import org.opencms.jsp.search.config.CmsSearchConfigurationSortOption;
import org.opencms.jsp.search.config.I_CmsSearchConfigurationFacet;
import org.opencms.jsp.search.config.I_CmsSearchConfigurationFacetField;
import org.opencms.jsp.search.config.I_CmsSearchConfigurationFacetRange;
import org.opencms.jsp.search.config.I_CmsSearchConfigurationPagination;
import org.opencms.jsp.search.config.I_CmsSearchConfigurationSortOption;
import org.opencms.jsp.search.config.parser.CmsJSONSearchConfigurationParser;
import org.opencms.jsp.search.config.parser.simplesearch.CmsCategoryFolderRestrictionBean;
import org.opencms.jsp.search.config.parser.simplesearch.CmsConfigurationBean;
import org.opencms.jsp.search.config.parser.simplesearch.CmsGeoFilterBean;
import org.opencms.jsp.search.config.parser.simplesearch.daterestrictions.I_CmsDateRestriction;
import org.opencms.jsp.search.config.parser.simplesearch.preconfiguredrestrictions.CmsRestrictionRule;
import org.opencms.jsp.search.config.parser.simplesearch.preconfiguredrestrictions.CmsRestrictionsBean;
import org.opencms.main.CmsException;
import org.opencms.relations.CmsCategoryService;
import org.opencms.search.solr.CmsSolrQuery;
import org.opencms.search.solr.CmsSolrQueryUtil;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;

public class CmsSimpleSearchConfigurationParser
extends CmsJSONSearchConfigurationParser {
    public static final String FIELD_CATEGORIES = "category_exact";
    public static final String FIELD_DATE = "instancedate_%s_dt";
    public static final String FIELD_DATE_RANGE = "instancedaterange_%s_dr";
    public static final String FIELD_DATE_FACET_NAME = "instancedate";
    public static final String FIELD_PARENT_FOLDERS = "parent-folders";
    private I_CmsSearchConfigurationPagination m_pagination;
    private CmsObject m_cms;
    private CmsConfigurationBean m_config;
    private Locale m_searchLocale;
    private SortOption m_sortOrder;
    private boolean m_ignoreBlacklist;

    public CmsSimpleSearchConfigurationParser(CmsObject cms, CmsConfigurationBean config, String additionalParamJSON) throws JSONException {
        super(CmsStringUtil.isEmptyOrWhitespaceOnly(additionalParamJSON) ? "{}" : additionalParamJSON);
        this.m_cms = cms;
        this.m_config = config;
    }

    public static CmsSimpleSearchConfigurationParser createInstanceWithNoJsonConfig(CmsObject cms, CmsConfigurationBean config) {
        try {
            return new CmsSimpleSearchConfigurationParser(cms, config, null);
        }
        catch (JSONException e) {
            return null;
        }
    }

    public static Map<String, I_CmsSearchConfigurationFacetField> getDefaultFieldFacets(boolean categoryConjunction) {
        HashMap<String, CmsSearchConfigurationFacetField> fieldFacets = new HashMap<String, CmsSearchConfigurationFacetField>();
        fieldFacets.put(FIELD_CATEGORIES, new CmsSearchConfigurationFacetField(FIELD_CATEGORIES, null, 1, 200, null, "Category", I_CmsSearchConfigurationFacet.SortOrder.index, null, categoryConjunction, null, Boolean.TRUE, null));
        fieldFacets.put(FIELD_PARENT_FOLDERS, new CmsSearchConfigurationFacetField(FIELD_PARENT_FOLDERS, null, 1, 200, null, "Folders", I_CmsSearchConfigurationFacet.SortOrder.index, null, Boolean.FALSE, null, Boolean.TRUE, null));
        return Collections.unmodifiableMap(fieldFacets);
    }

    public CmsSolrQuery getInitialQuery() {
        HashMap<String, String[]> queryParams = new HashMap<String, String[]>();
        if (!this.m_cms.getRequestContext().getCurrentProject().isOnlineProject() && this.m_config.isShowExpired()) {
            queryParams.put("fq", new String[]{"released:[* TO *]", "expired:[* TO *]"});
        }
        return new CmsSolrQuery(null, queryParams);
    }

    public Locale getSearchLocale() {
        if (this.m_searchLocale != null) {
            return this.m_searchLocale;
        }
        return this.m_cms.getRequestContext().getLocale();
    }

    @Override
    public Map<String, I_CmsSearchConfigurationFacetField> parseFieldFacets() {
        if (this.m_configObject.has("fieldfacets")) {
            return super.parseFieldFacets();
        }
        return CmsSimpleSearchConfigurationParser.getDefaultFieldFacets(true);
    }

    @Override
    public I_CmsSearchConfigurationPagination parsePagination() {
        if (this.m_pagination != null) {
            return this.m_pagination;
        }
        return super.parsePagination();
    }

    @Override
    public Map<String, I_CmsSearchConfigurationFacetRange> parseRangeFacets() {
        if (this.m_configObject.has("rangefacets")) {
            return super.parseRangeFacets();
        }
        HashMap<String, I_CmsSearchConfigurationFacetRange> rangeFacets = new HashMap<String, I_CmsSearchConfigurationFacetRange>();
        String indexField = FIELD_DATE;
        I_CmsSearchConfigurationFacetRange.Method method = I_CmsSearchConfigurationFacetRange.Method.dv;
        if (Boolean.parseBoolean(this.m_config.getParameterValue("FilterMultiDay"))) {
            indexField = FIELD_DATE_RANGE;
            method = null;
        }
        CmsSearchConfigurationFacetRange rangeFacet = new CmsSearchConfigurationFacetRange(String.format(indexField, this.getSearchLocale().toString()), "NOW/YEAR-20YEARS", "NOW/MONTH+5YEARS", "+1MONTHS", null, Boolean.FALSE, method, FIELD_DATE_FACET_NAME, 1, "Date", Boolean.FALSE, null, Boolean.TRUE, null);
        rangeFacets.put(rangeFacet.getName(), rangeFacet);
        return rangeFacets;
    }

    public void setIgnoreBlacklist(boolean ignoreBlacklist) {
        this.m_ignoreBlacklist = ignoreBlacklist;
    }

    public void setPagination(I_CmsSearchConfigurationPagination pagination) {
        this.m_pagination = pagination;
    }

    public void setSearchLocale(Locale locale) {
        this.m_searchLocale = locale;
    }

    public void setSortOption(String sortOption) {
        if (null != sortOption) {
            try {
                this.m_sortOrder = SortOption.valueOf(sortOption);
            }
            catch (IllegalArgumentException e) {
                this.m_sortOrder = null;
                LOG.warn((Object)("Setting illegal default sort option " + sortOption + " failed. Using Solr's default sort option."));
            }
        } else {
            this.m_sortOrder = null;
        }
    }

    @Override
    protected Boolean getEscapeQueryChars() {
        if (this.m_configObject.has("escapequerychars")) {
            return super.getEscapeQueryChars();
        }
        return Boolean.TRUE;
    }

    @Override
    protected String getExtraSolrParams() {
        Object params = super.getExtraSolrParams();
        if (CmsStringUtil.isEmptyOrWhitespaceOnly((String)params)) {
            params = this.getCategoryFolderFilter() + this.getResourceTypeFilter() + this.getPreconfiguredFilterQuery() + this.getFilterQuery() + this.getBlacklistFilter() + this.getGeoFilterQuery();
        }
        return params;
    }

    @Override
    protected Boolean getIgnoreExpirationDate() {
        return this.getIgnoreReleaseAndExpiration();
    }

    @Override
    protected Boolean getIgnoreReleaseDate() {
        return this.getIgnoreReleaseAndExpiration();
    }

    @Override
    protected int getMaxReturnedResults(String indexName) {
        return null != this.m_config.getMaximallyReturnedResults() ? this.m_config.getMaximallyReturnedResults().intValue() : super.getMaxReturnedResults(indexName);
    }

    @Override
    protected String getQueryModifier() {
        Object modifier = super.getQueryModifier();
        if (CmsStringUtil.isEmptyOrWhitespaceOnly((String)modifier)) {
            modifier = "{!type=edismax qf=\"content_" + this.getSearchLocale().toString() + " Title_prop Description_dprop Description.html_dprop description_" + this.getSearchLocale().toString() + " keywords_" + this.getSearchLocale().toString() + "\"}%(query)";
        }
        return modifier;
    }

    @Override
    protected Boolean getSearchForEmptyQuery() {
        if (this.m_configObject.has("searchforemptyquery")) {
            return super.getSearchForEmptyQuery();
        }
        return Boolean.TRUE;
    }

    @Override
    protected List<I_CmsSearchConfigurationSortOption> getSortOptions() {
        if (this.m_configObject.has("sortoptions")) {
            return super.getSortOptions();
        }
        LinkedList<I_CmsSearchConfigurationSortOption> options = new LinkedList<I_CmsSearchConfigurationSortOption>();
        SortOption currentOption = SortOption.valueOf(this.m_config.getSortOrder());
        if (this.m_sortOrder != null) {
            currentOption = this.m_sortOrder;
        }
        Locale locale = this.getSearchLocale();
        options.add(currentOption.getOption(locale));
        SortOption[] sortOptions = SortOption.values();
        for (int i = 0; i < sortOptions.length; ++i) {
            SortOption option = sortOptions[i];
            if (Objects.equals((Object)currentOption, (Object)option)) continue;
            options.add(option.getOption(locale));
        }
        return options;
    }

    String generatePreconfiguredRestriction(String type, Map<CmsRestrictionRule, Collection<CmsRestrictionsBean.FieldValues>> restrictionsForType) {
        Object result = "";
        if (null != restrictionsForType && restrictionsForType.size() > 0) {
            HashSet<String> ruleRestrictions = new HashSet<String>(restrictionsForType.size());
            for (Map.Entry<CmsRestrictionRule, Collection<CmsRestrictionsBean.FieldValues>> ruleEntry : restrictionsForType.entrySet()) {
                ruleRestrictions.add(this.generatePreconfiguredRestrictionForRule(ruleEntry.getKey(), ruleEntry.getValue()));
            }
            Object object = result = ruleRestrictions.size() > 1 ? (String)ruleRestrictions.stream().reduce((r1, r2) -> r1 + " " + String.valueOf((Object)CmsConfigurationBean.CombinationMode.AND) + " " + r2).get() : (String)ruleRestrictions.iterator().next();
            if (null != type) {
                result = "type:\"" + type + "\" AND (" + (String)result + ")";
            }
        } else if (null != type) {
            result = "type:\"" + type + "\"";
        }
        return ((String)result).isEmpty() ? result : "(" + (String)result + ")";
    }

    String generatePreconfiguredRestrictionForRule(CmsRestrictionRule rule, Collection<CmsRestrictionsBean.FieldValues> values) {
        Collection resolvedFieldValues = values.stream().map(v -> this.resolveFieldValues(rule, (CmsRestrictionsBean.FieldValues)v)).collect(Collectors.toSet());
        String seperator = " " + rule.getCombinationModeBetweenFields().toString() + " ";
        return rule.getFieldForLocale(this.getSearchLocale()) + ":(" + (String)resolvedFieldValues.stream().reduce((v1, v2) -> v1 + seperator + v2).get() + ")";
    }

    String getBlacklistFilter() {
        if (this.m_ignoreBlacklist) {
            return "";
        }
        Object result = "";
        List<CmsUUID> blacklist = this.m_config.getBlacklist();
        ArrayList blacklistStrings = Lists.newArrayList();
        for (CmsUUID id : blacklist) {
            blacklistStrings.add("\"" + id.toString() + "\"");
        }
        if (!blacklistStrings.isEmpty()) {
            result = "&fq=" + CmsEncoder.encode("-id:(" + CmsStringUtil.listAsString(blacklistStrings, " OR ") + ")");
        }
        return result;
    }

    String getCategoryFilterPart() {
        Object result = "";
        if (!this.m_config.getCategories().isEmpty()) {
            ArrayList categoryVals = Lists.newArrayList();
            for (String path : this.m_config.getCategories()) {
                try {
                    path = CmsCategoryService.getInstance().getCategory(this.m_cms, this.m_cms.getRequestContext().addSiteRoot(path)).getPath();
                    categoryVals.add("\"" + path + "\"");
                }
                catch (CmsException e) {
                    LOG.warn((Object)e.getLocalizedMessage(), (Throwable)e);
                }
            }
            if (!categoryVals.isEmpty()) {
                String operator = " " + String.valueOf((Object)this.m_config.getCategoryMode()) + " ";
                String valueExpression = CmsStringUtil.listAsString(categoryVals, operator);
                result = "category_exact:(" + valueExpression + ")";
            }
        }
        return result;
    }

    String getCategoryFolderFilter() {
        Object result = "";
        Object defaultPart = this.getFolderFilterPart();
        String categoryFilterPart = this.getCategoryFilterPart();
        if (!categoryFilterPart.isEmpty()) {
            defaultPart = "((" + (String)defaultPart + ") AND (" + categoryFilterPart + "))";
        }
        for (CmsCategoryFolderRestrictionBean restriction : this.m_config.getCategoryFolderRestrictions()) {
            Object restrictionQuery = restriction.toString();
            if (((String)restrictionQuery).isEmpty()) continue;
            restrictionQuery = "(" + (String)restrictionQuery + " AND " + (String)defaultPart + ")";
            if (!((String)result).isEmpty()) {
                result = (String)result + " OR ";
            }
            result = (String)result + (String)restrictionQuery;
        }
        if (((String)result).isEmpty()) {
            result = defaultPart;
        }
        return "fq=" + CmsEncoder.encode((String)result);
    }

    String getDefaultReturnFields() {
        StringBuffer fields = new StringBuffer("");
        fields.append("path");
        fields.append(',');
        fields.append(FIELD_DATE_FACET_NAME).append("_dt");
        fields.append(',');
        fields.append("instancedateend").append("_dt");
        fields.append(',');
        fields.append("instancedatecurrenttill").append("_dt");
        fields.append(',');
        fields.append(FIELD_DATE_FACET_NAME).append('_').append(this.getSearchLocale().toString()).append("_dt");
        fields.append(',');
        fields.append("instancedateend").append('_').append(this.getSearchLocale().toString()).append("_dt");
        fields.append(',');
        fields.append("instancedatecurrenttill").append('_').append(this.getSearchLocale().toString()).append("_dt");
        fields.append(',');
        fields.append("id");
        fields.append(',');
        fields.append("solr_id");
        fields.append(',');
        fields.append("disptitle").append('_').append(this.getSearchLocale().toString()).append("_sort");
        fields.append(',');
        fields.append("link");
        fields.append(',');
        fields.append("geocoords_loc");
        return fields.toString();
    }

    String getFilterQuery() {
        I_CmsDateRestriction dateRestriction;
        Object result = this.m_config.getFilterQuery();
        if (result == null) {
            result = "";
        }
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly((String)result) && !((String)result).startsWith("&")) {
            result = "&" + (String)result;
        }
        if (!((String)result).contains("fl=")) {
            result = (String)result + "&fl=" + CmsEncoder.encode(this.getDefaultReturnFields());
        }
        if ((dateRestriction = this.m_config.getDateRestriction()) != null) {
            result = (String)result + "&fq=" + CmsEncoder.encode("instancedatecurrenttill_" + this.getSearchLocale().toString() + "_dt:" + dateRestriction.getRange());
        }
        result = (String)result + "&fq=con_locales:" + this.getSearchLocale().toString();
        return result;
    }

    String getFolderFilterPart() {
        Object result = "";
        ArrayList parentFolderVals = Lists.newArrayList();
        if (!this.m_config.getFolders().isEmpty()) {
            for (String value : this.m_config.getFolders()) {
                parentFolderVals.add("\"" + value + "\"");
            }
        }
        result = parentFolderVals.isEmpty() ? "parent-folders:(\"/\")" : "parent-folders:(" + CmsStringUtil.listAsString(parentFolderVals, " OR ") + ")";
        return result;
    }

    String getGeoFilterQuery() {
        Object result = "";
        CmsGeoFilterBean geoFilterBean = this.m_config.getGeoFilter();
        if (geoFilterBean != null) {
            String fq = CmsSolrQueryUtil.composeGeoFilterQuery("geocoords_loc", geoFilterBean.getCoordinates(), geoFilterBean.getRadius(), "km");
            result = "&fq=" + fq;
        }
        return result;
    }

    String getPreconfiguredFilterQuery() {
        Object result = "";
        if (this.m_config.hasPreconfiguredRestrictions()) {
            CmsRestrictionsBean restrictions = this.m_config.getPreconfiguredRestrictions();
            String restriction = this.generatePreconfiguredRestriction(null, restrictions.getRestrictionsForType(null));
            if (!restriction.isEmpty()) {
                result = "&fq=" + CmsEncoder.encode(restriction);
            }
            HashSet<String> typedRestrictions = new HashSet<String>();
            for (String type : this.m_config.getTypes()) {
                restriction = this.generatePreconfiguredRestriction(type, restrictions.getRestrictionsForType(type));
                if (restriction.isEmpty()) continue;
                typedRestrictions.add(restriction);
            }
            if (!typedRestrictions.isEmpty()) {
                result = (String)result + "&fq=" + CmsEncoder.encode("(" + (String)typedRestrictions.stream().reduce((r1, r2) -> r1 + " OR " + r2).get() + ")");
            }
        }
        return result;
    }

    String getResourceTypeFilter() {
        Object result = "";
        if (!this.m_config.hasPreconfiguredRestrictions()) {
            ArrayList typeVals = Lists.newArrayList();
            for (String type : this.m_config.getTypes()) {
                typeVals.add("\"" + type + "\"");
            }
            if (!typeVals.isEmpty()) {
                result = "&fq=" + CmsEncoder.encode("type:(" + CmsStringUtil.listAsString(typeVals, " OR ") + ")");
            }
        }
        return result;
    }

    String resolveFieldValues(CmsRestrictionRule rule, CmsRestrictionsBean.FieldValues fieldValues) {
        Collection finalValues;
        Collection values = fieldValues.getValues();
        if (CmsRestrictionsBean.FieldValues.FieldType.PLAIN.equals((Object)fieldValues.getFieldType())) {
            return "(" + values.iterator().next() + ")";
        }
        switch (rule.getMatchType()) {
            case DEFAULT: {
                finalValues = values;
                break;
            }
            case EXACT: {
                finalValues = values.stream().map(v -> "\"" + v + "\"").collect(Collectors.toSet());
                break;
            }
            case INFIX: {
                finalValues = values.stream().map(v -> "(" + v + " OR *" + v + " OR *" + v + "* OR " + v + "*)").collect(Collectors.toSet());
                break;
            }
            case POSTFIX: {
                finalValues = values.stream().map(v -> "(" + v + " OR *" + v + ")").collect(Collectors.toSet());
                break;
            }
            case PREFIX: {
                finalValues = values.stream().map(v -> "(" + v + " OR " + v + "*)").collect(Collectors.toSet());
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown match type '" + String.valueOf((Object)rule.getMatchType()) + "'.");
            }
        }
        if (finalValues.size() > 1) {
            String seperator = " " + rule.getCombinationModeInField().toString() + " ";
            return "(" + (String)finalValues.stream().reduce((v1, v2) -> v1 + seperator + v2).get() + ")";
        }
        return (String)finalValues.iterator().next();
    }

    private Boolean getIgnoreReleaseAndExpiration() {
        return this.m_config.isShowExpired();
    }

    public static enum SortOption {
        DATE_ASC,
        DATE_DESC,
        TITLE_ASC,
        TITLE_DESC,
        ORDER_ASC,
        ORDER_DESC;


        public I_CmsSearchConfigurationSortOption getOption(Locale l) {
            switch (this) {
                case DATE_ASC: {
                    return new CmsSearchConfigurationSortOption("date.asc", "date_asc", this.getSortDateField(l) + " asc");
                }
                case DATE_DESC: {
                    return new CmsSearchConfigurationSortOption("date.desc", "date_desc", this.getSortDateField(l) + " desc");
                }
                case TITLE_ASC: {
                    return new CmsSearchConfigurationSortOption("title.asc", "title_asc", this.getSortTitleField(l) + " asc");
                }
                case TITLE_DESC: {
                    return new CmsSearchConfigurationSortOption("title.desc", "title_desc", this.getSortTitleField(l) + " desc");
                }
                case ORDER_ASC: {
                    return new CmsSearchConfigurationSortOption("order.asc", "order_asc", this.getSortOrderField(l) + " asc");
                }
                case ORDER_DESC: {
                    return new CmsSearchConfigurationSortOption("order.desc", "order_desc", this.getSortOrderField(l) + " desc");
                }
            }
            throw new IllegalArgumentException();
        }

        protected String getSortDateField(Locale l) {
            return CmsSimpleSearchConfigurationParser.FIELD_DATE_FACET_NAME + (String)(null != l ? "_" + l.toString() : "") + "_dt";
        }

        protected String getSortOrderField(Locale l) {
            return "disporder" + (String)(null != l ? "_" + l.toString() : "") + "_i";
        }

        protected String getSortTitleField(Locale l) {
            return "disptitle" + (String)(null != l ? "_" + l.toString() : "") + "_sort";
        }
    }
}

