/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.jsp;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.servlet.ServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.TagSupport;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsUser;
import org.opencms.flex.CmsFlexController;
import org.opencms.i18n.CmsMessageContainer;
import org.opencms.jsp.Messages;
import org.opencms.main.CmsLog;

public class CmsJspTagUser
extends TagSupport {
    private static final long serialVersionUID = 4520173761363738542L;
    private static final Log LOG = CmsLog.getLog(CmsJspTagUser.class);
    private static final String[] USER_PROPERTIES = new String[]{"name", "firstname", "lastname", "email", "street", "zip", "city", "description", "group", "currentgroup", "defaultgroup", "otherstuff", "institution"};
    private static final List<String> USER_PROPERTIES_LIST = Arrays.asList(USER_PROPERTIES);
    private String m_property;

    public static String userTagAction(String property, ServletRequest req) {
        CmsFlexController controller = CmsFlexController.getController(req);
        CmsObject cms = controller.getCmsObject();
        CmsUser user = cms.getRequestContext().getCurrentUser();
        if (property == null) {
            property = USER_PROPERTIES[0];
        }
        Object result = null;
        switch (USER_PROPERTIES_LIST.indexOf(property)) {
            case 0: {
                result = user.getName();
                break;
            }
            case 1: {
                result = user.getFirstname();
                break;
            }
            case 2: {
                result = user.getLastname();
                break;
            }
            case 3: {
                result = user.getEmail();
                break;
            }
            case 4: {
                result = user.getAddress();
                break;
            }
            case 5: {
                result = user.getZipcode();
                break;
            }
            case 6: {
                result = user.getCity();
                break;
            }
            case 7: {
                result = user.getDescription(cms.getRequestContext().getLocale());
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                result = "";
                break;
            }
            case 11: {
                Iterator<String> it = user.getAdditionalInfo().keySet().iterator();
                CmsMessageContainer msgContainer = Messages.get().container("GUI_TAG_USER_ADDITIONALINFO_0");
                result = Messages.getLocalizedMessage(msgContainer, req);
                while (it.hasNext()) {
                    String o = it.next();
                    result = (String)result + " " + String.valueOf(o) + "=" + String.valueOf(user.getAdditionalInfo(o));
                }
                break;
            }
            case 12: {
                result = user.getInstitution();
                break;
            }
            default: {
                CmsMessageContainer msgContainer = Messages.get().container("GUI_ERR_INVALID_USER_PROP_1", property);
                result = Messages.getLocalizedMessage(msgContainer, req);
            }
        }
        return result;
    }

    public int doStartTag() throws JspException {
        ServletRequest req = this.pageContext.getRequest();
        if (CmsFlexController.isCmsRequest(req)) {
            try {
                String result = CmsJspTagUser.userTagAction(this.m_property, req);
                this.pageContext.getOut().print(result);
            }
            catch (Exception ex) {
                if (LOG.isErrorEnabled()) {
                    LOG.error((Object)Messages.get().getBundle().key("ERR_PROCESS_TAG_1", "user"), (Throwable)ex);
                }
                throw new JspException((Throwable)ex);
            }
        }
        return 0;
    }

    public String getProperty() {
        return this.m_property != null ? this.m_property : "";
    }

    public void release() {
        super.release();
        this.m_property = null;
    }

    public void setProperty(String name) {
        if (name != null) {
            this.m_property = name.toLowerCase();
        }
    }
}

