/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.jsp;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.servlet.ServletRequest;
import javax.servlet.jsp.tagext.TagSupport;
import org.opencms.file.CmsObject;
import org.opencms.flex.CmsFlexController;
import org.opencms.flex.CmsFlexRequest;
import org.opencms.util.CmsStringUtil;

public class CmsJspTagSecureParams
extends TagSupport {
    private static final long serialVersionUID = -3571347944585254L;
    private String m_allowHtml;
    private String m_allowXml;
    private String m_escapeInvalid;
    private String m_policy;
    private String m_replaceInvalid;

    public static void secureParamsTagAction(ServletRequest request, String allowXml, String allowHtml, String policy, String replaceInvalid, String escapeInvalid) {
        if (request instanceof CmsFlexRequest) {
            CmsFlexRequest flexRequest = (CmsFlexRequest)request;
            CmsObject cms = CmsFlexController.getCmsObject((ServletRequest)flexRequest);
            List<String> exceptions = Collections.emptyList();
            if (allowXml != null) {
                exceptions = CmsStringUtil.splitAsList(allowXml, ",");
            }
            flexRequest.enableParameterEscaping();
            flexRequest.getParameterEscaper().setExceptions(exceptions);
            flexRequest.getParameterEscaper().setDummyValue(replaceInvalid);
            if (escapeInvalid != null) {
                List<String> escapeInvalidList = CmsStringUtil.splitAsList(escapeInvalid.trim(), ",");
                flexRequest.getParameterEscaper().setEscapeInvalid(escapeInvalidList);
            }
            Set<String> allowHtmlSet = Collections.emptySet();
            if (allowHtml != null) {
                allowHtmlSet = new HashSet<String>(CmsStringUtil.splitAsList(allowHtml, ","));
                flexRequest.getParameterEscaper().enableAntiSamy(cms, policy, allowHtmlSet);
            }
        }
    }

    public int doStartTag() {
        CmsJspTagSecureParams.secureParamsTagAction(this.pageContext.getRequest(), this.m_allowXml, this.m_allowHtml, this.m_policy, this.m_replaceInvalid, this.m_escapeInvalid);
        return 0;
    }

    public void setAllowHtml(String allowHtml) {
        this.m_allowHtml = allowHtml;
    }

    public void setAllowXml(String allowXml) {
        this.m_allowXml = allowXml;
    }

    public void setEscapeInvalid(String escapeInvalid) {
        this.m_escapeInvalid = escapeInvalid;
    }

    public void setPolicy(String policy) {
        this.m_policy = policy;
    }

    public void setReplaceInvalid(String replaceInvalid) {
        this.m_replaceInvalid = replaceInvalid;
    }
}

