/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.jsp;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.TagSupport;
import org.apache.commons.lang3.LocaleUtils;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsProperty;
import org.opencms.flex.CmsFlexController;
import org.opencms.i18n.CmsEncoder;
import org.opencms.jsp.Messages;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.staticexport.CmsLinkManager;
import org.opencms.util.CmsStringUtil;

public class CmsJspTagProperty
extends TagSupport {
    private static final Log LOG = CmsLog.getLog(CmsJspTagProperty.class);
    private static final long serialVersionUID = -4040833541258687977L;
    private String m_defaultValue;
    private Locale m_locale;
    private boolean m_escapeHtml;
    private String m_propertyFile;
    private String m_propertyName;

    public static Map<String, String> propertiesTagAction(String action, ServletRequest req) throws CmsException {
        CmsFlexController controller = CmsFlexController.getController(req);
        Map<String, String> value = new HashMap<String, String>();
        CmsPropertyAction propertyAction = new CmsPropertyAction(req, action);
        if (null != propertyAction.getVfsUri()) {
            value = CmsProperty.toMap(controller.getCmsObject().readPropertyObjects(propertyAction.getVfsUri(), propertyAction.isSearch()));
        }
        return value;
    }

    public static String propertyTagAction(String property, String action, String defaultValue, boolean escape, ServletRequest req) throws CmsException {
        return CmsJspTagProperty.propertyTagAction(property, action, defaultValue, escape, req, null);
    }

    public static String propertyTagAction(String property, String action, String defaultValue, boolean escape, ServletRequest req, Locale locale) throws CmsException {
        CmsFlexController controller = CmsFlexController.getController(req);
        String value = null;
        CmsPropertyAction propertyAction = new CmsPropertyAction(req, action);
        if (null != propertyAction.getVfsUri()) {
            value = controller.getCmsObject().readPropertyObject(propertyAction.getVfsUri(), property, propertyAction.isSearch(), locale).getValue();
        }
        if (value == null) {
            value = defaultValue;
        }
        if (escape) {
            value = CmsEncoder.escapeHtml(value);
        }
        return value;
    }

    public int doEndTag() {
        this.release();
        return 6;
    }

    public int doStartTag() throws JspException {
        ServletRequest req = this.pageContext.getRequest();
        if (CmsFlexController.isCmsRequest(req)) {
            try {
                String prop = CmsJspTagProperty.propertyTagAction(this.getName(), this.getFile(), this.m_defaultValue, this.m_escapeHtml, req, this.m_locale);
                if (prop == null) {
                    prop = "";
                }
                this.pageContext.getOut().print(prop);
            }
            catch (Exception ex) {
                if (LOG.isErrorEnabled()) {
                    LOG.error((Object)Messages.get().getBundle().key("ERR_PROCESS_TAG_1", "property"), (Throwable)ex);
                }
                throw new JspException((Throwable)ex);
            }
        }
        return 0;
    }

    public String getDefault() {
        return this.m_defaultValue != null ? this.m_defaultValue : "";
    }

    public String getEscapeHtml() {
        return "" + this.m_escapeHtml;
    }

    public String getFile() {
        return this.m_propertyFile != null ? this.m_propertyFile : "parent";
    }

    public String getName() {
        return this.m_propertyName != null ? this.m_propertyName : "";
    }

    public void release() {
        super.release();
        this.m_propertyFile = null;
        this.m_propertyName = null;
        this.m_defaultValue = null;
        this.m_escapeHtml = false;
    }

    public void setDefault(String def) {
        if (def != null) {
            this.m_defaultValue = def;
        }
    }

    public void setEscapeHtml(String value) {
        if (value != null) {
            this.m_escapeHtml = Boolean.valueOf(value.trim());
        }
    }

    public void setFile(String file) {
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(file)) {
            this.m_propertyFile = file;
        }
    }

    public void setLocale(String locale) {
        try {
            this.m_locale = LocaleUtils.toLocale((String)locale);
        }
        catch (IllegalArgumentException e) {
            LOG.error((Object)Messages.get().getBundle().key("ERR_TAG_INVALID_LOCALE_1", "cms:property"), (Throwable)e);
            this.m_locale = null;
        }
    }

    public void setName(String name) {
        if (name != null) {
            this.m_propertyName = name;
        }
    }

    public static class CmsPropertyAction {
        private String m_vfsUri;
        private boolean m_search;

        public CmsPropertyAction(ServletRequest req, String action) {
            CmsFlexController controller = CmsFlexController.getController(req);
            FileUse useAction = FileUse.URI;
            if (action != null) {
                useAction = FileUse.parse(action);
            }
            if (useAction != null) {
                switch (useAction) {
                    case URI: 
                    case PARENT: {
                        this.m_vfsUri = controller.getCmsObject().getRequestContext().getUri();
                        break;
                    }
                    case SEARCH: 
                    case SEARCH_URI: 
                    case SEARCH_PARENT: {
                        this.m_vfsUri = controller.getCmsObject().getRequestContext().getUri();
                        this.m_search = true;
                        break;
                    }
                    case ELEMENT_URI: 
                    case THIS: {
                        this.m_vfsUri = controller.getCurrentRequest().getElementUri();
                        break;
                    }
                    case SEARCH_ELEMENT_URI: 
                    case SEARCH_THIS: {
                        this.m_vfsUri = controller.getCurrentRequest().getElementUri();
                        this.m_search = true;
                        break;
                    }
                }
            } else {
                this.m_vfsUri = CmsLinkManager.getAbsoluteUri(action, controller.getCurrentRequest().getElementUri());
                this.m_search = false;
            }
        }

        public String getVfsUri() {
            return this.m_vfsUri;
        }

        public boolean isSearch() {
            return this.m_search;
        }
    }

    private static enum FileUse {
        ELEMENT_URI("element.uri"),
        PARENT("parent"),
        SEARCH("search"),
        SEARCH_ELEMENT_URI("search.element.uri"),
        SEARCH_PARENT("search-parent"),
        SEARCH_THIS("search-this"),
        SEARCH_URI("search.uri"),
        THIS("this"),
        URI("uri");

        private String m_name;

        private FileUse(String name) {
            this.m_name = name;
        }

        public static FileUse parse(String name) {
            for (FileUse fileUse : FileUse.values()) {
                if (!fileUse.getName().equals(name)) continue;
                return fileUse;
            }
            return null;
        }

        public String getName() {
            return this.m_name;
        }
    }
}

