/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.jsp;

import java.io.Writer;
import java.util.Locale;
import javax.servlet.ServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.BodyTagSupport;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.CmsVfsResourceNotFoundException;
import org.opencms.flex.CmsFlexController;
import org.opencms.i18n.CmsLocaleManager;
import org.opencms.jsp.Messages;
import org.opencms.jsp.util.CmsJspLinkWrapper;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.staticexport.CmsLinkManager;
import org.opencms.util.CmsStringUtil;

public class CmsJspTagLink
extends BodyTagSupport {
    private static final String SCOPE_REQUEST = "request";
    private static final String SCOPE_SESSION = "session";
    private static final String SCOPE_APPLICATION = "application";
    private static final Log LOG = CmsLog.getLog(CmsJspTagLink.class);
    private static final long serialVersionUID = -2361021288258405388L;
    private String m_var;
    private String m_scope;
    private String m_baseUri;
    private String m_detailPage;
    private Locale m_locale;
    private Type m_type;

    public static Locale getBaseUriLocale(CmsObject cms, String baseUri) {
        try {
            try {
                return OpenCms.getLocaleManager().getDefaultLocale(cms, cms.readResource(baseUri, CmsResourceFilter.IGNORE_EXPIRATION));
            }
            catch (CmsVfsResourceNotFoundException e) {
                String parent = CmsResource.getParentFolder(baseUri);
                if (parent != null) {
                    return OpenCms.getLocaleManager().getDefaultLocale(cms, cms.readResource(parent, CmsResourceFilter.IGNORE_EXPIRATION));
                }
            }
        }
        catch (CmsException e) {
            LOG.info((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        return null;
    }

    public static String linkTagAction(Parameters params, ServletRequest req) {
        CmsFlexController controller = CmsFlexController.getController(req);
        String uri = CmsLinkManager.getAbsoluteUri(params.getTarget(), controller.getCurrentRequest().getElementUri());
        CmsObject cms = CmsJspTagLink.prepareCmsObject(controller.getCmsObject(), params);
        CmsLinkManager linkManager = OpenCms.getLinkManager();
        switch (params.getType()) {
            case ONLINE: {
                return linkManager.getOnlineLink(cms, uri, params.getDetailPage(), false);
            }
            case PERMA: {
                return linkManager.getPermalink(cms, uri);
            }
            case SERVER: {
                return linkManager.getServerLink(cms, uri);
            }
        }
        return linkManager.substituteLinkForUnknownTarget(cms, uri, params.getDetailPage(), false);
    }

    public static String linkTagAction(String target, ServletRequest req) {
        return CmsJspTagLink.linkTagAction(target, req, null);
    }

    public static String linkTagAction(String target, ServletRequest req, String baseUri) {
        return CmsJspTagLink.linkTagAction(target, req, baseUri, null);
    }

    public static String linkTagAction(String target, ServletRequest req, String baseUri, Locale locale) {
        return CmsJspTagLink.linkTagAction(target, req, baseUri, null, locale);
    }

    public static String linkTagAction(String target, ServletRequest req, String baseUri, String detailPage, Locale locale) {
        return CmsJspTagLink.linkTagAction(new Parameters(target, baseUri, detailPage, locale, Type.DEFAULT), req);
    }

    private static CmsObject prepareCmsObject(CmsObject cms1, Parameters params) {
        CmsObject cms = cms1;
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(params.getBaseUri()) || null != params.getLocale()) {
            try {
                cms = OpenCms.initCmsObject(cms);
                if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(params.getBaseUri())) {
                    Locale baseUriLocale;
                    cms.getRequestContext().setUri(params.getBaseUri());
                    if (params.getLocale() == null && (baseUriLocale = CmsJspTagLink.getBaseUriLocale(cms, params.getBaseUri())) != null) {
                        cms.getRequestContext().setLocale(baseUriLocale);
                    }
                }
                if (null != params.getLocale()) {
                    cms.getRequestContext().setLocale(params.getLocale());
                }
            }
            catch (CmsException e) {
                LOG.debug((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        return cms;
    }

    public int doEndTag() throws JspException {
        ServletRequest req = this.pageContext.getRequest();
        if (CmsFlexController.isCmsRequest(req)) {
            try {
                String link = this.getBodyContent().getString();
                this.getBodyContent().clear();
                Parameters params = new Parameters(link, this.getBaseUri(), this.getDetailPage(), this.m_locale, this.m_type);
                if (this.m_var != null) {
                    int scope = 1;
                    if (SCOPE_REQUEST.equalsIgnoreCase(this.m_scope)) {
                        scope = 2;
                    } else if (SCOPE_SESSION.equalsIgnoreCase(this.m_scope)) {
                        scope = 3;
                    } else if (SCOPE_APPLICATION.equalsIgnoreCase(this.m_scope)) {
                        scope = 4;
                    }
                    CmsFlexController controller = CmsFlexController.getController(req);
                    CmsObject cms = CmsJspTagLink.prepareCmsObject(controller.getCmsObject(), params);
                    this.pageContext.setAttribute(this.m_var, (Object)new CmsJspLinkWrapper(cms, link, true), scope);
                } else {
                    String newlink = CmsJspTagLink.linkTagAction(params, req);
                    this.getBodyContent().print(newlink);
                    this.getBodyContent().writeOut((Writer)this.pageContext.getOut());
                }
            }
            catch (Exception ex) {
                if (LOG.isErrorEnabled()) {
                    LOG.error((Object)Messages.get().getBundle().key("ERR_PROCESS_TAG_1", "link"), (Throwable)ex);
                }
                throw new JspException((Throwable)ex);
            }
        }
        return 6;
    }

    public String getBaseUri() {
        return this.m_baseUri;
    }

    public String getDetailPage() {
        return this.m_detailPage;
    }

    public void release() {
        super.release();
    }

    public void setBaseUri(String baseUri) {
        this.m_baseUri = baseUri;
    }

    public void setDetailPage(String detailPage) {
        if ("".equals(detailPage)) {
            detailPage = null;
        }
        this.m_detailPage = detailPage;
    }

    public void setLocale(Locale locale) {
        this.m_locale = locale;
    }

    public void setLocale(String localeName) {
        this.m_locale = CmsLocaleManager.getLocale(localeName);
    }

    public void setScope(String scope) {
        this.m_scope = scope;
    }

    public void setType(String type) {
        this.m_type = type == null ? null : Type.valueOf(type.toUpperCase());
    }

    public void setType(Type type) {
        this.m_type = type;
    }

    public void setVar(String var) {
        this.m_var = var;
    }

    public static class Parameters {
        public String m_target;
        public String m_baseUri;
        public String m_detailPage;
        public Locale m_locale;
        public Type m_type;

        public Parameters() {
        }

        public Parameters(String target, String baseUri, String detailPage, Locale locale, Type type) {
            this.m_target = target;
            this.m_baseUri = baseUri;
            this.m_detailPage = detailPage;
            this.m_locale = locale;
            this.m_type = type != null ? type : Type.DEFAULT;
        }

        public String getBaseUri() {
            return this.m_baseUri;
        }

        public String getDetailPage() {
            return this.m_detailPage;
        }

        public Locale getLocale() {
            return this.m_locale;
        }

        public String getTarget() {
            return this.m_target;
        }

        public Type getType() {
            return this.m_type;
        }

        public void setBaseUri(String baseUri) {
            this.m_baseUri = baseUri;
        }

        public void setDetailPage(String detailPage) {
            this.m_detailPage = detailPage;
        }

        public void setLocale(Locale locale) {
            this.m_locale = locale;
        }

        public void setTarget(String target) {
            this.m_target = target;
        }

        public void setType(Type type) {
            this.m_type = type;
        }
    }

    public static enum Type {
        DEFAULT,
        ONLINE,
        SERVER,
        PERMA;

    }
}

