/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.jsp;

import javax.servlet.ServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.BodyContent;
import javax.servlet.jsp.tagext.BodyTagSupport;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.flex.CmsFlexController;
import org.opencms.jsp.Messages;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.workplace.CmsWorkplaceMessages;

public class CmsJspTagLabel
extends BodyTagSupport {
    private static final Log LOG = CmsLog.getLog(CmsJspTagLabel.class);
    private static final long serialVersionUID = 5720473164730803034L;

    public static String wpLabelTagAction(String label, ServletRequest req) {
        CmsObject cms = CmsFlexController.getCmsObject(req);
        CmsWorkplaceMessages messages = OpenCms.getWorkplaceManager().getMessages(cms.getRequestContext().getLocale());
        return messages.key(label);
    }

    public int doAfterBody() throws JspException {
        ServletRequest req = this.pageContext.getRequest();
        if (CmsFlexController.isCmsRequest(req)) {
            try {
                BodyContent body = this.getBodyContent();
                String label = body.getString();
                body.clearBody();
                String result = CmsJspTagLabel.wpLabelTagAction(label, req);
                this.getPreviousOut().print(result);
            }
            catch (Exception ex) {
                if (LOG.isErrorEnabled()) {
                    LOG.error((Object)Messages.get().getBundle().key("ERR_PROCESS_TAG_1", "label"), (Throwable)ex);
                }
                throw new JspException((Throwable)ex);
            }
        }
        return 0;
    }
}

