/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.jsp;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.jsp.JspException;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.flex.CmsFlexController;
import org.opencms.i18n.CmsEncoder;
import org.opencms.jsp.CmsJspImageScalerTagSupport;
import org.opencms.jsp.I_CmsJspTagParamParent;
import org.opencms.jsp.Messages;
import org.opencms.loader.CmsImageScaler;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.staticexport.CmsLinkManager;
import org.opencms.util.CmsRequestUtil;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUriSplitter;

public class CmsJspTagImage
extends CmsJspImageScalerTagSupport
implements I_CmsJspTagParamParent {
    private static final String ATTR_ALIGN = "align";
    private static final String ATTR_ALT = "alt";
    private static final String ATTR_BORDER = "border";
    private static final String ATTR_CLASS = "class";
    private static final String ATTR_HSPACE = "hspace";
    private static final String ATTR_ID = "id";
    private static final String ATTR_LONGDESC = "longdesc";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_STYLE = "style";
    private static final String ATTR_TITLE = "title";
    private static final String ATTR_USEMAP = "usemap";
    private static final String ATTR_VSPACE = "vspace";
    private static final Log LOG = CmsLog.getLog(CmsJspTagImage.class);
    private static final String SCALE_ATTR_COLOR = "scalecolor";
    private static final String SCALE_ATTR_FILTER = "scalefilter";
    private static final String SCALE_ATTR_NODIM = "nodim";
    private static final String SCALE_ATTR_PARTIALTAG = "partialtag";
    private static final String SCALE_ATTR_SRC = "src";
    private static final String[] SCALER_ATTRS = new String[]{"scalecolor", "scalefilter", "height", "partialtag", "scaleposition", "scalequality", "scalerendermode", "src", "scaletype", "width", "maxHeight", "maxWidth", "nodim"};
    private static final List<String> SCALER_ATTRS_LIST = Arrays.asList(SCALER_ATTRS);
    private static final long serialVersionUID = 6513320107441256414L;
    private Map<String, String> m_attributes;
    private boolean m_noDim;
    private boolean m_partialTag;

    public static CmsImageScaler getScaler(CmsImageScaler scaler, CmsImageScaler original, String scaleParam) {
        if (scaleParam != null) {
            CmsImageScaler cropScaler = null;
            cropScaler = new CmsImageScaler(scaleParam);
            if (scaler.getType() == 5) {
                cropScaler.setWidth(cropScaler.getCropWidth());
                cropScaler.setHeight(cropScaler.getCropHeight());
            }
            scaler = cropScaler.getCropScaler(scaler);
        }
        if ((scaler.getHeight() <= 0 || scaler.getWidth() <= 0 || scaler.getType() == 5 && scaler.isValid() && !scaler.isCropping()) && original.isValid()) {
            scaler = original.getReScaler(scaler);
        }
        return scaler;
    }

    public static String imageTagAction(String src, CmsImageScaler scaler, Map<String, String> attributes, boolean partialTag, boolean noDim, ServletRequest req) throws CmsException {
        String[] scaleStr;
        CmsFlexController controller = CmsFlexController.getController(req);
        CmsObject cms = controller.getCmsObject();
        src = CmsLinkManager.getAbsoluteUri(src, controller.getCurrentRequest().getElementUri());
        CmsUriSplitter splitSrc = new CmsUriSplitter(src);
        String scaleParam = null;
        if (splitSrc.getQuery() != null && (scaleStr = CmsRequestUtil.createParameterMap(splitSrc.getQuery()).get("__scale")) != null) {
            scaleParam = scaleStr[0];
        }
        CmsResource imageRes = cms.readResource(splitSrc.getPrefix());
        CmsImageScaler original = new CmsImageScaler(cms, imageRes);
        scaler = CmsJspTagImage.getScaler(scaler, original, scaleParam);
        StringBuffer result = new StringBuffer(128);
        if (!partialTag) {
            result.append("<img");
        }
        result.append(" src=\"");
        Object imageLink = cms.getSitePath(imageRes);
        if (scaler.isValid()) {
            imageLink = (String)imageLink + scaler.toRequestParam();
        }
        result.append(OpenCms.getLinkManager().substituteLink(cms, (String)imageLink));
        result.append("\"");
        if (!noDim && scaler.isValid()) {
            result.append(" width=\"");
            result.append(scaler.getWidth());
            result.append("\"");
            result.append(" height=\"");
            result.append(scaler.getHeight());
            result.append("\"");
        }
        if (attributes != null) {
            for (Map.Entry<String, String> entry : attributes.entrySet()) {
                String attr = entry.getKey();
                String value = entry.getValue();
                result.append(" ");
                result.append(attr);
                result.append("=\"");
                result.append(CmsEncoder.escapeXml(value));
                result.append("\"");
            }
        }
        if (!partialTag) {
            result.append(" />");
        }
        return result.toString();
    }

    public static String imageTagAction(String src, CmsImageScaler scaler, Map<String, String> attributes, boolean partialTag, ServletRequest req) throws CmsException {
        return CmsJspTagImage.imageTagAction(src, scaler, attributes, partialTag, false, req);
    }

    @Override
    public void addParameter(String name, String value) {
        String key = name.trim().toLowerCase();
        switch (SCALER_ATTRS_LIST.indexOf(key)) {
            case 0: {
                this.setScaleColor(value);
                break;
            }
            case 1: {
                this.setScaleFilter(value);
                break;
            }
            case 2: {
                this.setHeight(value);
                break;
            }
            case 3: {
                this.setPartialTag(value);
                break;
            }
            case 4: {
                this.setScalePosition(value);
                break;
            }
            case 5: {
                this.setScaleQuality(value);
                break;
            }
            case 6: {
                this.setScaleRendermode(value);
                break;
            }
            case 7: {
                this.setSrc(value);
                break;
            }
            case 8: {
                this.setScaleType(value);
                break;
            }
            case 9: {
                this.setWidth(value);
                break;
            }
            case 10: {
                this.setMaxHeight(value);
                break;
            }
            case 11: {
                this.setMaxWidth(value);
                break;
            }
            case 12: {
                this.setNoDim(value);
                break;
            }
            default: {
                this.setAttribute(key, value);
            }
        }
    }

    public int doEndTag() throws JspException {
        ServletRequest req = this.pageContext.getRequest();
        if (CmsFlexController.isCmsRequest(req)) {
            try {
                String imageTag;
                block6: {
                    imageTag = null;
                    try {
                        imageTag = CmsJspTagImage.imageTagAction(this.m_src, this.m_scaler, this.m_attributes, this.m_partialTag, this.m_noDim, req);
                    }
                    catch (CmsException e) {
                        if (!LOG.isWarnEnabled()) break block6;
                        LOG.warn((Object)Messages.get().getBundle().key("ERR_IMAGE_TAG_VFS_ACCESS_1", this.m_src), (Throwable)e);
                    }
                }
                this.pageContext.getOut().print(imageTag == null ? "" : imageTag);
            }
            catch (Exception ex) {
                if (LOG.isErrorEnabled()) {
                    LOG.error((Object)Messages.get().getBundle().key("ERR_PROCESS_TAG_1", "image"), (Throwable)ex);
                }
                throw new JspException((Throwable)ex);
            }
        }
        this.release();
        return 6;
    }

    public int doStartTag() {
        return 2;
    }

    public String getAlign() {
        return this.getAttribute(ATTR_ALIGN);
    }

    public String getAlt() {
        return this.getAttribute(ATTR_ALT);
    }

    public String getBorder() {
        return this.getAttribute(ATTR_BORDER);
    }

    public String getCssclass() {
        return this.getAttribute(ATTR_CLASS);
    }

    public String getHspace() {
        return this.getAttribute(ATTR_HSPACE);
    }

    public String getId() {
        return this.getAttribute(ATTR_ID);
    }

    public String getLongdesc() {
        return this.getAttribute(ATTR_LONGDESC);
    }

    public String getName() {
        return this.getAttribute(ATTR_NAME);
    }

    public String getNoDim() {
        return String.valueOf(this.m_noDim);
    }

    public String getStyle() {
        return this.getAttribute(ATTR_STYLE);
    }

    public String getTitle() {
        return this.getAttribute(ATTR_TITLE);
    }

    public String getUsemap() {
        return this.getAttribute(ATTR_USEMAP);
    }

    public String getVspace() {
        return this.getAttribute(ATTR_VSPACE);
    }

    public String isPartialTag() {
        return String.valueOf(this.m_partialTag);
    }

    @Override
    public void release() {
        this.m_attributes = null;
        this.m_partialTag = false;
        this.m_noDim = false;
        super.release();
    }

    public void setAlign(String value) {
        this.setAttribute(ATTR_ALIGN, value);
    }

    public void setAlt(String value) {
        this.setAttribute(ATTR_ALT, value, true);
    }

    public void setBorder(String value) {
        this.setAttribute(ATTR_BORDER, value);
    }

    public void setCssclass(String value) {
        this.setAttribute(ATTR_CLASS, value);
    }

    public void setHspace(String value) {
        this.setAttribute(ATTR_HSPACE, value);
    }

    public void setId(String value) {
        this.setAttribute(ATTR_ID, value);
    }

    public void setLongdesc(String value) {
        this.setAttribute(ATTR_LONGDESC, value);
    }

    public void setName(String value) {
        this.setAttribute(ATTR_NAME, value);
    }

    public void setNoDim(String noDim) {
        this.m_noDim = Boolean.valueOf(noDim);
    }

    public void setPartialTag(String partialTag) {
        this.m_partialTag = Boolean.valueOf(partialTag);
    }

    public void setStyle(String value) {
        this.setAttribute(ATTR_STYLE, value);
    }

    public void setTitle(String value) {
        this.setAttribute(ATTR_TITLE, value);
    }

    public void setUsemap(String value) {
        this.setAttribute(ATTR_USEMAP, value);
    }

    public void setVspace(String value) {
        this.setAttribute(ATTR_VSPACE, value);
    }

    private String getAttribute(String key) {
        if (this.m_attributes != null) {
            return this.m_attributes.get(key);
        }
        return null;
    }

    private void setAttribute(String key, String value) {
        this.setAttribute(key, value, false);
    }

    private void setAttribute(String key, String value, boolean allowEmptyValue) {
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(value) || allowEmptyValue && value != null) {
            if (this.m_attributes == null) {
                this.m_attributes = new HashMap<String, String>();
            }
            this.m_attributes.put(key, value);
        }
    }
}

