/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.jsp;

import java.io.IOException;
import javax.servlet.http.Cookie;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsUser;
import org.opencms.jsp.CmsJspLoginBean;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.security.CmsPersistentLoginTokenHandler;
import org.opencms.util.CmsMacroResolver;
import org.opencms.util.CmsRequestUtil;

public class CmsJspLoginPersistingBean
extends CmsJspLoginBean {
    private long m_tokenLifetime = 28800000L;
    private String m_cookiePath = "%(CONTEXT_NAME)%(SERVLET_NAME)";
    private boolean m_isTokenSet;
    private static final Log LOG = CmsLog.getLog(CmsJspLoginPersistingBean.class);

    public String getCookiePath(boolean resolveMacros) {
        String result = this.m_cookiePath;
        if (resolveMacros) {
            CmsMacroResolver resolver = new CmsMacroResolver();
            resolver.addMacro("CONTEXT_NAME", OpenCms.getSystemInfo().getContextPath());
            resolver.addMacro("SERVLET_NAME", OpenCms.getSystemInfo().getServletPath());
            result = resolver.resolveMacros(result);
        }
        return result;
    }

    public boolean isTokenSet() {
        return this.m_isTokenSet;
    }

    @Override
    public void login(String userName, String password, String projectName) {
        super.login(userName, password, projectName);
        if (this.isLoginSuccess()) {
            CmsObject cms = this.getCmsObject();
            CmsPersistentLoginTokenHandler tokenHandler = new CmsPersistentLoginTokenHandler();
            tokenHandler.setTokenLifetime(this.m_tokenLifetime);
            try {
                String token = tokenHandler.createToken(cms);
                Cookie cookie = new Cookie("ocmsLoginToken", token);
                cookie.setMaxAge((int)(this.m_tokenLifetime / 1000L));
                cookie.setPath(this.getCookiePath(true));
                this.getResponse().addCookie(cookie);
                this.m_isTokenSet = true;
            }
            catch (CmsException e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    @Override
    public void logout() throws IOException {
        this.logout(true);
    }

    public void logout(boolean invalidateToken) throws IOException {
        if (this.isLoggedIn() && invalidateToken) {
            CmsUser user = this.getCmsObject().getRequestContext().getCurrentUser();
            CmsPersistentLoginTokenHandler tokenHandler = new CmsPersistentLoginTokenHandler();
            try {
                Cookie cookie = new Cookie("ocmsLoginToken", "");
                cookie.setMaxAge(0);
                cookie.setPath(this.getCookiePath(true));
                this.getResponse().addCookie(cookie);
                tokenHandler.invalidateToken(user, CmsRequestUtil.getCookieValue(this.getRequest().getCookies(), "ocmsLoginToken"));
            }
            catch (Exception e) {
                LOG.error((Object)("Could not invalidate tokens for user " + String.valueOf(user)), (Throwable)e);
            }
        }
        super.logout();
    }

    public void setCookiePath(String cookiePath) {
        this.m_cookiePath = cookiePath;
    }

    public void setTokenLifetime(long lifetime) {
        this.m_tokenLifetime = lifetime;
    }
}

