/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.jsp;

import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.PageContext;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsRequestContext;
import org.opencms.flex.CmsFlexController;
import org.opencms.i18n.CmsMessageContainer;
import org.opencms.jsp.Messages;
import org.opencms.main.CmsLog;
import org.opencms.main.CmsRuntimeException;

public class CmsJspBean {
    private static final Log LOG = CmsLog.getLog(CmsJspBean.class);
    private PageContext m_context;
    private CmsFlexController m_controller;
    private boolean m_isNotInitialized = true;
    private boolean m_isSupressingExceptions = true;
    private HttpServletRequest m_request;
    private HttpServletResponse m_response;

    public CmsObject getCmsObject() {
        if (this.m_isNotInitialized) {
            return null;
        }
        return this.m_controller.getCmsObject();
    }

    public PageContext getJspContext() {
        return this.m_context;
    }

    public HttpServletRequest getRequest() {
        return this.m_request;
    }

    public CmsRequestContext getRequestContext() {
        return this.getCmsObject().getRequestContext();
    }

    public HttpServletResponse getResponse() {
        return this.m_response;
    }

    public void init(PageContext context, HttpServletRequest req, HttpServletResponse res) {
        this.m_controller = CmsFlexController.getController((ServletRequest)req);
        if (this.m_controller == null) {
            this.handleMissingFlexController();
        }
        this.m_context = context;
        this.m_request = req;
        this.m_response = res;
        this.m_isNotInitialized = false;
    }

    public boolean isSupressingExceptions() {
        return this.m_isSupressingExceptions;
    }

    public void setContentType(String type) {
        this.m_controller.setContentType(type);
    }

    public void setStatus(int status) {
        this.m_request.setAttribute("org.opencms.util.CmsErrorCode", (Object)status);
    }

    public void setSupressingExceptions(boolean value) {
        this.m_isSupressingExceptions = value;
    }

    protected CmsFlexController getController() {
        return this.m_controller;
    }

    protected String getMessage(CmsMessageContainer container) {
        CmsObject cms = this.getCmsObject();
        String result = cms == null || cms.getRequestContext().getLocale() == null ? container.key() : container.key(cms.getRequestContext().getLocale());
        return result;
    }

    protected void handleException(Throwable t) {
        if (LOG.isErrorEnabled()) {
            LOG.error((Object)Messages.get().getBundle().key("LOG_ERR_JSP_BEAN_0"), t);
        }
        if (!this.m_isSupressingExceptions && !this.getRequestContext().getCurrentProject().isOnlineProject()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)Messages.get().getBundle().key("LOG_DEBUG_INTERRUPTED_EXCEPTION_1", this.getClass().getName()));
            }
            String uri = null;
            Throwable u = this.getController().getThrowable();
            uri = u != null ? this.getController().getThrowableResourceUri() : this.getRequestContext().getUri();
            throw new CmsRuntimeException(Messages.get().container("ERR_RUNTIME_1", uri != null ? uri : this.getClass().getName()), t);
        }
    }

    protected void handleMissingFlexController() {
        throw new CmsRuntimeException(Messages.get().container("ERR_MISSING_CMS_CONTROLLER_1", CmsJspBean.class.getName()));
    }

    protected boolean isNotInitialized() {
        return this.m_isNotInitialized;
    }
}

