/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.jsp;

import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.tagext.BodyTagSupport;
import javax.servlet.jsp.tagext.Tag;
import org.opencms.json.JSONArray;
import org.opencms.json.JSONException;
import org.opencms.json.JSONObject;
import org.opencms.jsp.I_CmsJspJsonContext;
import org.opencms.jsp.util.CmsJspJsonWrapper;

public abstract class A_CmsJspJsonTag
extends BodyTagSupport {
    private static final String SCOPE_REQUEST = "request";
    private static final String SCOPE_SESSION = "session";
    private static final String SCOPE_APPLICATION = "application";
    private static final long serialVersionUID = -4536413263964718943L;
    protected String m_key;
    protected String m_mode;
    protected String m_var;
    protected Object m_target;
    protected String m_scope;

    protected static int getScope(String scope) {
        int ret = 1;
        if (SCOPE_REQUEST.equalsIgnoreCase(scope)) {
            ret = 2;
        } else if (SCOPE_SESSION.equalsIgnoreCase(scope)) {
            ret = 3;
        } else if (SCOPE_APPLICATION.equalsIgnoreCase(scope)) {
            ret = 4;
        }
        return ret;
    }

    public int doEndTag() throws JspException {
        if (this.m_var != null) {
            Object val;
            String modeStr = this.m_mode;
            Mode mode = Mode.wrapper;
            int scopeValue = A_CmsJspJsonTag.getScope(this.m_scope);
            if (modeStr != null) {
                try {
                    mode = Mode.valueOf(modeStr);
                }
                catch (Exception e) {
                    throw new JspTagException("Unknown mode for json tag: " + modeStr);
                }
            }
            switch (mode) {
                case object: {
                    val = this.getJsonValue();
                    break;
                }
                case text: {
                    try {
                        val = JSONObject.valueToString(this.getJsonValue());
                        break;
                    }
                    catch (JSONException e) {
                        throw new JspTagException("Could not format JSON", (Throwable)e);
                    }
                }
                default: {
                    val = new CmsJspJsonWrapper(this.getJsonValue());
                }
            }
            this.pageContext.setAttribute(this.m_var, val, scopeValue);
        } else if (this.m_target != null) {
            this.addToTarget(this.m_target, this.getJsonValue(), this.m_key);
        } else {
            I_CmsJspJsonContext context = (I_CmsJspJsonContext)A_CmsJspJsonTag.findAncestorWithClass((Tag)this, I_CmsJspJsonContext.class);
            if (context != null) {
                context.addValue(this.m_key, this.getJsonValue());
            }
        }
        return 6;
    }

    public abstract Object getJsonValue() throws JspTagException;

    public void release() {
        this.init();
        super.release();
    }

    public void setKey(String key) {
        this.m_key = key;
    }

    public void setMode(String mode) {
        this.m_mode = mode;
    }

    public void setScope(String scope) {
        this.m_scope = scope;
    }

    public void setTarget(Object target) {
        this.m_target = target;
    }

    public void setVar(String var) {
        this.m_var = var;
    }

    protected void addToTarget(Object target, Object val, String key) throws JspException {
        if (target instanceof JSONObject) {
            if (key == null) {
                throw new JspTagException("Can not add to JSONObject target with no key (val:" + String.valueOf(val) + ")");
            }
            try {
                JSONObject jsonObj = (JSONObject)target;
                if (jsonObj.has(key)) {
                    jsonObj.append(key, val);
                }
                jsonObj.put(key, val);
            }
            catch (JSONException e) {
                throw new JspTagException("Could not add value to JSONObject target", (Throwable)e);
            }
        } else if (target instanceof JSONArray) {
            ((JSONArray)target).put(val);
        } else if (target instanceof CmsJspJsonWrapper) {
            Object wrappedTaget = ((CmsJspJsonWrapper)target).getObject();
            this.addToTarget(wrappedTaget, val, key);
        } else {
            throw new JspTagException("Invalid target specified (target:" + String.valueOf(val) + ")");
        }
    }

    protected void init() {
        this.m_key = null;
        this.m_var = null;
        this.m_mode = null;
        this.m_target = null;
        this.m_scope = null;
    }

    static enum Mode {
        object,
        wrapper,
        text;

    }
}

