/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.importexport;

import com.google.common.collect.Lists;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProperty;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.i18n.CmsMessageContainer;
import org.opencms.importexport.CmsImportParameters;
import org.opencms.importexport.CmsImportVersion10;
import org.opencms.importexport.Messages;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.module.CmsModuleImportData;
import org.opencms.module.CmsResourceImportData;
import org.opencms.report.I_CmsReport;

public class CmsImportResourceDataReader
extends CmsImportVersion10 {
    private static final Log LOG = CmsLog.getLog(CmsImportResourceDataReader.class);
    private CmsModuleImportData m_moduleData;

    public CmsImportResourceDataReader(CmsModuleImportData moduleData) {
        this.m_moduleData = moduleData;
    }

    @Override
    public void importAccessControlEntries() {
    }

    @Override
    public void importData(CmsObject cms, I_CmsReport report, CmsImportParameters parameters) {
        try {
            this.matches(parameters);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        super.importData(cms, report, parameters);
    }

    @Override
    public void importRelations() {
    }

    @Override
    public void importResource() {
        try {
            boolean isExistingParent;
            if (this.m_throwable != null) {
                this.getReport().println(this.m_throwable);
                this.getReport().addError(this.m_throwable);
                CmsMessageContainer message = Messages.get().container("ERR_IMPORTEXPORT_ERROR_IMPORTING_RESOURCES_0");
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)message.key(), this.m_throwable);
                }
                this.m_throwable = null;
                this.m_importACEs = false;
                this.m_resource = null;
                return;
            }
            String translatedName = this.getRequestContext().addSiteRoot(this.m_parameters.getDestinationPath() + this.m_destination);
            boolean resourceImmutable = this.checkImmutable(translatedName);
            translatedName = this.getRequestContext().removeSiteRoot(translatedName);
            boolean bl = isExistingParent = !this.m_hasStructureId && this.isFolderType(this.m_typeName) && this.getCms().existsResource(translatedName, CmsResourceFilter.ALL);
            if (!resourceImmutable && !isExistingParent) {
                byte[] content = null;
                if (this.m_source != null) {
                    content = this.m_helper.getFileBytes(this.m_source);
                }
                int size = 0;
                if (content != null) {
                    size = content.length;
                }
                this.setDefaultsForEmptyResourceFields();
                CmsResource resource = this.createResourceObjectFromFields(translatedName, size);
                if (!OpenCms.getResourceManager().hasResourceType(this.m_typeName)) {
                    CmsProperty prop = new CmsProperty("export.type", null, this.m_typeName);
                    this.m_properties.put("export.type", prop);
                }
                CmsResourceImportData resData = new CmsResourceImportData(resource, translatedName, content, Lists.newArrayList(this.m_properties.values()), this.m_aces, this.m_relationsForResource, this.m_hasStructureId, this.m_hasDateLastModified, this.m_typeName);
                this.m_moduleData.addResource(resData);
            }
        }
        catch (Exception e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            this.m_report.println(e);
        }
    }

    @Override
    public void rewriteParseables() {
    }
}

