/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.i18n;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.AccessControlException;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;
import org.opencms.i18n.CmsListResourceBundle;
import org.opencms.i18n.CmsLocaleManager;
import org.opencms.i18n.CmsPropertyResourceBundle;
import org.opencms.i18n.I_CmsResourceBundle;
import org.opencms.util.CmsFileUtil;

public final class CmsResourceBundleLoader {
    private static Map<BundleKey, ResourceBundle> m_bundleCache;
    private static Locale m_lastDefaultLocale;
    private static Map<String, I_CmsResourceBundle> m_permanentCache;
    private static final ResourceBundle NULL_ENTRY;

    private CmsResourceBundleLoader() {
    }

    public static void addBundleToCache(String baseName, Locale locale, I_CmsResourceBundle bundle) {
        Object key = baseName;
        if (locale != null) {
            key = (String)key + "_" + String.valueOf(locale);
        }
        m_permanentCache.put((String)key, bundle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void flushBundleCache() {
        Map<BundleKey, ResourceBundle> map = m_bundleCache;
        synchronized (map) {
            m_bundleCache.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void flushBundleCache(String baseName, boolean flushPermanent) {
        if (baseName != null) {
            Map<BundleKey, ResourceBundle> map = m_bundleCache;
            synchronized (map) {
                ConcurrentHashMap<BundleKey, ResourceBundle> bundleCacheNew = new ConcurrentHashMap<BundleKey, ResourceBundle>(m_bundleCache.size());
                for (Map.Entry<BundleKey, ResourceBundle> entry : m_bundleCache.entrySet()) {
                    if (entry.getKey().isSameBase(baseName)) continue;
                    bundleCacheNew.put(entry.getKey(), entry.getValue());
                }
                if (bundleCacheNew.size() < m_bundleCache.size()) {
                    m_bundleCache = bundleCacheNew;
                }
                if (flushPermanent) {
                    CmsResourceBundleLoader.flushPermanentCache(baseName);
                }
            }
        }
    }

    public static void flushPermanentCache(String baseName) {
        HashSet<String> keys = new HashSet<String>(m_permanentCache.keySet());
        for (String key : keys) {
            if (!key.startsWith(baseName) || key.length() != baseName.length() && key.charAt(baseName.length()) != '_') continue;
            m_permanentCache.remove(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ResourceBundle getBundle(String baseName, Locale locale) {
        BundleKey m_lookupKey;
        ResourceBundle obj;
        Locale defaultLocale = Locale.getDefault();
        if (defaultLocale != m_lastDefaultLocale) {
            Map<BundleKey, ResourceBundle> map = m_bundleCache;
            synchronized (map) {
                if (defaultLocale != m_lastDefaultLocale) {
                    m_bundleCache = new ConcurrentHashMap<BundleKey, ResourceBundle>();
                    m_lastDefaultLocale = defaultLocale;
                }
            }
        }
        if ((obj = m_bundleCache.get(m_lookupKey = new BundleKey(baseName, locale))) instanceof ResourceBundle) {
            return obj;
        }
        if (obj != NULL_ENTRY) {
            Map<BundleKey, ResourceBundle> map = m_bundleCache;
            synchronized (map) {
                obj = m_bundleCache.get(m_lookupKey);
                if (obj instanceof ResourceBundle) {
                    return obj;
                }
                boolean wantBase = locale.equals(m_lastDefaultLocale);
                ResourceBundle bundle = CmsResourceBundleLoader.tryBundle(baseName, locale, wantBase);
                if (bundle == null && !locale.equals(m_lastDefaultLocale)) {
                    bundle = CmsResourceBundleLoader.tryBundle(baseName, m_lastDefaultLocale, true);
                }
                BundleKey key = new BundleKey(baseName, locale);
                if (bundle != null) {
                    m_bundleCache.put(key, bundle);
                    return bundle;
                }
            }
        }
        return ResourceBundle.getBundle(baseName, locale);
    }

    private static I_CmsResourceBundle tryBundle(String localizedName) {
        I_CmsResourceBundle result;
        block7: {
            result = null;
            try {
                String resourceName = localizedName.replace('.', '/') + ".properties";
                URL url = CmsResourceBundleLoader.class.getClassLoader().getResource(resourceName);
                I_CmsResourceBundle additionalBundle = m_permanentCache.get(localizedName);
                if (additionalBundle != null) {
                    result = additionalBundle.getClone();
                    break block7;
                }
                if (url == null) break block7;
                InputStream is = null;
                String path = CmsFileUtil.normalizePath(url);
                File file = new File(path);
                try {
                    is = new FileInputStream(file);
                }
                catch (IOException ex) {
                    is = CmsResourceBundleLoader.class.getClassLoader().getResourceAsStream(resourceName);
                }
                catch (AccessControlException acex) {
                    is = CmsResourceBundleLoader.class.getClassLoader().getResourceAsStream(resourceName);
                }
                if (is != null) {
                    result = new CmsPropertyResourceBundle(is);
                }
            }
            catch (IOException ex) {
                MissingResourceException mre = new MissingResourceException("Failed to load bundle '" + localizedName + "'", localizedName, "");
                mre.initCause(ex);
                throw mre;
            }
        }
        return result;
    }

    private static ResourceBundle tryBundle(String baseName, Locale locale, boolean wantBase) {
        I_CmsResourceBundle first = null;
        I_CmsResourceBundle last = null;
        List<String> bundleNames = CmsLocaleManager.getLocaleVariants(baseName, locale, true, true);
        for (String bundleName : bundleNames) {
            if (bundleName.equals(baseName) && !wantBase && first == null) break;
            I_CmsResourceBundle foundBundle = CmsResourceBundleLoader.tryBundle(bundleName);
            if (foundBundle == null) continue;
            if (first == null) {
                first = foundBundle;
            }
            if (last != null) {
                last.setParent((ResourceBundle)((Object)foundBundle));
            }
            foundBundle.setLocale(locale);
            last = foundBundle;
        }
        return (ResourceBundle)((Object)first);
    }

    static {
        NULL_ENTRY = new CmsListResourceBundle();
        m_bundleCache = new ConcurrentHashMap<BundleKey, ResourceBundle>();
        m_lastDefaultLocale = Locale.getDefault();
        m_permanentCache = new ConcurrentHashMap<String, I_CmsResourceBundle>();
    }

    private static class BundleKey {
        private String m_baseName;
        private int m_hashcode;
        private Locale m_locale;

        BundleKey(String s, Locale l) {
            this.set(s, l);
        }

        public boolean equals(Object o) {
            if (!(o instanceof BundleKey)) {
                return false;
            }
            BundleKey key = (BundleKey)o;
            return this.m_hashcode == key.m_hashcode && this.m_baseName.equals(key.m_baseName) && this.m_locale.equals(key.m_locale);
        }

        public int hashCode() {
            return this.m_hashcode;
        }

        public boolean isSameBase(String baseName) {
            return this.m_baseName.equals(baseName);
        }

        public String toString() {
            return this.m_baseName + "_" + String.valueOf(this.m_locale);
        }

        void set(String s, Locale l) {
            this.m_baseName = s;
            this.m_locale = l;
            this.m_hashcode = this.m_baseName.hashCode() ^ this.m_locale.hashCode();
        }
    }
}

