/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.i18n;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProperty;
import org.opencms.file.CmsResource;
import org.opencms.i18n.CmsLocaleManager;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.site.CmsSite;

public class CmsLocaleGroup {
    private static final Log LOG = CmsLog.getLog(CmsLocaleGroup.class);
    private CmsObject m_cms;
    private Map<CmsResource, Locale> m_localeCache = Maps.newHashMap();
    private String m_noTranslation;
    private CmsResource m_primaryResource;
    private Multimap<Locale, CmsResource> m_resourcesByLocale = ArrayListMultimap.create();
    private Set<CmsResource> m_secondaryResources;

    public CmsLocaleGroup(CmsObject cms, CmsResource primaryResource, List<CmsResource> secondaryResources) {
        this.m_primaryResource = primaryResource;
        this.m_secondaryResources = Sets.newHashSet(secondaryResources);
        this.m_cms = cms;
        this.initLocales();
    }

    public List<CmsResource> getAllResources() {
        ArrayList result = Lists.newArrayList();
        result.add(this.m_primaryResource);
        for (CmsResource res : this.getSecondaryResources()) {
            result.add(res);
        }
        return result;
    }

    public Locale getMainLocale() {
        return this.m_localeCache.get(this.m_primaryResource);
    }

    public CmsResource getPrimaryResource() {
        return this.m_primaryResource;
    }

    public Map<Locale, CmsResource> getResourcesByLocale() {
        ArrayList resources = Lists.newArrayList();
        resources.add(this.m_primaryResource);
        resources.addAll(this.m_secondaryResources);
        Collections.sort(resources, new Comparator<CmsResource>(){

            @Override
            public int compare(CmsResource arg0, CmsResource arg1) {
                String path1 = arg0.getRootPath();
                String path2 = arg1.getRootPath();
                return path2.compareTo(path1);
            }
        });
        LinkedHashMap<Locale, CmsResource> result = new LinkedHashMap<Locale, CmsResource>();
        for (CmsResource resource : resources) {
            result.put(this.m_localeCache.get(resource), resource);
        }
        return result;
    }

    public Collection<CmsResource> getResourcesForLocale(Locale locale) {
        return Lists.newArrayList((Iterable)this.m_resourcesByLocale.get((Object)locale));
    }

    public Set<CmsResource> getSecondaryResources() {
        return Collections.unmodifiableSet(this.m_secondaryResources);
    }

    public boolean hasLocale(Locale locale) {
        return this.m_resourcesByLocale.containsKey((Object)locale);
    }

    public boolean isMarkedNoTranslation(Locale locale) {
        return this.m_noTranslation != null && CmsLocaleManager.getLocales(this.m_noTranslation).contains(locale);
    }

    public boolean isMarkedNoTranslation(Set<Locale> locales) {
        if (this.m_noTranslation == null) {
            return false;
        }
        List<Locale> noTranslationLocales = CmsLocaleManager.getLocales(this.m_noTranslation);
        for (Locale locale : noTranslationLocales) {
            if (!locales.contains(locale)) continue;
            return true;
        }
        return false;
    }

    public boolean isPotentialGroupHead() {
        CmsSite site = OpenCms.getSiteManager().getSiteForRootPath(this.m_primaryResource.getRootPath());
        if (site == null) {
            return false;
        }
        Locale mainLocale = site.getMainTranslationLocale(null);
        if (mainLocale == null) {
            return false;
        }
        Locale primaryLocale = this.getMainLocale();
        return mainLocale.equals(primaryLocale);
    }

    public boolean isRealGroup() {
        return this.m_secondaryResources.size() > 0;
    }

    public boolean isRealGroupOrPotentialGroupHead() {
        return this.isRealGroup() || this.isPotentialGroupHead();
    }

    Set<Locale> getLocales() {
        return Sets.newHashSet(this.getResourcesByLocale().keySet());
    }

    private void initLocales() {
        if (!this.m_localeCache.isEmpty()) {
            return;
        }
        this.readLocale(this.m_primaryResource);
        for (CmsResource cmsResource : this.m_secondaryResources) {
            this.readLocale(cmsResource);
        }
        for (Map.Entry entry : this.m_localeCache.entrySet()) {
            CmsResource key = (CmsResource)entry.getKey();
            Locale value = (Locale)entry.getValue();
            this.m_resourcesByLocale.put((Object)value, (Object)key);
        }
        try {
            CmsProperty noTranslationProp = this.m_cms.readPropertyObject(this.m_primaryResource, "locale.notranslation", false);
            this.m_noTranslation = noTranslationProp.getValue();
        }
        catch (CmsException e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
    }

    private void readLocale(CmsResource res) {
        Locale locale = OpenCms.getLocaleManager().getDefaultLocale(this.m_cms, res);
        this.m_localeCache.put(res, locale);
    }
}

