/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.gwt.shared;

import com.google.common.base.Joiner;
import com.google.gwt.user.client.rpc.IsSerializable;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.opencms.util.CmsStringUtil;

public class CmsUploadRestrictionInfo
implements IsSerializable {
    public static final String KEY_ENABLED = "enabled";
    public static final String KEY_TYPES = "types";
    public static final String UNRESTRICTED_UPLOADS = "enabled:true|types:*";
    protected Node m_root;

    protected CmsUploadRestrictionInfo() {
    }

    public static NodeData collectNodeData(Node root, String path) {
        NodeData empty = new NodeData();
        NodeData currentData = empty.merge(root.getData());
        Node current = root;
        List<String> pathComponents = Arrays.asList(path.split("/"));
        for (String part : pathComponents) {
            if ("".equals(part)) continue;
            Node child = current.getChildren().get(part);
            if (child == null) break;
            currentData = currentData.merge(child.getData());
            current = child;
        }
        return currentData;
    }

    public static Node findOrCreateNode(Node root, String path) {
        Node current = root;
        if (!"/".equals(path) && !"".equals(path)) {
            List<String> pathComponents = Arrays.asList(path.split("/"));
            for (String part : pathComponents) {
                Node child;
                if ("".equals(part)) continue;
                current = child = current.getChildren().computeIfAbsent(part, k -> new Node());
            }
        }
        return current;
    }

    static String normalizePath(String path) {
        if (!((String)path).endsWith("/")) {
            path = (String)path + "/";
        }
        return path;
    }

    public boolean checkTypeAllowed(String path, String extension) {
        Set<String> types = this.getTypes(path);
        if (extension.startsWith(".")) {
            extension = extension.substring(1);
        }
        boolean result = types.contains(extension = extension.toLowerCase()) || types.contains("*");
        return result;
    }

    public String getAcceptAttribute(String path) {
        Set<String> types = this.getTypes(path);
        ArrayList<CallSite> suffixes = new ArrayList<CallSite>();
        for (String type : types) {
            if ("*".equals(type)) {
                return "";
            }
            suffixes.add((CallSite)((Object)("." + type)));
        }
        String result = Joiner.on((String)",").join(suffixes);
        return result;
    }

    public boolean isUploadEnabled(String originalPath) {
        NodeData data = CmsUploadRestrictionInfo.collectNodeData(this.m_root, originalPath);
        return data.getEnabled() == null || data.getEnabled() != false;
    }

    protected Set<String> getTypes(String path) {
        NodeData data = CmsUploadRestrictionInfo.collectNodeData(this.m_root, path);
        if (data.getExtensions() == null) {
            return Collections.emptySet();
        }
        return data.getExtensions();
    }

    public static class NodeData
    implements IsSerializable {
        private Boolean m_enabled;
        private Set<String> m_extensions;

        public boolean equals(Object other) {
            if (!(other instanceof NodeData)) {
                return false;
            }
            NodeData data = (NodeData)other;
            return Objects.equals(this.m_enabled, data.getEnabled()) && Objects.equals(this.m_extensions, data.getExtensions());
        }

        public int hashCode() {
            return Objects.hash(this.m_enabled, this.m_extensions);
        }

        public NodeData merge(NodeData child) {
            if (child == null) {
                return this;
            }
            if (child.getExtensions() != null && child.getEnabled() != null) {
                return child;
            }
            NodeData result = new NodeData();
            if (child.getExtensions() != null) {
                result.setExtensions(child.getExtensions());
            } else {
                result.setExtensions(this.getExtensions());
            }
            if (child.getEnabled() != null) {
                result.setEnabled(child.getEnabled());
            } else {
                result.setEnabled(this.getEnabled());
            }
            return result;
        }

        public void parse(String info) {
            String typesStr;
            Map<String, String> parsedInfo = CmsStringUtil.splitAsMap(info, "|", ":");
            String enabledStr = parsedInfo.get(CmsUploadRestrictionInfo.KEY_ENABLED);
            if (enabledStr != null) {
                this.setEnabled(Boolean.valueOf(enabledStr));
            }
            if ((typesStr = parsedInfo.get(CmsUploadRestrictionInfo.KEY_TYPES)) != null) {
                HashSet<String> types = new HashSet<String>();
                for (String type : typesStr.split(",")) {
                    if ((type = type.trim().toLowerCase()).startsWith(".")) {
                        type = type.substring(1);
                    }
                    if (type.length() <= 0) continue;
                    types.add(type);
                }
                this.setExtensions(types);
            }
        }

        private Boolean getEnabled() {
            return this.m_enabled;
        }

        private Set<String> getExtensions() {
            return this.m_extensions;
        }

        private void setEnabled(Boolean enabled) {
            this.m_enabled = enabled;
        }

        private void setExtensions(Set<String> extensions) {
            this.m_extensions = extensions;
        }
    }

    public static class Node
    implements IsSerializable {
        private Map<String, Node> m_children = new HashMap<String, Node>();
        private NodeData m_data;

        public Map<String, Node> getChildren() {
            return this.m_children;
        }

        public NodeData getData() {
            return this.m_data;
        }

        public void setData(NodeData data) {
            this.m_data = data;
        }
    }

    public static class Builder {
        private Node m_root = new Node();
        private Map<NodeData, NodeData> m_nodeDataCache = new HashMap<NodeData, NodeData>();

        public Builder add(String path, Boolean enabled, Set<String> extensions) {
            Node node = CmsUploadRestrictionInfo.findOrCreateNode(this.m_root, path);
            NodeData data = new NodeData();
            data.setEnabled(enabled);
            data.setExtensions(extensions);
            data = this.m_nodeDataCache.computeIfAbsent(data, dataParam -> dataParam);
            node.setData(data);
            return this;
        }

        public Builder add(String path, String info) {
            Node node = CmsUploadRestrictionInfo.findOrCreateNode(this.m_root, path);
            NodeData data = new NodeData();
            data.parse(info);
            data = this.m_nodeDataCache.computeIfAbsent(data, dataParam -> dataParam);
            node.setData(data);
            return this;
        }

        public CmsUploadRestrictionInfo build() {
            CmsUploadRestrictionInfo result = new CmsUploadRestrictionInfo();
            result.m_root = this.m_root;
            return result;
        }
    }
}

