/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.gwt.shared;

import com.google.common.collect.ComparisonChain;
import com.google.gwt.user.client.rpc.IsSerializable;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;

public class CmsGalleryContainerInfo
implements IsSerializable {
    private TreeSet<Item> m_items;

    public CmsGalleryContainerInfo(Set<Item> items) {
        this.m_items = new TreeSet<Item>(items);
    }

    protected CmsGalleryContainerInfo() {
    }

    public TreeSet<Item> getItems() {
        return this.m_items;
    }

    public String toString() {
        return "ContainerInfo[" + String.valueOf(this.m_items) + "]";
    }

    public static class Item
    implements IsSerializable,
    Comparable<Item> {
        private String m_type;
        private int m_width;

        public Item(String type, int width) {
            this.m_type = type;
            this.m_width = width;
        }

        protected Item() {
        }

        @Override
        public int compareTo(Item other) {
            return ComparisonChain.start().compare((Comparable)((Object)this.m_type), (Comparable)((Object)other.m_type)).compare(this.m_width, other.m_width).result();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Item other = (Item)obj;
            return Objects.equals(this.m_type, other.m_type) && this.m_width == other.m_width;
        }

        public String getType() {
            return this.m_type;
        }

        public int getWidth() {
            return this.m_width;
        }

        public int hashCode() {
            return Objects.hash(this.m_type, this.m_width);
        }

        public String toString() {
            return "[type=" + this.m_type + ", width=" + this.m_width + "]";
        }
    }
}

