/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.gwt;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsUser;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsStringUtil;

public class CmsUsedCategoriesList {
    public static final String ADDINFO_USED_CATEGORIES = "USED_CATEGORIES";
    public static final String CONF_USED_CATEGORIES_LIMIT = "usedCategoriesLimit";
    public static final int USED_CATEGORIES_LIMIT = 50;
    private static final Log LOG = CmsLog.getLog(CmsUsedCategoriesList.class);
    @JsonProperty(value="c")
    ArrayList<String> m_categories = new ArrayList();

    public static void addUsedCategoryForCurrentUser(CmsObject cms, String category) throws CmsException {
        CmsUser user = cms.getRequestContext().getCurrentUser();
        String usedCategoriesInfo = (String)user.getAdditionalInfo(ADDINFO_USED_CATEGORIES);
        CmsUsedCategoriesList usedCategories = CmsUsedCategoriesList.fromJson(usedCategoriesInfo);
        int limit = 50;
        Object configuredUsedCategoriesLimit = OpenCms.getRuntimeProperty(CONF_USED_CATEGORIES_LIMIT);
        if (configuredUsedCategoriesLimit != null) {
            try {
                limit = Integer.parseInt(String.valueOf(configuredUsedCategoriesLimit));
            }
            catch (NumberFormatException e) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        usedCategories.add(category);
        usedCategories.limit(limit);
        user.setAdditionalInfo(ADDINFO_USED_CATEGORIES, usedCategories.toJson());
        cms.writeUser(user);
    }

    public static CmsUsedCategoriesList fromJson(String json) {
        ObjectMapper mapper = new ObjectMapper();
        if (CmsStringUtil.isEmptyOrWhitespaceOnly(json)) {
            return new CmsUsedCategoriesList();
        }
        try {
            return (CmsUsedCategoriesList)mapper.readerFor(CmsUsedCategoriesList.class).readValue(json);
        }
        catch (Exception e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            return new CmsUsedCategoriesList();
        }
    }

    public void add(String category) {
        this.m_categories.remove(category);
        this.m_categories.add(category);
    }

    @JsonIgnore
    public Set<String> getCategories() {
        return new HashSet<String>(this.m_categories);
    }

    public void limit(int maxEntries) {
        if (this.m_categories.size() > maxEntries) {
            this.m_categories.subList(0, this.m_categories.size() - maxEntries).clear();
        }
    }

    public String toJson() {
        ObjectMapper mapper = new ObjectMapper();
        try {
            return mapper.writeValueAsString((Object)this);
        }
        catch (Exception e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            return "";
        }
    }
}

