/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.gwt;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.types.CmsResourceTypeXmlContainerPage;
import org.opencms.jsp.CmsJspNavBuilder;
import org.opencms.main.CmsEvent;
import org.opencms.main.I_CmsEventListener;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsStringUtil;
import org.opencms.workplace.CmsWorkplace;
import org.opencms.workplace.explorer.CmsExplorerTypeSettings;
import org.opencms.workplace.explorer.CmsIconRule;

public final class CmsIconUtil
implements I_CmsEventListener {
    public static final String ICON_MODEL_GROUP_BIG = "cms_type_icon oc-icon-24-modelgroup_copy";
    public static final String ICON_MODEL_GROUP_COPY_BIG = "cms_type_icon oc-icon-24-modelgroup_copy";
    public static final String ICON_MODEL_GROUP_COPY_SMALL = "cms_type_icon oc-icon-16-modelgroup_copy";
    public static final String ICON_NAV_LEVEL_BIG = "cms_type_icon oc-icon-24-navlevel";
    public static final String ICON_NAV_LEVEL_SMALL = "cms_type_icon oc-icon-16-navlevel";
    public static final String NOT_FOUND_ICON_BIG = "cms_type_icon oc-icon-24-warning";
    public static final String NOT_FOUND_ICON_SMALL = "cms_type_icon oc-icon-16-warning";
    public static final String SMALL_SUFFIX = "_small";
    public static final String TYPE_RESOURCE_NOT_FOUND = "cms_resource_not_found";
    private static String m_cachedCss;
    private static Map<String, String> m_extensionIconMapping;
    private static boolean m_listenerRegistered;

    private CmsIconUtil() {
    }

    public static String buildResourceIconCss() {
        if (!m_listenerRegistered) {
            CmsIconUtil.registerListener();
        }
        if (m_cachedCss == null) {
            CmsIconUtil.rebuildCss();
        }
        return m_cachedCss;
    }

    public static String getDisplayType(CmsObject cms, CmsResource resource) {
        String result = CmsJspNavBuilder.isNavLevelFolder(cms, resource) ? "navlevel" : (CmsResourceTypeXmlContainerPage.isModelCopyGroup(cms, resource) ? "modelgroupcopy" : OpenCms.getResourceManager().getResourceType(resource).getTypeName());
        return result;
    }

    public static Map<String, String> getExtensionIconMapping() {
        if (m_extensionIconMapping == null) {
            m_extensionIconMapping = new HashMap<String, String>();
            for (Map.Entry<String, String> entry : OpenCms.getResourceManager().getExtensionMapping().entrySet()) {
                m_extensionIconMapping.put(entry.getKey(), CmsIconUtil.getIconClasses(entry.getValue(), "_." + entry.getKey(), false));
            }
            m_extensionIconMapping.put("", CmsIconUtil.getIconClasses("plain", null, false));
        }
        return new HashMap<String, String>(m_extensionIconMapping);
    }

    public static String getIconClasses(CmsExplorerTypeSettings typeSettings, String resourceName, boolean small) {
        CmsIconRule rule;
        String extension;
        Object result = null;
        if (typeSettings == null) {
            typeSettings = OpenCms.getWorkplaceManager().getExplorerTypeSetting(resourceName != null && CmsResource.isFolder(resourceName) ? "unknown_file" : "unknown_folder");
        }
        if (!typeSettings.getIconRules().isEmpty() && resourceName != null && (extension = CmsResource.getExtension(resourceName)) != null && (rule = typeSettings.getIconRules().get(extension)) != null) {
            Object object = result = small ? rule.getSmallIconStyle() : rule.getBigIconStyle();
        }
        if (result == null) {
            if (small && typeSettings.getSmallIconStyle() != null) {
                result = typeSettings.getSmallIconStyle();
            } else if (small && typeSettings.getIcon() == null) {
                result = "oc-icon-16-default";
            } else if (!small && typeSettings.getBigIconStyle() != null) {
                result = typeSettings.getBigIconStyle();
            } else if (!small && typeSettings.getBigIcon() == null) {
                result = "oc-icon-24-default";
            }
            result = result != null ? "cms_type_icon " + (String)result : CmsIconUtil.getResourceIconClasses(typeSettings.getName(), resourceName, small);
        }
        return result;
    }

    public static String getIconClasses(String resourceType, String resourceName, boolean small) {
        String result = resourceType.equals("navlevel") ? (small ? ICON_NAV_LEVEL_SMALL : ICON_NAV_LEVEL_BIG) : (resourceType.equals("modelgroupcopy") ? (small ? ICON_MODEL_GROUP_COPY_SMALL : "cms_type_icon oc-icon-24-modelgroup_copy") : (resourceType.equals(TYPE_RESOURCE_NOT_FOUND) ? (small ? NOT_FOUND_ICON_SMALL : NOT_FOUND_ICON_BIG) : CmsIconUtil.getIconClasses(OpenCms.getWorkplaceManager().getExplorerTypeSetting(resourceType), resourceName, small)));
        return result;
    }

    static String getResourceSubTypeIconClass(String resourceTypeName, String suffix, boolean small) {
        StringBuffer buffer = new StringBuffer("cms_type_icon").append("_").append(resourceTypeName.hashCode()).append("_").append(suffix);
        if (small) {
            buffer.append(SMALL_SUFFIX);
        }
        return buffer.toString();
    }

    static String getResourceTypeIconClass(String resourceTypeName, boolean small) {
        StringBuffer sb = new StringBuffer("cms_type_icon");
        sb.append("_").append(resourceTypeName.hashCode());
        if (small) {
            sb.append(SMALL_SUFFIX);
        }
        return sb.toString();
    }

    private static String getFileTypeIconClass(String resourceTypeName, String fileName, boolean small) {
        if (fileName != null && fileName.contains(".")) {
            int last = fileName.lastIndexOf(".");
            if (fileName.length() > last + 1) {
                String suffix = fileName.substring(fileName.lastIndexOf(".") + 1);
                return CmsIconUtil.getResourceSubTypeIconClass(resourceTypeName, suffix, small);
            }
        }
        return "";
    }

    private static String getResourceIconClasses(String resourceTypeName, String fileName, boolean small) {
        StringBuffer sb = new StringBuffer("cms_type_icon");
        sb.append(" ").append(CmsIconUtil.getResourceTypeIconClass(resourceTypeName, small)).append(" ").append(CmsIconUtil.getFileTypeIconClass(resourceTypeName, fileName, small));
        return sb.toString();
    }

    private static synchronized void rebuildCss() {
        if (m_cachedCss == null) {
            CssBuilder builder = new CssBuilder();
            m_cachedCss = builder.buildResourceIconCss();
        }
    }

    private static synchronized void registerListener() {
        if (!m_listenerRegistered) {
            OpenCms.getEventManager().addCmsEventListener(new CmsIconUtil(), new int[]{5});
            m_listenerRegistered = true;
        }
    }

    @Override
    public void cmsEvent(CmsEvent event) {
        m_cachedCss = null;
    }

    static class CssBuilder {
        private StringBuffer m_buffer = new StringBuffer(1024);

        CssBuilder() {
        }

        public String buildResourceIconCss() {
            for (CmsExplorerTypeSettings type : OpenCms.getWorkplaceManager().getExplorerTypeSettings()) {
                this.addCssForType(type);
            }
            return this.m_buffer.toString();
        }

        private void addCssForIconRule(String typeName, CmsIconRule rule) {
            String extension = rule.getExtension();
            if (rule.getBigIcon() != null) {
                IconCssRuleBuilder cssBig = new IconCssRuleBuilder();
                cssBig.addSelectorForSubType(typeName, extension, false);
                cssBig.setImageUri(this.getIconUri(rule.getBigIcon()));
                cssBig.writeCss(this.m_buffer);
                IconCssRuleBuilder cssSmall = new IconCssRuleBuilder();
                cssSmall.addSelectorForSubType(typeName, extension, true);
                cssSmall.setImageUri(this.getIconUri(rule.getIcon()));
                cssSmall.writeCss(this.m_buffer);
            } else {
                IconCssRuleBuilder css = new IconCssRuleBuilder();
                css.addSelectorForSubType(typeName, extension, false);
                css.addSelectorForSubType(typeName, extension, true);
                css.setImageUri(this.getIconUri(rule.getIcon()));
                css.writeCss(this.m_buffer);
            }
        }

        private void addCssForType(CmsExplorerTypeSettings explorerType) {
            String typeName = explorerType.getName();
            if (explorerType.getBigIconStyle() == null) {
                IconCssRuleBuilder css;
                if (explorerType.getBigIcon() != null) {
                    css = new IconCssRuleBuilder();
                    css.setImageUri(this.getIconUri(explorerType.getBigIcon()));
                    css.addSelectorForType(typeName, false);
                    css.writeCss(this.m_buffer);
                    IconCssRuleBuilder cssSmall = new IconCssRuleBuilder();
                    cssSmall.setImageUri(this.getIconUri(explorerType.getIcon()));
                    cssSmall.addSelectorForType(typeName, true);
                    cssSmall.writeCss(this.m_buffer);
                } else if (explorerType.getOriginalIcon() != null) {
                    css = new IconCssRuleBuilder();
                    css.setImageUri(this.getIconUri(explorerType.getIcon()));
                    css.addSelectorForType(typeName, true);
                    css.addSelectorForType(typeName, false);
                    css.writeCss(this.m_buffer);
                }
            }
            Map<String, CmsIconRule> iconRules = explorerType.getIconRules();
            for (Map.Entry<String, CmsIconRule> entry : iconRules.entrySet()) {
                CmsIconRule rule = entry.getValue();
                this.addCssForIconRule(typeName, rule);
            }
        }

        private String getIconUri(String icon) {
            return CmsWorkplace.getResourceUri("filetypes/" + icon);
        }
    }

    static class IconCssRuleBuilder {
        private String m_imageUri = "INVALID_ICON";
        private List<String> m_selectors = new ArrayList<String>();

        IconCssRuleBuilder() {
        }

        public void addSelectorForSubType(String type, String suffix, boolean small) {
            String template = " .%1$s.%2$s.%3$s";
            String selector = String.format(template, "cms_type_icon", CmsIconUtil.getResourceTypeIconClass(type, small), CmsIconUtil.getResourceSubTypeIconClass(type, suffix, small));
            this.m_selectors.add(selector);
        }

        public void addSelectorForType(String type, boolean small) {
            String template = " div.%1$s.%2$s, span.%1$s.%2$s";
            String selector = String.format(template, "cms_type_icon", CmsIconUtil.getResourceTypeIconClass(type, small));
            this.m_selectors.add(selector);
        }

        public void setImageUri(String imageUri) {
            this.m_imageUri = imageUri;
        }

        public void writeCss(StringBuffer buffer) {
            buffer.append(CmsStringUtil.listAsString(this.m_selectors, ", "));
            buffer.append(" { background-image: url(\"");
            buffer.append(this.m_imageUri);
            buffer.append("\");} ");
        }
    }
}

