/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.gwt;

import com.google.common.base.Optional;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.opencms.ade.configuration.CmsADEConfigData;
import org.opencms.ade.containerpage.CmsContainerpageService;
import org.opencms.ade.containerpage.CmsDetailOnlyContainerUtil;
import org.opencms.ade.containerpage.CmsRelationTargetListBean;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProperty;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.CmsUser;
import org.opencms.file.CmsVfsResourceNotFoundException;
import org.opencms.file.types.CmsResourceTypeJsp;
import org.opencms.file.types.CmsResourceTypeXmlContainerPage;
import org.opencms.file.types.CmsResourceTypeXmlContent;
import org.opencms.file.types.I_CmsResourceType;
import org.opencms.gwt.CmsResourceStatusConstants;
import org.opencms.gwt.CmsVfsService;
import org.opencms.gwt.Messages;
import org.opencms.gwt.shared.CmsListInfoBean;
import org.opencms.gwt.shared.CmsPermissionInfo;
import org.opencms.gwt.shared.CmsResourceStatusBean;
import org.opencms.gwt.shared.CmsResourceStatusRelationBean;
import org.opencms.gwt.shared.CmsResourceStatusTabId;
import org.opencms.i18n.CmsLocaleManager;
import org.opencms.i18n.CmsMessageContainer;
import org.opencms.lock.CmsLock;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.relations.CmsRelation;
import org.opencms.relations.CmsRelationFilter;
import org.opencms.relations.CmsRelationType;
import org.opencms.relations.I_CmsLinkParseable;
import org.opencms.search.galleries.CmsGallerySearch;
import org.opencms.search.galleries.CmsGallerySearchResult;
import org.opencms.security.CmsRole;
import org.opencms.site.CmsSite;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;
import org.opencms.workplace.CmsWorkplace;
import org.opencms.workplace.explorer.CmsResourceUtil;
import org.opencms.xml.containerpage.CmsContainerElementBean;
import org.opencms.xml.containerpage.I_CmsFormatterBean;
import org.opencms.xml.content.CmsXmlContent;
import org.opencms.xml.content.CmsXmlContentFactory;

public class CmsDefaultResourceStatusProvider {
    private static final String DETAIL_CONTAINER_PATTERN = ".*\\/\\.detailContainers\\/.*";
    private static final Log LOG = CmsLog.getLog(CmsDefaultResourceStatusProvider.class);
    public static final long MAX_RELATIONS = 500L;

    public static CmsRelationTargetListBean getContainerpageRelationTargets(CmsObject cms, CmsUUID source, List<CmsUUID> additionalIds, boolean cancelIfChanged) throws CmsException {
        CmsRelationTargetListBean result = new CmsRelationTargetListBean();
        CmsResource content = cms.readResource(source, CmsResourceFilter.ALL);
        boolean isContainerPage = CmsResourceTypeXmlContainerPage.isContainerPage(content);
        if (additionalIds != null) {
            for (CmsUUID structureId : additionalIds) {
                try {
                    CmsResource res = cms.readResource(structureId, CmsResourceFilter.ALL);
                    result.add(res);
                    if (!res.getState().isChanged() || !cancelIfChanged) continue;
                    return result;
                }
                catch (CmsException e) {
                    LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                }
            }
        }
        List<CmsRelation> relations = cms.readRelations(CmsRelationFilter.relationsFromStructureId(source));
        for (CmsRelation relation : relations) {
            if (relation.getType() == CmsRelationType.XSD) continue;
            try {
                CmsResource target = relation.getTarget(cms, CmsResourceFilter.ALL);
                I_CmsResourceType type = OpenCms.getResourceManager().getResourceType(target);
                if (isContainerPage && type instanceof CmsResourceTypeJsp) continue;
                result.add(target);
                if (!target.getState().isChanged() || !cancelIfChanged) continue;
                return result;
            }
            catch (CmsException e) {
                LOG.debug((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        return result;
    }

    public static CmsRelationTargetListBean getContainerpageRelationTargetsLimited(CmsObject cms, CmsUUID source, List<CmsUUID> additionalIds, boolean cancelIfChanged) throws CmsException, TooManyRelationsException {
        List<CmsRelation> relations;
        CmsRelationTargetListBean result = new CmsRelationTargetListBean();
        CmsResource content = cms.readResource(source, CmsResourceFilter.ALL);
        boolean isContainerPage = CmsResourceTypeXmlContainerPage.isContainerPage(content);
        if (additionalIds != null) {
            for (CmsUUID structureId : additionalIds) {
                try {
                    CmsResource res = cms.readResource(structureId, CmsResourceFilter.ALL);
                    result.add(res);
                    if (!res.getState().isChanged() || !cancelIfChanged) continue;
                    return result;
                }
                catch (CmsException e) {
                    LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                }
            }
        }
        if ((long)(relations = cms.readRelations(CmsRelationFilter.relationsFromStructureId(source))).size() > 500L) {
            throw new TooManyRelationsException();
        }
        for (CmsRelation relation : relations) {
            if (relation.getType() == CmsRelationType.XSD) continue;
            try {
                CmsResource target = relation.getTarget(cms, CmsResourceFilter.ALL);
                I_CmsResourceType type = OpenCms.getResourceManager().getResourceType(target);
                if (isContainerPage && type instanceof CmsResourceTypeJsp) continue;
                result.add(target);
                if (!target.getState().isChanged() || !cancelIfChanged) continue;
                return result;
            }
            catch (CmsException e) {
                LOG.debug((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        return result;
    }

    public static Map<String, String> getFormatterInfo(CmsObject cms, I_CmsFormatterBean bean) {
        Locale locale = OpenCms.getWorkplaceManager().getWorkplaceLocale(cms);
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        if (bean != null) {
            String label = org.opencms.ade.containerpage.Messages.get().getBundle(locale).key("GUI_ADDINFO_FORMATTER_0");
            result.put(label, bean.getJspRootPath());
            String locationLabel = org.opencms.ade.containerpage.Messages.get().getBundle(locale).key("GUI_ADDINFO_FORMATTER_LOCATION_0");
            String location = bean.getLocation();
            if (location != null) {
                result.put(locationLabel, location);
            }
            String key = bean.getKeyOrId();
            String keyLabel = org.opencms.ade.containerpage.Messages.get().getBundle(locale).key("GUI_ADDINFO_FORMATTER_KEY_0");
            if (key != null) {
                result.put(keyLabel, key);
            }
        }
        return result;
    }

    public CmsResourceStatusBean getResourceStatus(HttpServletRequest request, CmsObject cms, CmsUUID structureId, String contentLocale, boolean includeTargets, CmsUUID detailContentId, List<CmsUUID> additionalStructureIds, Map<String, String> context) throws CmsException {
        Map<CmsResourceStatusTabId, CmsMessageContainer> tabs;
        String lastProject;
        CmsGallerySearchResult result;
        Locale locale = OpenCms.getWorkplaceManager().getWorkplaceLocale(cms);
        cms.getRequestContext().setLocale(locale);
        CmsResource resource = cms.readResource(structureId, CmsResourceFilter.ALL);
        String localizedTitle = null;
        Locale realLocale = null;
        if (!CmsStringUtil.isEmptyOrWhitespaceOnly(contentLocale) && !CmsStringUtil.isEmptyOrWhitespaceOnly((result = CmsGallerySearch.searchById(cms, structureId, realLocale = CmsLocaleManager.getLocale(contentLocale))).getTitle())) {
            localizedTitle = result.getTitle();
        }
        CmsResourceUtil resourceUtil = new CmsResourceUtil(cms, resource);
        List<CmsProperty> properties = cms.readPropertyObjects(resource, false);
        CmsResourceStatusBean result2 = new CmsResourceStatusBean();
        result2.setDateCreated(CmsVfsService.formatDateTime(cms, resource.getDateCreated()));
        long dateExpired = resource.getDateExpired();
        if (dateExpired != Long.MAX_VALUE) {
            result2.setDateExpired(CmsVfsService.formatDateTime(cms, dateExpired));
        }
        result2.setDateLastModified(CmsVfsService.formatDateTime(cms, resource.getDateLastModified()));
        long dateReleased = resource.getDateReleased();
        if (dateReleased != 0L) {
            result2.setDateReleased(CmsVfsService.formatDateTime(cms, dateReleased));
        }
        if ("".equals(lastProject = resourceUtil.getLockedInProjectName())) {
            lastProject = null;
        }
        result2.setLastProject(lastProject);
        result2.setListInfo(CmsVfsService.getPageInfo(cms, resource));
        Map<String, String> contextualAddInfos = this.createContextInfos(cms, request, resource, context);
        for (Map.Entry<String, String> entry : contextualAddInfos.entrySet()) {
            result2.getListInfo().addAdditionalInfo(entry.getKey(), entry.getValue());
        }
        CmsLock lock = cms.getLock(resource);
        CmsUser lockOwner = null;
        if (!lock.isUnlocked()) {
            lockOwner = cms.readUser(lock.getUserId());
            result2.setLockState(org.opencms.workplace.list.Messages.get().getBundle(locale).key("GUI_EXPLORER_LIST_ACTION_LOCK_NAME_2", lockOwner.getName(), lastProject));
        } else {
            result2.setLockState(org.opencms.workplace.list.Messages.get().getBundle(locale).key("GUI_EXPLORER_LIST_ACTION_UNLOCK_NAME_0"));
        }
        CmsProperty navText = CmsProperty.get("NavText", properties);
        if (navText != null) {
            result2.setNavText(navText.getValue());
        }
        result2.setPermissions(resourceUtil.getPermissionString());
        if (resource.isFile()) {
            result2.setSize(resource.getLength());
            result2.setFormattedSize(result2.getSize() + " B");
        } else {
            long totalSize = OpenCms.getFolderSizeTracker(cms.getRequestContext().getCurrentProject().isOnlineProject()).getTotalFolderSize(resource.getRootPath());
            String formattedSize = this.formatFolderSize(totalSize, locale);
            result2.setSize(totalSize);
            result2.setFormattedSize(formattedSize);
        }
        result2.setStateBean(resource.getState());
        CmsProperty title = CmsProperty.get("Title", properties);
        if (localizedTitle != null) {
            result2.setTitle(localizedTitle);
            result2.getListInfo().setTitle(localizedTitle);
        } else if (title != null) {
            result2.setTitle(title.getValue());
        }
        result2.setUserCreated(resourceUtil.getUserCreated());
        result2.setUserLastModified(resourceUtil.getUserLastModified());
        I_CmsResourceType resType = OpenCms.getResourceManager().getResourceType(resource);
        result2.setResourceType(resType.getTypeName());
        result2.setStructureId(resource.getStructureId());
        if (resType instanceof CmsResourceTypeXmlContent) {
            CmsFile file = cms.readFile(resource);
            CmsXmlContent content = CmsXmlContentFactory.unmarshal(cms, file);
            List<Locale> locales = content.getLocales();
            ArrayList<String> localeStrings = new ArrayList<String>();
            for (Locale l : locales) {
                localeStrings.add(l.toString());
            }
            result2.setLocales(localeStrings);
        }
        LinkedHashMap<String, String> additionalAttributes = new LinkedHashMap<String, String>();
        additionalAttributes.put(Messages.get().getBundle(locale).key("GUI_STATUS_PERMALINK_0"), OpenCms.getLinkManager().getPermalink(cms, cms.getSitePath(resource), detailContentId));
        if (OpenCms.getRoleManager().hasRole(cms, CmsRole.ADMINISTRATOR)) {
            additionalAttributes.put(Messages.get().getBundle(locale).key("GUI_STATUS_STRUCTURE_ID_0"), resource.getStructureId().toString());
            additionalAttributes.put(Messages.get().getBundle(locale).key("GUI_STATUS_RESOURCE_ID_0"), resource.getResourceId().toString());
        }
        result2.setAdditionalAttributes(additionalAttributes);
        List<CmsRelation> relations = cms.readRelations(CmsRelationFilter.relationsToStructureId(resource.getStructureId()));
        HashMap<CmsUUID, CmsResource> relationSources = new HashMap<CmsUUID, CmsResource>();
        if (CmsResourceTypeXmlContainerPage.isContainerPage(resource)) {
            try {
                CmsResource parent = cms.readParentFolder(resource.getStructureId());
                List<CmsRelation> parentRelations = cms.readRelations(CmsRelationFilter.relationsToStructureId(parent.getStructureId()));
                relations.addAll(parentRelations);
            }
            catch (CmsException e) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        if ((long)relations.size() > 500L) {
            Iterator errorMessage = Messages.get().getBundle(OpenCms.getWorkplaceManager().getWorkplaceLocale(cms)).key("GUI_TOO_MANY_RELATIONS_1", "500");
            result2.setSourcesError((String)((Object)errorMessage));
        } else {
            for (CmsRelation relation : relations) {
                try {
                    CmsResource currentSource = relation.getSource(cms, CmsResourceFilter.ALL);
                    relationSources.put(currentSource.getStructureId(), currentSource);
                }
                catch (CmsException e) {
                    LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                }
            }
            for (CmsResource relationResource : relationSources.values()) {
                try {
                    CmsPermissionInfo permissionInfo = OpenCms.getADEManager().getPermissionInfo(cms, relationResource, resource.getRootPath());
                    if (!permissionInfo.hasViewPermission()) continue;
                    CmsResourceStatusRelationBean relationBean = this.createRelationBean(cms, contentLocale, relationResource, permissionInfo);
                    CmsSite site = OpenCms.getSiteManager().getSiteForRootPath(relationResource.getRootPath());
                    if (site != null && !CmsStringUtil.isPrefixPath(cms.getRequestContext().getSiteRoot(), relationResource.getRootPath())) {
                        String siteTitle = site.getTitle();
                        siteTitle = siteTitle == null ? site.getUrl() : CmsWorkplace.substituteSiteTitleStatic(siteTitle, OpenCms.getWorkplaceManager().getWorkplaceLocale(cms));
                        relationBean.setSiteRoot(site.getSiteRoot());
                        result2.getOtherSiteRelationSources().add(relationBean);
                        relationBean.getInfoBean().setTitle("[" + siteTitle + "] " + relationBean.getInfoBean().getTitle());
                        continue;
                    }
                    result2.getRelationSources().add(relationBean);
                }
                catch (CmsVfsResourceNotFoundException notfound) {
                    LOG.error((Object)notfound.getLocalizedMessage(), (Throwable)notfound);
                }
            }
            this.sortRelations(cms, result2);
        }
        if (includeTargets) {
            try {
                result2.getRelationTargets().addAll(this.getTargets(cms, contentLocale, resource, additionalStructureIds));
                if (detailContentId != null && realLocale != null) {
                    try {
                        CmsResource detailContent = cms.readResource(detailContentId, CmsResourceFilter.ALL);
                        Optional<CmsResource> detailOnlyPage = CmsDetailOnlyContainerUtil.getDetailOnlyResource(cms, realLocale.toString(), detailContent, resource);
                        if (detailOnlyPage.isPresent()) {
                            result2.getRelationTargets().addAll(this.getTargets(cms, contentLocale, (CmsResource)detailOnlyPage.get(), Arrays.asList(((CmsResource)detailOnlyPage.get()).getStructureId())));
                        }
                    }
                    catch (CmsException e) {
                        LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                    }
                }
                Iterator<CmsResourceStatusRelationBean> iter = result2.getRelationTargets().iterator();
                HashSet visitedIds = Sets.newHashSet();
                while (iter.hasNext()) {
                    CmsResourceStatusRelationBean bean = iter.next();
                    if (visitedIds.contains(bean.getStructureId())) {
                        iter.remove();
                    }
                    visitedIds.add(bean.getStructureId());
                }
            }
            catch (TooManyRelationsException e) {
                result2.setTargetsError(Messages.get().getBundle(OpenCms.getWorkplaceManager().getWorkplaceLocale(cms)).key("GUI_TOO_MANY_RELATIONS_1", "500"));
            }
        }
        result2.getSiblings().addAll(this.getSiblings(cms, contentLocale, resource));
        LinkedHashMap<CmsResourceStatusTabId, String> tabMap = new LinkedHashMap<CmsResourceStatusTabId, String>();
        CmsResourceStatusTabId startTab = CmsResourceStatusTabId.tabRelationsFrom;
        if (CmsResourceTypeXmlContainerPage.isContainerPage(resource)) {
            tabs = CmsResourceStatusConstants.STATUS_TABS_CONTAINER_PAGE;
        } else if (OpenCms.getResourceManager().getResourceType(resource) instanceof I_CmsLinkParseable) {
            tabs = CmsResourceStatusConstants.STATUS_TABS_CONTENT;
        } else {
            tabs = CmsResourceStatusConstants.STATUS_TABS_OTHER;
            startTab = CmsResourceStatusTabId.tabStatus;
        }
        for (Map.Entry<CmsResourceStatusTabId, CmsMessageContainer> entry : tabs.entrySet()) {
            tabMap.put(entry.getKey(), entry.getValue().key(locale));
        }
        result2.setTabs(tabMap);
        result2.setStartTab(startTab);
        return result2;
    }

    public void sortRelations(CmsObject cms, CmsResourceStatusBean resStatus) {
        final List<CmsSite> sites = OpenCms.getSiteManager().getAvailableSites(cms, false, false, cms.getRequestContext().getOuFqn());
        Collections.sort(resStatus.getOtherSiteRelationSources(), new Comparator<CmsResourceStatusRelationBean>(){
            private Map<String, Integer> m_rankCache = Maps.newHashMap();

            @Override
            public int compare(CmsResourceStatusRelationBean o1, CmsResourceStatusRelationBean o2) {
                return ComparisonChain.start().compare(this.rank(o1), this.rank(o2)).compare((Comparable)((Object)o1.getSitePath()), (Comparable)((Object)o2.getSitePath())).result();
            }

            public int rank(CmsResourceStatusRelationBean r) {
                if (this.m_rankCache.containsKey(r.getSiteRoot())) {
                    return this.m_rankCache.get(r.getSiteRoot());
                }
                int j = 0;
                int result = Integer.MAX_VALUE;
                for (CmsSite site : sites) {
                    if (site.getSiteRoot().equals(r.getSiteRoot())) {
                        result = j;
                        break;
                    }
                    ++j;
                }
                this.m_rankCache.put(r.getSiteRoot(), result);
                return result;
            }
        });
        Collections.sort(resStatus.getRelationSources(), new Comparator<CmsResourceStatusRelationBean>(){

            @Override
            public int compare(CmsResourceStatusRelationBean arg0, CmsResourceStatusRelationBean arg1) {
                if (arg0.getSitePath().matches(CmsDefaultResourceStatusProvider.DETAIL_CONTAINER_PATTERN)) {
                    if (!arg1.getSitePath().matches(CmsDefaultResourceStatusProvider.DETAIL_CONTAINER_PATTERN)) {
                        return 1;
                    }
                } else if (arg1.getSitePath().matches(CmsDefaultResourceStatusProvider.DETAIL_CONTAINER_PATTERN)) {
                    return -1;
                }
                return arg0.getSitePath().compareTo(arg1.getSitePath());
            }
        });
    }

    protected List<CmsResourceStatusRelationBean> getSiblings(CmsObject cms, String locale, CmsResource resource) throws CmsException {
        ArrayList<CmsResourceStatusRelationBean> result = new ArrayList<CmsResourceStatusRelationBean>();
        for (CmsResource sibling : cms.readSiblings(resource, CmsResourceFilter.ALL)) {
            if (sibling.getStructureId().equals(resource.getStructureId())) continue;
            try {
                CmsPermissionInfo permissionInfo = OpenCms.getADEManager().getPermissionInfo(cms, sibling, resource.getRootPath());
                if (!permissionInfo.hasViewPermission()) continue;
                CmsResourceStatusRelationBean relationBean = this.createRelationBean(cms, locale, sibling, permissionInfo);
                result.add(relationBean);
            }
            catch (CmsException e) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        return result;
    }

    protected List<CmsResourceStatusRelationBean> getTargets(CmsObject cms, String locale, CmsResource resource, List<CmsUUID> additionalStructureIds) throws CmsException, TooManyRelationsException {
        CmsRelationTargetListBean listBean = CmsDefaultResourceStatusProvider.getContainerpageRelationTargetsLimited(cms, resource.getStructureId(), additionalStructureIds, false);
        ArrayList<CmsResourceStatusRelationBean> result = new ArrayList<CmsResourceStatusRelationBean>();
        for (CmsResource target : listBean.getResources()) {
            try {
                CmsPermissionInfo permissionInfo = OpenCms.getADEManager().getPermissionInfo(cms, target, resource.getRootPath());
                if (!permissionInfo.hasViewPermission()) continue;
                CmsResourceStatusRelationBean relationBean = this.createRelationBean(cms, locale, target, permissionInfo);
                result.add(relationBean);
            }
            catch (CmsException e) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        return result;
    }

    CmsResourceStatusRelationBean createRelationBean(CmsObject cms, String locale, CmsResource relationResource, CmsPermissionInfo permissionInfo) throws CmsException {
        CmsListInfoBean sourceBean = CmsVfsService.getPageInfo(cms, relationResource);
        sourceBean.setMarkChangedState(true);
        sourceBean.setResourceState(relationResource.getState());
        if (!CmsStringUtil.isEmptyOrWhitespaceOnly(locale)) {
            Locale realLocale = CmsLocaleManager.getLocale(locale);
            CmsGallerySearchResult result = CmsGallerySearch.searchById(cms, relationResource.getStructureId(), realLocale);
            if (!CmsStringUtil.isEmptyOrWhitespaceOnly(result.getTitle())) {
                sourceBean.setTitle(result.getTitle());
            }
        }
        String link = null;
        try {
            link = OpenCms.getLinkManager().substituteLink(cms, relationResource);
        }
        catch (Exception e) {
            LOG.warn((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        CmsResourceStatusRelationBean relationBean = new CmsResourceStatusRelationBean(sourceBean, link, relationResource.getStructureId(), permissionInfo);
        if (CmsResourceTypeXmlContent.isXmlContent(relationResource)) {
            relationBean.setIsXmlContent(true);
        }
        String sitePath = cms.getSitePath(relationResource);
        relationBean.setSitePath(sitePath);
        return relationBean;
    }

    private Map<String, String> createContextInfos(CmsObject cms, HttpServletRequest request, CmsResource resource, Map<String, String> context) {
        CmsADEConfigData config = OpenCms.getADEManager().lookupConfiguration(cms, cms.getRequestContext().getRootUri());
        Locale locale = OpenCms.getWorkplaceManager().getWorkplaceLocale(cms);
        LinkedHashMap<String, String> additionalAttributes = new LinkedHashMap<String, String>();
        try {
            CmsContainerElementBean elementBean;
            CmsContainerpageService pageService;
            try {
                CmsRelationFilter filter = CmsRelationFilter.relationsFromStructureId(resource.getStructureId()).filterType(CmsRelationType.XSD);
                String schema = null;
                String label = org.opencms.ade.containerpage.Messages.get().getBundle(locale).key("GUI_ADDINFO_SCHEMA_0");
                Iterator<CmsRelation> iterator = cms.readRelations(filter).iterator();
                if (iterator.hasNext()) {
                    CmsRelation relation = iterator.next();
                    CmsResource target = relation.getTarget(cms, CmsResourceFilter.IGNORE_EXPIRATION);
                    schema = target.getRootPath();
                }
                if (schema != null) {
                    additionalAttributes.put(label, schema);
                }
            }
            catch (CmsException e) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
            String elementId = context.get("ATTR_ELEMENT_ID");
            String pageRootPath = context.get("ATTR_PAGE_ROOT_PATH");
            String containr = context.get("ATTR_CONTAINER_ID");
            if (elementId != null && containr != null) {
                pageService = new CmsContainerpageService();
                pageService.setCms(cms);
                pageService.setRequest(request);
                elementBean = pageService.getCachedElement(elementId, pageRootPath);
                for (Map.Entry entry : elementBean.getSettings().entrySet()) {
                    if (!((String)entry.getKey()).contains(containr)) continue;
                    String formatterId = (String)entry.getValue();
                    I_CmsFormatterBean formatter = config.findFormatter(formatterId);
                    for (Map.Entry<String, String> entry1 : CmsDefaultResourceStatusProvider.getFormatterInfo(cms, formatter).entrySet()) {
                        additionalAttributes.put(entry1.getKey(), entry1.getValue());
                    }
                }
            } else if (elementId != null && pageRootPath != null) {
                boolean bl;
                I_CmsFormatterBean formatter;
                pageService = new CmsContainerpageService();
                pageService.setCms(cms);
                pageService.setRequest(request);
                elementBean = pageService.getCachedElement(elementId, pageRootPath);
                String displayFormatterKey = elementBean.getSettings().get("SYSTEM::DISPLAY_FORMATTER");
                boolean bl2 = false;
                if (displayFormatterKey != null && (formatter = config.findFormatter(displayFormatterKey)) != null) {
                    bl = true;
                    Map<String, String> formatterInfo = CmsDefaultResourceStatusProvider.getFormatterInfo(cms, formatter);
                    for (Map.Entry<String, String> infoEntry : formatterInfo.entrySet()) {
                        additionalAttributes.put(infoEntry.getKey(), infoEntry.getValue());
                    }
                }
                if (!bl) {
                    CmsUUID formatterId = elementBean.getFormatterId();
                    try {
                        CmsResource formatterRes = cms.readResource(formatterId, CmsResourceFilter.IGNORE_EXPIRATION);
                        String path = formatterRes.getRootPath();
                        String label = org.opencms.ade.containerpage.Messages.get().getBundle(locale).key("GUI_ADDINFO_FORMATTER_0");
                        additionalAttributes.put(label, path);
                    }
                    catch (CmsVfsResourceNotFoundException formatterRes) {
                    }
                    catch (CmsException e) {
                        LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                    }
                }
            }
        }
        catch (Exception e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        return additionalAttributes;
    }

    private String formatFolderSize(long totalSize, Locale locale) {
        long kilo = 1024L;
        long mega = kilo * kilo;
        long giga = kilo * mega;
        NumberFormat format = NumberFormat.getInstance(locale);
        format.setMinimumFractionDigits(2);
        format.setMaximumFractionDigits(2);
        if (totalSize >= giga) {
            return format.format((double)totalSize / (double)giga) + " GB";
        }
        if (totalSize >= mega) {
            return format.format((double)totalSize / (double)mega) + " MB";
        }
        if (totalSize >= kilo) {
            return format.format((double)totalSize / (double)kilo) + " KB";
        }
        return totalSize + " B";
    }

    static class TooManyRelationsException
    extends Exception {
        private static final long serialVersionUID = 1L;
    }
}

