/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.gwt;

import com.vaadin.ui.Component;
import com.vaadin.ui.Window;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.Buffer;
import org.apache.commons.logging.Log;
import org.opencms.ade.configuration.CmsADEConfigData;
import org.opencms.ade.configuration.CmsGalleryDisabledTypesMode;
import org.opencms.db.CmsResourceState;
import org.opencms.db.CmsUserSettings;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProject;
import org.opencms.file.CmsProperty;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.CmsUser;
import org.opencms.file.CmsVfsResourceNotFoundException;
import org.opencms.flex.CmsFlexController;
import org.opencms.gwt.CmsClientUserSettingConverter;
import org.opencms.gwt.CmsGwtService;
import org.opencms.gwt.CmsIconUtil;
import org.opencms.gwt.CmsRpcException;
import org.opencms.gwt.CmsUsedCategoriesList;
import org.opencms.gwt.CmsVfsService;
import org.opencms.gwt.I_CmsFormValidator;
import org.opencms.gwt.I_CmsValidationService;
import org.opencms.gwt.Messages;
import org.opencms.gwt.shared.CmsBroadcastMessage;
import org.opencms.gwt.shared.CmsCategoryTreeEntry;
import org.opencms.gwt.shared.CmsContextMenuEntryBean;
import org.opencms.gwt.shared.CmsCoreData;
import org.opencms.gwt.shared.CmsLockInfo;
import org.opencms.gwt.shared.CmsResourceCategoryInfo;
import org.opencms.gwt.shared.CmsReturnLinkInfo;
import org.opencms.gwt.shared.CmsTinyMCEData;
import org.opencms.gwt.shared.CmsUploadRestrictionInfo;
import org.opencms.gwt.shared.CmsUserSettingsBean;
import org.opencms.gwt.shared.CmsValidationQuery;
import org.opencms.gwt.shared.CmsValidationResult;
import org.opencms.gwt.shared.rpc.I_CmsCoreService;
import org.opencms.i18n.CmsMessages;
import org.opencms.lock.CmsLock;
import org.opencms.main.CmsBroadcast;
import org.opencms.main.CmsException;
import org.opencms.main.CmsIllegalArgumentException;
import org.opencms.main.CmsLog;
import org.opencms.main.CmsSessionInfo;
import org.opencms.main.OpenCms;
import org.opencms.module.CmsModule;
import org.opencms.relations.CmsCategory;
import org.opencms.relations.CmsCategoryService;
import org.opencms.security.CmsPasswordInfo;
import org.opencms.security.CmsRole;
import org.opencms.security.CmsRoleManager;
import org.opencms.security.CmsSecurityException;
import org.opencms.site.CmsSite;
import org.opencms.ui.CmsUserIconHelper;
import org.opencms.ui.CmsVaadinUtils;
import org.opencms.ui.I_CmsDialogContext;
import org.opencms.ui.I_CmsDialogContextWithAdeContext;
import org.opencms.ui.actions.I_CmsADEAction;
import org.opencms.ui.components.CmsBasicDialog;
import org.opencms.ui.contextmenu.CmsContextMenuTreeBuilder;
import org.opencms.ui.contextmenu.CmsMenuItemVisibilityMode;
import org.opencms.ui.contextmenu.I_CmsContextMenuItem;
import org.opencms.ui.dialogs.CmsEmbeddedDialogsUI;
import org.opencms.util.CmsFileUtil;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsTreeNode;
import org.opencms.util.CmsUUID;
import org.opencms.workplace.CmsWorkplace;
import org.opencms.workplace.CmsWorkplaceSettings;
import org.opencms.xml.containerpage.CmsADESessionCache;

public class CmsCoreService
extends CmsGwtService
implements I_CmsCoreService {
    private static final String EDITOR_BACKLINK_URI = "/system/workplace/commons/editor-backlink.html";
    private static final String EDITOR_URI = "/system/workplace/editors/editor.jsp";
    private static final Log LOG = CmsLog.getLog(CmsCoreService.class);
    private static final long serialVersionUID = 5915848952948986278L;
    private CmsWorkplaceSettings m_workplaceSettings;

    public static List<CmsCategoryTreeEntry> buildCategoryTree(CmsObject cms, List<CmsCategory> categories) {
        ArrayList<CmsCategoryTreeEntry> result = new ArrayList<CmsCategoryTreeEntry>();
        CmsUser user = cms.getRequestContext().getCurrentUser();
        CmsUsedCategoriesList usedCategoriesBean = CmsUsedCategoriesList.fromJson((String)user.getAdditionalInfo("USED_CATEGORIES"));
        Set<String> usedCategories = usedCategoriesBean.getCategories();
        for (CmsCategory category : categories) {
            CmsCategoryTreeEntry current = new CmsCategoryTreeEntry(category);
            current.setUsed(usedCategories.contains(category.getPath()));
            current.setSitePath(cms.getRequestContext().removeSiteRoot(category.getRootPath()));
            String parentPath = CmsResource.getParentFolder(current.getPath());
            CmsCategoryTreeEntry parent = null;
            parent = CmsCoreService.findCategory(result, parentPath);
            if (parent != null) {
                parent.addChild(current);
                continue;
            }
            result.add(current);
        }
        return result;
    }

    public static List<CmsCategoryTreeEntry> getCategoriesForSitePathStatic(CmsObject cms, String sitePath) throws CmsException {
        return CmsCoreService.getCategoriesForSitePathStatic(cms, sitePath, null);
    }

    public static List<CmsCategoryTreeEntry> getCategoriesForSitePathStatic(CmsObject cms, String sitePath, String localCategoryRepositoryPath) throws CmsException {
        List<CmsCategoryTreeEntry> result;
        CmsCategoryService catService = CmsCategoryService.getInstance();
        Locale wpLocale = OpenCms.getWorkplaceManager().getWorkplaceLocale(cms);
        if (null == localCategoryRepositoryPath) {
            List<CmsCategory> categories = catService.readCategories(cms, "", true, sitePath);
            categories = catService.localizeCategories(cms, categories, wpLocale);
            result = CmsCoreService.buildCategoryTree(cms, categories);
        } else {
            List<String> repositories = catService.getCategoryRepositories(cms, sitePath);
            repositories.remove(localCategoryRepositoryPath);
            List<CmsCategory> categories = catService.readCategoriesForRepositories(cms, "", true, repositories);
            categories = catService.localizeCategories(cms, categories, wpLocale);
            result = CmsCoreService.buildCategoryTree(cms, categories);
            categories = catService.readCategoriesForRepositories(cms, "", true, Collections.singletonList(localCategoryRepositoryPath));
            categories = catService.localizeCategories(cms, categories, wpLocale);
            List<CmsCategoryTreeEntry> localCategories = CmsCoreService.buildCategoryTree(cms, categories);
            result.addAll(localCategories);
        }
        CmsCoreService.removeHiddenCategories(cms, result, entry -> false);
        return result;
    }

    public static List<CmsContextMenuEntryBean> getContextMenuEntries(final CmsObject cms, CmsUUID structureId, final CmsCoreData.AdeContext context, Map<String, String> params) {
        LinkedHashMap<String, CmsContextMenuEntryBean> entries = new LinkedHashMap<String, CmsContextMenuEntryBean>();
        try {
            List<Object> resources;
            CmsResource resource = cms.readResource(structureId, CmsResourceFilter.ALL.addRequireVisible());
            if (context.equals((Object)CmsCoreData.AdeContext.sitemapeditor)) {
                resources = Collections.emptyList();
                cms.getRequestContext().setAttribute("sitemap_config_resource", resource);
            } else {
                resources = Collections.singletonList(resource);
            }
            Locale locale = OpenCms.getWorkplaceManager().getWorkplaceLocale(cms);
            final HashMap paramsFinal = params != null ? params : new HashMap();
            I_CmsDialogContextWithAdeContext dcontext = new I_CmsDialogContextWithAdeContext(){

                @Override
                public void error(Throwable error) {
                }

                @Override
                public void finish(CmsProject project, String siteRoot) {
                }

                @Override
                public void finish(Collection<CmsUUID> result) {
                }

                @Override
                public void focus(CmsUUID id) {
                }

                @Override
                public CmsCoreData.AdeContext getAdeContext() {
                    return context;
                }

                @Override
                public List<CmsUUID> getAllStructureIdsInView() {
                    return null;
                }

                @Override
                public String getAppId() {
                    return context.name();
                }

                @Override
                public CmsObject getCms() {
                    return cms;
                }

                @Override
                public I_CmsDialogContext.ContextType getContextType() {
                    I_CmsDialogContext.ContextType type;
                    switch (context) {
                        case pageeditor: 
                        case editprovider: {
                            type = I_CmsDialogContext.ContextType.containerpageToolbar;
                            break;
                        }
                        case sitemapeditor: {
                            type = I_CmsDialogContext.ContextType.sitemapToolbar;
                            break;
                        }
                        default: {
                            type = I_CmsDialogContext.ContextType.fileTable;
                        }
                    }
                    return type;
                }

                @Override
                public Map<String, String> getParameters() {
                    return paramsFinal;
                }

                @Override
                public List<CmsResource> getResources() {
                    return resources;
                }

                @Override
                public void navigateTo(String appId) {
                }

                @Override
                public void onViewChange() {
                }

                @Override
                public void reload() {
                }

                @Override
                public void setWindow(Window window) {
                }

                @Override
                public void start(String title, Component dialog) {
                }

                @Override
                public void start(String title, Component dialog, CmsBasicDialog.DialogWidth width) {
                }

                @Override
                public void updateUserInfo() {
                }
            };
            CmsContextMenuTreeBuilder builder = new CmsContextMenuTreeBuilder(dcontext);
            ArrayList items = new ArrayList();
            CmsTreeNode<I_CmsContextMenuItem> root = builder.buildAll(OpenCms.getWorkplaceAppManager().getMenuItemProvider().getMenuItems());
            for (CmsTreeNode<I_CmsContextMenuItem> cmsTreeNode : root.getChildren()) {
                cmsTreeNode.addDataInPreOrder(items);
            }
            HashMap submenus = new HashMap();
            for (I_CmsContextMenuItem item : items) {
                List<CmsContextMenuEntryBean> submenu;
                CmsMenuItemVisibilityMode visibility;
                if (!item.isLeafItem()) {
                    visibility = item.getVisibility(dcontext);
                    entries.put(item.getId(), new CmsContextMenuEntryBean(visibility.isActive(), true, null, item.getTitle(locale), null, CmsStringUtil.isEmptyOrWhitespaceOnly(visibility.getMessageKey()) ? null : OpenCms.getWorkplaceManager().getMessages(locale).getString(visibility.getMessageKey()), false, new ArrayList<CmsContextMenuEntryBean>()));
                    continue;
                }
                if (!(item instanceof I_CmsADEAction) || !((I_CmsADEAction)((Object)item)).isAdeSupported()) continue;
                visibility = item.getVisibility(dcontext);
                String jspPath = ((I_CmsADEAction)((Object)item)).getJspPath();
                if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(jspPath)) {
                    jspPath = OpenCms.getLinkManager().substituteLink(cms, jspPath);
                }
                CmsContextMenuEntryBean itemBean = new CmsContextMenuEntryBean(visibility.isActive(), true, jspPath, item.getTitle(locale), ((I_CmsADEAction)((Object)item)).getCommandClassName(), CmsStringUtil.isEmptyOrWhitespaceOnly(visibility.getMessageKey()) ? null : OpenCms.getWorkplaceManager().getMessages(locale).getString(visibility.getMessageKey()), false, null);
                Map<String, String> clientParams = ((I_CmsADEAction)((Object)item)).getParams();
                if (clientParams != null) {
                    clientParams = new HashMap<String, String>(clientParams);
                    for (Map.Entry<String, String> param : clientParams.entrySet()) {
                        String value = CmsVfsService.prepareFileNameForEditor(cms, resource, param.getValue());
                        param.setValue(value);
                    }
                    itemBean.setParams(clientParams);
                }
                entries.put(item.getId(), itemBean);
                if (!CmsStringUtil.isNotEmptyOrWhitespaceOnly(item.getParentId())) continue;
                if (submenus.containsKey(item.getParentId())) {
                    submenu = (List)submenus.get(item.getParentId());
                } else {
                    submenu = new ArrayList();
                    submenus.put(item.getParentId(), submenu);
                }
                submenu.add(itemBean);
            }
            ArrayList<CmsContextMenuEntryBean> arrayList = new ArrayList<CmsContextMenuEntryBean>();
            for (I_CmsContextMenuItem item : items) {
                if (!entries.containsKey(item.getId())) continue;
                if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(item.getParentId())) {
                    CmsContextMenuEntryBean parent;
                    if (!entries.containsKey(item.getParentId()) || (parent = (CmsContextMenuEntryBean)entries.get(item.getParentId())).getSubMenu() == null) continue;
                    parent.getSubMenu().add((CmsContextMenuEntryBean)entries.get(item.getId()));
                    continue;
                }
                arrayList.add((CmsContextMenuEntryBean)entries.get(item.getId()));
            }
            return arrayList;
        }
        catch (CmsException e) {
            LOG.debug((Object)e.getLocalizedMessage(), (Throwable)e);
            return Collections.emptyList();
        }
    }

    public static String getFileExplorerLink(CmsObject cms, String siteRoot) {
        return CmsVaadinUtils.getWorkplaceLink("explorer", String.valueOf(cms.getRequestContext().getCurrentProject().getUuid()) + "!!" + siteRoot + "!!");
    }

    public static String getVaadinWorkplaceLink(CmsObject cms, CmsUUID structureId) {
        String resourceRootFolder = null;
        if (structureId != null) {
            try {
                resourceRootFolder = CmsResource.getFolderPath(cms.readResource(structureId, CmsResourceFilter.ONLY_VISIBLE_NO_DELETED).getRootPath());
            }
            catch (CmsException e) {
                LOG.debug((Object)"Error reading resource for workplace link.", (Throwable)e);
            }
        }
        if (resourceRootFolder == null) {
            resourceRootFolder = cms.getRequestContext().getSiteRoot();
        }
        return CmsCoreService.getVaadinWorkplaceLink(cms, resourceRootFolder);
    }

    public static String getVaadinWorkplaceLink(CmsObject cms, String resourceRootFolder) {
        CmsSite site = OpenCms.getSiteManager().getSiteForRootPath(resourceRootFolder);
        String siteRoot = site != null ? site.getSiteRoot() : (OpenCms.getSiteManager().startsWithShared(resourceRootFolder) ? OpenCms.getSiteManager().getSharedFolder() : "");
        String sitePath = resourceRootFolder.substring(siteRoot.length());
        String link = CmsCoreService.getFileExplorerLink(cms, siteRoot) + sitePath;
        return link;
    }

    public static I_CmsValidationService getValidationService(String name) throws CmsException {
        try {
            Class<?> cls = Class.forName(name, false, I_CmsValidationService.class.getClassLoader());
            if (!I_CmsValidationService.class.isAssignableFrom(cls)) {
                throw new CmsIllegalArgumentException(Messages.get().container("ERR_VALIDATOR_INCORRECT_TYPE_1", name));
            }
            return (I_CmsValidationService)cls.newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new CmsException(Messages.get().container("ERR_VALIDATOR_INSTANTIATION_FAILED_1", name), (Throwable)e);
        }
        catch (InstantiationException e) {
            throw new CmsException(Messages.get().container("ERR_VALIDATOR_INSTANTIATION_FAILED_1", name), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new CmsException(Messages.get().container("ERR_VALIDATOR_INSTANTIATION_FAILED_1", name), (Throwable)e);
        }
    }

    public static <T> T instantiate(Class<T> anInterface, String className) throws CmsException {
        try {
            Class<?> cls = Class.forName(className, false, anInterface.getClassLoader());
            if (!anInterface.isAssignableFrom(cls)) {
                throw new CmsIllegalArgumentException(Messages.get().container("ERR_INSTANTIATION_INCORRECT_TYPE_2", className, anInterface.getName()));
            }
            Class<?> typedClass = cls;
            return (T)typedClass.newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new CmsException(Messages.get().container("ERR_INSTANTIATION_FAILED_1", className), (Throwable)e);
        }
        catch (InstantiationException e) {
            throw new CmsException(Messages.get().container("ERR_INSTANTIATION_FAILED_1", className), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new CmsException(Messages.get().container("ERR_INSTANTIATION_FAILED_1", className), (Throwable)e);
        }
    }

    public static CmsReturnLinkInfo internalGetLinkForReturnCode(CmsObject cms, String returnCode) throws CmsException {
        if (CmsUUID.isValidUUID(returnCode)) {
            try {
                CmsResource pageRes = cms.readResource(new CmsUUID(returnCode), CmsResourceFilter.IGNORE_EXPIRATION);
                return new CmsReturnLinkInfo(OpenCms.getLinkManager().substituteLink(cms, pageRes), CmsReturnLinkInfo.Status.ok);
            }
            catch (CmsVfsResourceNotFoundException e) {
                LOG.debug((Object)e.getLocalizedMessage(), (Throwable)e);
                return new CmsReturnLinkInfo(null, CmsReturnLinkInfo.Status.notfound);
            }
        }
        int colonIndex = returnCode.indexOf(58);
        if (colonIndex >= 0) {
            String before = returnCode.substring(0, colonIndex);
            String after = returnCode.substring(colonIndex + 1);
            if (CmsUUID.isValidUUID(before) && CmsUUID.isValidUUID(after)) {
                try {
                    CmsUUID pageId = new CmsUUID(before);
                    CmsUUID detailId = new CmsUUID(after);
                    CmsResource pageRes = cms.readResource(pageId);
                    CmsResource folder = pageRes.isFolder() ? pageRes : cms.readParentFolder(pageRes.getStructureId());
                    String pageLink = OpenCms.getLinkManager().substituteLink(cms, folder);
                    CmsResource detailRes = cms.readResource(detailId);
                    String detailName = cms.getDetailName(detailRes, cms.getRequestContext().getLocale(), OpenCms.getLocaleManager().getDefaultLocales());
                    String link = CmsFileUtil.removeTrailingSeparator(pageLink) + "/" + detailName;
                    return new CmsReturnLinkInfo(link, CmsReturnLinkInfo.Status.ok);
                }
                catch (CmsVfsResourceNotFoundException e) {
                    LOG.debug((Object)e.getLocalizedMessage(), (Throwable)e);
                    return new CmsReturnLinkInfo(null, CmsReturnLinkInfo.Status.notfound);
                }
            }
        }
        throw new IllegalArgumentException("return code has wrong format");
    }

    public static CmsCoreData prefetch(HttpServletRequest request) {
        CmsCoreService srv = new CmsCoreService();
        srv.setCms(CmsFlexController.getCmsObject((ServletRequest)request));
        srv.setRequest(request);
        CmsCoreData result = null;
        try {
            result = srv.prefetch();
        }
        finally {
            srv.clearThreadStorage();
        }
        return result;
    }

    private static boolean checkForcedVisibility(CmsCategoryTreeEntry entry, Predicate<CmsCategoryTreeEntry> selectedCheck) {
        if (entry.getForcedVisible() == null) {
            boolean forcedVisible = selectedCheck.test(entry);
            for (CmsCategoryTreeEntry child : entry.getChildren()) {
                forcedVisible |= CmsCoreService.checkForcedVisibility(child, selectedCheck);
            }
            entry.setForcedVisible(forcedVisible);
        }
        return entry.getForcedVisible();
    }

    private static CmsCategoryTreeEntry findCategory(List<CmsCategoryTreeEntry> tree, String path) {
        if (path == null) {
            return null;
        }
        List<CmsCategoryTreeEntry> children = tree;
        boolean found = true;
        block0: while (found) {
            if (children == null) {
                return null;
            }
            found = false;
            for (int i = children.size() - 1; i >= 0; --i) {
                CmsCategoryTreeEntry child = children.get(i);
                if (path.equals(child.getPath())) {
                    return child;
                }
                if (!path.startsWith(child.getPath())) continue;
                children = child.getChildren();
                found = true;
                continue block0;
            }
        }
        return null;
    }

    private static void removeHiddenCategories(CmsObject cms, List<CmsCategoryTreeEntry> entries, Predicate<CmsCategoryTreeEntry> selectedCheck) {
        Iterator<CmsCategoryTreeEntry> iter = entries.iterator();
        while (iter.hasNext()) {
            CmsCategoryTreeEntry entry = iter.next();
            if (CmsCoreService.checkForcedVisibility(entry, selectedCheck)) {
                CmsCoreService.removeHiddenCategories(cms, entry.getChildren(), selectedCheck);
                continue;
            }
            boolean hidden = false;
            try {
                CmsResource resource = cms.readResource(entry.getId(), CmsResourceFilter.IGNORE_EXPIRATION);
                CmsProperty hiddenProp = cms.readPropertyObject(resource, "category.hidden", true);
                hidden = Boolean.parseBoolean(hiddenProp.getValue());
            }
            catch (CmsVfsResourceNotFoundException | CmsSecurityException e) {
                LOG.debug((Object)e.getLocalizedMessage(), (Throwable)e);
            }
            catch (Exception e) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
            if (hidden) {
                iter.remove();
                continue;
            }
            CmsCoreService.removeHiddenCategories(cms, entry.getChildren(), selectedCheck);
        }
    }

    @Override
    public String changePassword(String oldPassword, String newPassword, String newPasswordConfirm) throws CmsRpcException {
        CmsObject cms = this.getCmsObject();
        CmsPasswordInfo passwordBean = new CmsPasswordInfo(cms);
        Locale wpLocale = OpenCms.getWorkplaceManager().getWorkplaceLocale(cms);
        try {
            passwordBean.setCurrentPwd(oldPassword);
            passwordBean.setNewPwd(newPassword);
            passwordBean.setConfirmation(newPasswordConfirm);
            passwordBean.applyChanges();
            return null;
        }
        catch (CmsSecurityException e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            return e.getMessageContainer().key(wpLocale);
        }
        catch (CmsIllegalArgumentException e) {
            LOG.warn((Object)e.getLocalizedMessage(), (Throwable)e);
            return e.getMessageContainer().key(wpLocale);
        }
        catch (Exception e) {
            this.error(e);
            return null;
        }
    }

    @Override
    public CmsUUID createUUID() {
        return new CmsUUID();
    }

    @Override
    public List<CmsBroadcastMessage> getBroadcast() {
        this.setBroadcastPoll();
        CmsObject cms = this.getCmsObject();
        HashSet<CmsBroadcast> repeatedBroadcasts = new HashSet<CmsBroadcast>();
        OpenCms.getWorkplaceManager().checkWorkplaceRequest(this.getRequest(), this.getCmsObject());
        CmsSessionInfo sessionInfo = OpenCms.getSessionManager().getSessionInfo(this.getRequest().getSession());
        if (sessionInfo == null) {
            return null;
        }
        String sessionId = sessionInfo.getSessionId().toString();
        Buffer messageQueue = OpenCms.getSessionManager().getBroadcastQueue(sessionId);
        if (!messageQueue.isEmpty()) {
            CmsMessages messages = org.opencms.workplace.Messages.get().getBundle(OpenCms.getWorkplaceManager().getWorkplaceLocale(this.getCmsObject()));
            ArrayList<CmsBroadcastMessage> result = new ArrayList<CmsBroadcastMessage>();
            while (!messageQueue.isEmpty()) {
                CmsBroadcast broadcastMessage = (CmsBroadcast)messageQueue.remove();
                if (broadcastMessage.getLastDisplay() + CmsBroadcast.DISPLAY_AGAIN_TIME < System.currentTimeMillis()) {
                    CmsUserIconHelper helper = OpenCms.getWorkplaceAppManager().getUserIconHelper();
                    String picPath = "";
                    if (broadcastMessage.getUser() != null) {
                        picPath = helper.getSmallIconPath(this.getCmsObject(), broadcastMessage.getUser());
                    }
                    CmsBroadcastMessage message = new CmsBroadcastMessage(broadcastMessage.getUser() != null ? broadcastMessage.getUser().getName() : messages.key("GUI_LABEL_BROADCAST_FROM_SYSTEM_0"), picPath, messages.getDateTime(broadcastMessage.getSendTime()), broadcastMessage.getMessage());
                    result.add(message);
                    if (!broadcastMessage.isRepeat()) continue;
                    repeatedBroadcasts.add(broadcastMessage.withLastDisplay(System.currentTimeMillis()));
                    continue;
                }
                repeatedBroadcasts.add(broadcastMessage);
            }
            if (!repeatedBroadcasts.isEmpty()) {
                for (CmsBroadcast broadcast : repeatedBroadcasts) {
                    messageQueue.add((Object)broadcast);
                }
            }
            return result;
        }
        return null;
    }

    @Override
    public List<CmsCategoryTreeEntry> getCategories(String fromPath, boolean includeSubCats, String refPath, boolean showWithRepositories, Set<String> selected) throws CmsRpcException {
        CmsObject cms = this.getCmsObject();
        HashSet<CmsUUID> selectedIds = new HashSet<CmsUUID>();
        for (String path : selected) {
            try {
                CmsResource catResource = cms.readResource(path, CmsResourceFilter.IGNORE_EXPIRATION);
                selectedIds.add(catResource.getStructureId());
            }
            catch (CmsVfsResourceNotFoundException | CmsSecurityException e) {
                LOG.debug((Object)e.getLocalizedMessage(), (Throwable)e);
            }
            catch (Exception e) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        return this.getCategoriesInternal(fromPath, includeSubCats, refPath, showWithRepositories, entry -> selectedIds.contains(entry.getId()));
    }

    @Override
    public List<CmsCategoryTreeEntry> getCategoriesForSitePath(String sitePath) throws CmsRpcException {
        List<CmsCategoryTreeEntry> result = null;
        CmsObject cms = this.getCmsObject();
        try {
            result = CmsCoreService.getCategoriesForSitePathStatic(cms, sitePath);
        }
        catch (Throwable e) {
            this.error(e);
        }
        return result;
    }

    @Override
    public CmsResourceCategoryInfo getCategoryInfo(CmsUUID structureId) throws CmsRpcException {
        CmsObject cms = this.getCmsObject();
        CmsCategoryService catService = CmsCategoryService.getInstance();
        try {
            CmsResource resource = cms.readResource(structureId, CmsResourceFilter.ignoreExpirationOffline(cms));
            List<CmsCategory> categories = catService.readResourceCategories(cms, resource);
            ArrayList<String> currentCategories = new ArrayList<String>();
            HashSet<CmsUUID> selected = new HashSet<CmsUUID>();
            for (CmsCategory category : categories) {
                currentCategories.add(category.getPath());
                selected.add(category.getId());
            }
            return new CmsResourceCategoryInfo(structureId, CmsVfsService.getPageInfoWithLock(cms, resource), currentCategories, this.getCategoriesInternal(null, true, cms.getSitePath(resource), OpenCms.getWorkplaceManager().isDisplayCategoriesByRepository(), entry -> selected.contains(entry.getId())));
        }
        catch (CmsException e) {
            this.error(e);
            return null;
        }
    }

    @Override
    public List<CmsContextMenuEntryBean> getContextMenuEntries(CmsUUID structureId, CmsCoreData.AdeContext context) throws CmsRpcException {
        List<CmsContextMenuEntryBean> result = null;
        try {
            result = CmsCoreService.getContextMenuEntries(this.getCmsObject(), structureId, context, new HashMap<String, String>());
        }
        catch (Throwable e) {
            this.error(e);
        }
        return result;
    }

    @Override
    public List<CmsContextMenuEntryBean> getContextMenuEntries(CmsUUID structureId, CmsCoreData.AdeContext context, Map<String, String> params) throws CmsRpcException {
        List<CmsContextMenuEntryBean> result = null;
        try {
            result = CmsCoreService.getContextMenuEntries(this.getCmsObject(), structureId, context, params);
        }
        catch (Throwable e) {
            this.error(e);
        }
        return result;
    }

    @Override
    public CmsReturnLinkInfo getLinkForReturnCode(String returnCode) throws CmsRpcException {
        try {
            return CmsCoreService.internalGetLinkForReturnCode(this.getCmsObject(), returnCode);
        }
        catch (Throwable e) {
            this.error(e);
            return null;
        }
    }

    @Override
    public CmsResourceState getResourceState(CmsUUID structureId) throws CmsRpcException {
        CmsObject cms = this.getCmsObject();
        CmsResourceState result = null;
        try {
            try {
                CmsResource res = cms.readResource(structureId, CmsResourceFilter.ONLY_VISIBLE_NO_DELETED);
                result = res.getState();
            }
            catch (CmsVfsResourceNotFoundException e) {
                LOG.debug((Object)e.getLocalizedMessage(), (Throwable)e);
                result = CmsResourceState.STATE_DELETED;
            }
        }
        catch (CmsException e) {
            this.error(e);
        }
        return result;
    }

    @Override
    public String getUniqueFileName(String parentFolder, String baseName) {
        return OpenCms.getResourceManager().getNameGenerator().getUniqueFileName(this.getCmsObject(), parentFolder, baseName);
    }

    @Override
    public CmsCoreData.UserInfo getUserInfo() {
        CmsObject cms = this.getCmsObject();
        CmsRoleManager roleManager = OpenCms.getRoleManager();
        boolean isAdmin = roleManager.hasRole(cms, CmsRole.ADMINISTRATOR);
        boolean isDeveloper = roleManager.hasRole(cms, CmsRole.DEVELOPER);
        boolean isCategoryManager = roleManager.hasRole(cms, CmsRole.CATEGORY_EDITOR);
        boolean isWorkplaceUser = roleManager.hasRole(cms, CmsRole.WORKPLACE_USER);
        CmsCoreData.UserInfo userInfo = new CmsCoreData.UserInfo(cms.getRequestContext().getCurrentUser().getName(), OpenCms.getWorkplaceAppManager().getUserIconHelper().getSmallIconPath(cms, cms.getRequestContext().getCurrentUser()), isAdmin, isDeveloper, isCategoryManager, isWorkplaceUser, cms.getRequestContext().getCurrentUser().isManaged());
        return userInfo;
    }

    @Override
    public String getWorkplaceLink(CmsUUID structureId) throws CmsRpcException {
        String result = null;
        CmsObject cms = this.getCmsObject();
        try {
            String resourceRootFolder = structureId != null ? CmsResource.getFolderPath(cms.readResource(structureId, CmsResourceFilter.ALL.addRequireVisible()).getRootPath()) : cms.getRequestContext().getSiteRoot();
            result = CmsCoreService.getVaadinWorkplaceLink(cms, resourceRootFolder);
        }
        catch (Exception e) {
            this.error(e);
        }
        return result;
    }

    @Override
    public String getWorkplaceLinkForPath(String path) throws CmsRpcException {
        CmsObject cms = this.getCmsObject();
        try {
            CmsObject workCms = cms;
            if (path.startsWith("/sites/")) {
                workCms = OpenCms.initCmsObject(cms);
                workCms.getRequestContext().setSiteRoot("");
            }
            String currentPath = CmsResource.getParentFolder(path);
            CmsResource folder = null;
            try {
                folder = workCms.readResource(currentPath, CmsResourceFilter.IGNORE_EXPIRATION.addRequireVisible());
            }
            catch (CmsVfsResourceNotFoundException | CmsSecurityException e) {
                throw new CmsException(Messages.get().container("ERR_COULD_NOT_FIND_PARENT_FOLDER_1", path), (Throwable)e);
            }
            return CmsCoreService.getVaadinWorkplaceLink(cms, folder.getRootPath());
        }
        catch (Exception e) {
            this.error(e);
            return null;
        }
    }

    @Override
    public CmsUploadRestrictionInfo loadUploadRestrictionInfo() throws CmsRpcException {
        CmsObject cms = this.getCmsObject();
        CmsUploadRestrictionInfo result = OpenCms.getWorkplaceManager().getUploadRestriction().getUploadRestrictionInfo(cms);
        return result;
    }

    @Override
    public CmsUserSettingsBean loadUserSettings() throws CmsRpcException {
        CmsObject cms = this.getCmsObject();
        CmsClientUserSettingConverter converter = new CmsClientUserSettingConverter(cms, this.getRequest(), this.getResponse());
        try {
            return converter.loadSettings();
        }
        catch (Exception e) {
            this.error(e);
            return null;
        }
    }

    @Override
    public String lockIfExists(String sitePath) throws CmsRpcException {
        CmsObject cms = this.getCmsObject();
        Object errorMessage = null;
        try {
            if (cms.existsResource(sitePath, CmsResourceFilter.IGNORE_EXPIRATION)) {
                try {
                    this.ensureLock(cms.readResource(sitePath, CmsResourceFilter.IGNORE_EXPIRATION));
                }
                catch (CmsException e) {
                    errorMessage = e.getLocalizedMessage(OpenCms.getWorkplaceManager().getWorkplaceLocale(cms));
                }
            } else {
                String parentFolder = CmsResource.getParentFolder(sitePath);
                while (parentFolder != null && !cms.existsResource(parentFolder, CmsResourceFilter.IGNORE_EXPIRATION)) {
                    parentFolder = CmsResource.getParentFolder(parentFolder);
                }
                if (parentFolder != null) {
                    CmsResource ancestorFolder = cms.readResource(parentFolder, CmsResourceFilter.IGNORE_EXPIRATION);
                    CmsUser user = cms.getRequestContext().getCurrentUser();
                    CmsLock lock = cms.getLock(ancestorFolder);
                    if (!lock.isLockableBy(user)) {
                        errorMessage = "Can not lock parent folder '" + parentFolder + "'.";
                    }
                } else {
                    errorMessage = "Can not access any parent folder.";
                }
            }
        }
        catch (Throwable e) {
            this.error(e);
        }
        return errorMessage;
    }

    @Override
    public String lockIfExists(String sitePath, long loadTime) throws CmsRpcException {
        Object errorMessage;
        block12: {
            CmsObject cms = this.getCmsObject();
            errorMessage = null;
            try {
                if (cms.existsResource(sitePath, CmsResourceFilter.IGNORE_EXPIRATION)) {
                    try {
                        CmsResource resource = cms.readResource(sitePath, CmsResourceFilter.IGNORE_EXPIRATION);
                        if (resource.getDateLastModified() > loadTime) {
                            CmsUser user = null;
                            try {
                                user = cms.readUser(resource.getUserLastModified());
                            }
                            catch (CmsException cmsException) {
                                // empty catch block
                            }
                            CmsMessages messages = Messages.get().getBundle(OpenCms.getWorkplaceManager().getWorkplaceLocale(cms));
                            return user != null ? messages.key("ERR_LOCKING_MODIFIED_RESOURCE_2", resource.getRootPath(), user.getFullName()) : messages.key("ERR_LOCKING_MODIFIED_RESOURCE_1", resource.getRootPath());
                        }
                        this.ensureLock(resource);
                    }
                    catch (CmsException e) {
                        errorMessage = e.getLocalizedMessage(OpenCms.getWorkplaceManager().getWorkplaceLocale(cms));
                    }
                    break block12;
                }
                String parentFolder = CmsResource.getParentFolder(sitePath);
                while (parentFolder != null && !cms.existsResource(parentFolder, CmsResourceFilter.IGNORE_EXPIRATION)) {
                    parentFolder = CmsResource.getParentFolder(parentFolder);
                }
                if (parentFolder != null) {
                    CmsResource ancestorFolder = cms.readResource(parentFolder, CmsResourceFilter.IGNORE_EXPIRATION);
                    CmsUser user = cms.getRequestContext().getCurrentUser();
                    CmsLock lock = cms.getLock(ancestorFolder);
                    if (!lock.isLockableBy(user)) {
                        errorMessage = "Can not lock parent folder '" + parentFolder + "'.";
                    }
                } else {
                    errorMessage = "Can not access any parent folder.";
                }
            }
            catch (Throwable e) {
                this.error(e);
            }
        }
        return errorMessage;
    }

    @Override
    public String lockTemp(CmsUUID structureId) throws CmsRpcException {
        CmsObject cms = this.getCmsObject();
        try {
            try {
                this.ensureLock(structureId);
            }
            catch (CmsException e) {
                return e.getLocalizedMessage(OpenCms.getWorkplaceManager().getWorkplaceLocale(cms));
            }
        }
        catch (Throwable e) {
            this.error(e);
        }
        return null;
    }

    @Override
    public String lockTemp(CmsUUID structureId, long loadTime) throws CmsRpcException {
        CmsObject cms = this.getCmsObject();
        try {
            try {
                CmsResource resource = cms.readResource(structureId, CmsResourceFilter.IGNORE_EXPIRATION);
                if (resource.getDateLastModified() > loadTime) {
                    CmsUser user = null;
                    try {
                        user = cms.readUser(resource.getUserLastModified());
                    }
                    catch (CmsException cmsException) {
                        // empty catch block
                    }
                    CmsMessages messages = Messages.get().getBundle(OpenCms.getWorkplaceManager().getWorkplaceLocale(cms));
                    return user != null ? messages.key("ERR_LOCKING_MODIFIED_RESOURCE_2", resource.getRootPath(), user.getFullName()) : messages.key("ERR_LOCKING_MODIFIED_RESOURCE_1", resource.getRootPath());
                }
                this.ensureLock(resource);
            }
            catch (CmsException e) {
                return e.getLocalizedMessage(OpenCms.getWorkplaceManager().getWorkplaceLocale(cms));
            }
        }
        catch (Throwable e) {
            this.error(e);
        }
        return null;
    }

    @Override
    public CmsCoreData prefetch() {
        CmsObject cms = this.getCmsObject();
        String navigationUri = cms.getRequestContext().getUri();
        CmsADEConfigData sitemapConfig = OpenCms.getADEManager().lookupConfigurationWithCache(cms, cms.getRequestContext().getRootUri());
        boolean toolbarVisible = CmsADESessionCache.getCache(this.getRequest(), this.getCmsObject()).isToolbarVisible();
        boolean isShowHelp = OpenCms.getADEManager().isShowEditorHelp(cms);
        CmsUUID structureId = null;
        try {
            CmsResource requestedResource = cms.readResource(cms.getRequestContext().getUri(), CmsResourceFilter.ignoreExpirationOffline(cms));
            structureId = requestedResource.getStructureId();
        }
        catch (CmsException e) {
            LOG.debug((Object)"Could not read resource for URI.", (Throwable)e);
            structureId = CmsUUID.getNullUUID();
        }
        String loginUrl = "/system/login/index.html";
        try {
            loginUrl = cms.readPropertyObject(cms.getRequestContext().getUri(), "login-form", true).getValue(loginUrl);
        }
        catch (CmsException e) {
            this.log(e.getLocalizedMessage(), e);
        }
        String defaultWorkplaceLink = OpenCms.getSystemInfo().getWorkplaceContext();
        Locale wpLocale = OpenCms.getWorkplaceManager().getWorkplaceLocale(cms);
        CmsCoreData.UserInfo userInfo = this.getUserInfo();
        String aboutLink = OpenCms.getLinkManager().substituteLink(this.getCmsObject(), "/system/workplace/commons/about.jsp");
        String tinyMCE = CmsWorkplace.getStaticResourceUri("/editors/tinymce/jscripts/tinymce/tinymce.min.js");
        boolean uploadDisabled = OpenCms.getWorkplaceManager().isAdeGalleryUploadDisabled(cms);
        CmsUploadRestrictionInfo uploadRestrictionInfo = OpenCms.getWorkplaceManager().getUploadRestriction().getUploadRestrictionInfo(cms);
        String categoryBaseFolder = CmsCategoryService.getInstance().getRepositoryBaseFolderName(cms);
        CmsGalleryDisabledTypesMode disabledTypesMode = sitemapConfig.getDisabledTypeMode(CmsGalleryDisabledTypesMode.mark);
        boolean hideDisabledTypes = disabledTypesMode == CmsGalleryDisabledTypesMode.hide;
        this.getWorkplaceSettings().getUserSettings();
        String checkReuseWarning = CmsUserSettings.getAdditionalPreference(cms, "checkReuseWarning", true);
        boolean warnWhenEditingReusedElement = Boolean.parseBoolean(checkReuseWarning);
        CmsCoreData data = new CmsCoreData(EDITOR_URI, EDITOR_BACKLINK_URI, loginUrl, OpenCms.getStaticExportManager().getVfsPrefix(), CmsCoreService.getFileExplorerLink(cms, cms.getRequestContext().getSiteRoot()), OpenCms.getSystemInfo().getStaticResourceContext(), CmsEmbeddedDialogsUI.getEmbeddedDialogsContextPath(), cms.getRequestContext().getSiteRoot(), OpenCms.getSiteManager().getSharedFolder(), cms.getRequestContext().getCurrentProject().getId(), cms.getRequestContext().getLocale().toString(), wpLocale.toString(), cms.getRequestContext().getUri(), navigationUri, structureId, new HashMap<String, String>(OpenCms.getResourceManager().getExtensionMapping()), CmsIconUtil.getExtensionIconMapping(), System.currentTimeMillis(), isShowHelp, toolbarVisible, defaultWorkplaceLink, aboutLink, userInfo, OpenCms.getWorkplaceManager().getFileBytesMaxUploadSize(this.getCmsObject()), OpenCms.getWorkplaceManager().isKeepAlive(), uploadDisabled, OpenCms.getADEManager().getParameters(this.getCmsObject()), uploadRestrictionInfo, categoryBaseFolder, hideDisabledTypes, warnWhenEditingReusedElement);
        CmsTinyMCEData tinyMCEData = new CmsTinyMCEData();
        tinyMCEData.setLink(tinyMCE);
        data.setTinymce(tinyMCEData);
        data.setMaxLocaleButtons(OpenCms.getWorkplaceManager().getEditorMaxLocaleButtons());
        return data;
    }

    @Override
    public void saveUsedCategory(String category) throws CmsRpcException {
        try {
            CmsObject cms = this.getCmsObject();
            CmsUsedCategoriesList.addUsedCategoryForCurrentUser(cms, category);
        }
        catch (Exception e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            this.error(e);
        }
    }

    @Override
    public void saveUserSettings(Map<String, String> userSettings, Set<String> edited) throws CmsRpcException {
        try {
            CmsObject cms = this.getCmsObject();
            CmsClientUserSettingConverter converter = new CmsClientUserSettingConverter(cms, this.getRequest(), this.getResponse());
            userSettings.keySet().retainAll(edited);
            converter.saveSettings(userSettings);
        }
        catch (Exception e) {
            this.error(e);
        }
    }

    @Override
    public void setResourceCategories(CmsUUID structureId, List<String> categories) throws CmsRpcException {
        CmsObject cms = this.getCmsObject();
        CmsCategoryService catService = CmsCategoryService.getInstance();
        try {
            CmsResource resource = cms.readResource(structureId, CmsResourceFilter.IGNORE_EXPIRATION);
            this.ensureLock(resource);
            String sitePath = cms.getSitePath(resource);
            List<CmsCategory> previousCategories = catService.readResourceCategories(cms, resource);
            for (CmsCategory category : previousCategories) {
                if (categories.contains(category.getPath())) {
                    categories.remove(category.getPath());
                    continue;
                }
                catService.removeResourceFromCategory(cms, sitePath, category);
            }
            for (String path : categories) {
                if (path.isEmpty()) continue;
                catService.addResourceToCategory(cms, sitePath, path);
            }
            this.tryUnlock(resource);
        }
        catch (Throwable t) {
            this.error(t);
        }
    }

    @Override
    public void setShowEditorHelp(boolean visible) throws CmsRpcException {
        try {
            OpenCms.getADEManager().setShowEditorHelp(this.getCmsObject(), visible);
        }
        catch (Throwable e) {
            this.error(e);
        }
    }

    @Override
    public void setToolbarVisible(boolean visible) throws CmsRpcException {
        try {
            this.ensureSession();
            CmsADESessionCache.getCache(this.getRequest(), this.getCmsObject()).setToolbarVisible(visible);
        }
        catch (Throwable e) {
            this.error(e);
        }
    }

    @Override
    public String unlock(CmsUUID structureId) throws CmsRpcException {
        CmsObject cms = this.getCmsObject();
        try {
            CmsResource resource = cms.readResource(structureId, CmsResourceFilter.IGNORE_EXPIRATION);
            this.tryUnlock(resource);
        }
        catch (CmsException e) {
            return e.getLocalizedMessage(OpenCms.getWorkplaceManager().getWorkplaceLocale(cms));
        }
        catch (Throwable e) {
            this.error(e);
        }
        return null;
    }

    @Override
    public String unlock(String sitePath) throws CmsRpcException {
        try {
            CmsObject cms = OpenCms.initCmsObject(this.getCmsObject());
            cms.getRequestContext().setSiteRoot("");
            if (cms.existsResource(sitePath, CmsResourceFilter.IGNORE_EXPIRATION)) {
                CmsResource resource = cms.readResource(sitePath, CmsResourceFilter.IGNORE_EXPIRATION);
                this.tryUnlock(resource);
            }
        }
        catch (CmsException e) {
            return e.getLocalizedMessage(OpenCms.getWorkplaceManager().getWorkplaceLocale(this.getCmsObject()));
        }
        catch (Throwable e) {
            this.error(e);
        }
        return null;
    }

    @Override
    public Map<String, CmsValidationResult> validate(Map<String, CmsValidationQuery> validationQueries) throws CmsRpcException {
        try {
            HashMap<String, CmsValidationResult> result = new HashMap<String, CmsValidationResult>();
            for (Map.Entry<String, CmsValidationQuery> queryEntry : validationQueries.entrySet()) {
                String fieldName = queryEntry.getKey();
                CmsValidationQuery query = queryEntry.getValue();
                result.put(fieldName, this.validate(query.getValidatorId(), query.getValue(), query.getConfig()));
            }
            return result;
        }
        catch (Throwable e) {
            this.error(e);
            return null;
        }
    }

    @Override
    public Map<String, CmsValidationResult> validate(String formValidatorClass, Map<String, CmsValidationQuery> validationQueries, Map<String, String> values, String config) throws CmsRpcException {
        try {
            I_CmsFormValidator formValidator = CmsCoreService.instantiate(I_CmsFormValidator.class, formValidatorClass);
            return formValidator.validate(this.getCmsObject(), validationQueries, values, config);
        }
        catch (Throwable e) {
            this.error(e);
            return null;
        }
    }

    protected Map<String, String> getBuildIds() {
        List<CmsModule> modules = OpenCms.getModuleManager().getAllInstalledModules();
        HashMap<String, String> result = new HashMap<String, String>();
        for (CmsModule module : modules) {
            String buildid = module.getParameter("gwt.buildid");
            if (buildid == null) continue;
            result.put(module.getName(), buildid);
        }
        return result;
    }

    protected CmsLockInfo getLock(CmsUUID structureId) throws CmsException {
        CmsResource res = this.getCmsObject().readResource(structureId, CmsResourceFilter.IGNORE_EXPIRATION);
        return this.getLock(this.getCmsObject().getSitePath(res));
    }

    protected CmsLockInfo getLock(String sitepath) throws CmsException {
        CmsObject cms = this.getCmsObject();
        CmsUser user = cms.getRequestContext().getCurrentUser();
        CmsLock lock = cms.getLock(sitepath);
        if (lock.isOwnedBy(user)) {
            return CmsLockInfo.forSuccess();
        }
        if (lock.getUserId().isNullUUID()) {
            cms.lockResourceTemporary(sitepath);
            return CmsLockInfo.forSuccess();
        }
        CmsUser owner = cms.readUser(lock.getUserId());
        return CmsLockInfo.forLockedResource(owner.getName());
    }

    private List<CmsCategoryTreeEntry> getCategoriesInternal(String fromPath, boolean includeSubCats, String refPath, boolean showWithRepositories, Predicate<CmsCategoryTreeEntry> selectedCheck) throws CmsRpcException {
        CmsObject cms = this.getCmsObject();
        CmsCategoryService catService = CmsCategoryService.getInstance();
        ArrayList<String> repositories = new ArrayList<String>();
        repositories.addAll(catService.getCategoryRepositories(this.getCmsObject(), refPath));
        List<CmsCategoryTreeEntry> result = null;
        try {
            List<CmsCategory> categories = catService.readCategoriesForRepositories(cms, fromPath, includeSubCats, repositories, showWithRepositories);
            categories = catService.localizeCategories(cms, categories, OpenCms.getWorkplaceManager().getWorkplaceLocale(cms));
            result = CmsCoreService.buildCategoryTree(cms, categories);
            CmsCoreService.removeHiddenCategories(cms, result, selectedCheck);
        }
        catch (Throwable e) {
            this.error(e);
        }
        return result;
    }

    private CmsWorkplaceSettings getWorkplaceSettings() {
        if (this.m_workplaceSettings == null) {
            this.m_workplaceSettings = CmsWorkplace.getWorkplaceSettings(this.getCmsObject(), this.getRequest());
        }
        return this.m_workplaceSettings;
    }

    private CmsValidationResult validate(String validator, String value, String config) throws Exception {
        I_CmsValidationService validationService = CmsCoreService.getValidationService(validator);
        return validationService.validate(this.getCmsObject(), value, config);
    }
}

