/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.file.wrapper;

import java.util.ArrayList;
import java.util.List;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.wrapper.A_CmsResourceWrapper;
import org.opencms.file.wrapper.CmsWrappedResource;
import org.opencms.main.CmsException;
import org.opencms.util.CmsStringUtil;

public class CmsResourceWrapperSystemFolder
extends A_CmsResourceWrapper {
    @Override
    public List<CmsResource> addResourcesToFolder(CmsObject cms, String resourcename, CmsResourceFilter filter) throws CmsException {
        if (!((String)resourcename).endsWith("/")) {
            resourcename = (String)resourcename + "/";
        }
        if (((String)resourcename).equals("/") && !CmsStringUtil.isEmptyOrWhitespaceOnly(cms.getRequestContext().getSiteRoot())) {
            ArrayList<CmsResource> ret = new ArrayList<CmsResource>();
            ret.add(this.readResource(cms, "/system/", filter));
            return ret;
        }
        return null;
    }

    @Override
    public boolean isWrappedResource(CmsObject cms, CmsResource res) {
        if (res.isFolder() && !cms.getRequestContext().getSiteRoot().equals("/")) {
            Object resourcename = cms.getRequestContext().removeSiteRoot(res.getRootPath());
            if (!((String)resourcename).endsWith("/")) {
                resourcename = (String)resourcename + "/";
            }
            if (((String)resourcename).equals("/")) {
                return true;
            }
        }
        return false;
    }

    @Override
    public CmsResource readResource(CmsObject cms, String resourcename, CmsResourceFilter filter) throws CmsException {
        if (!cms.getRequestContext().getSiteRoot().equals("/")) {
            if (!((String)resourcename).endsWith("/")) {
                resourcename = (String)resourcename + "/";
            }
            if (((String)resourcename).equals("/system/")) {
                String siteRoot = cms.getRequestContext().getSiteRoot();
                cms.getRequestContext().setSiteRoot("/");
                CmsResource res = cms.readResource((String)resourcename, filter);
                cms.getRequestContext().setSiteRoot(siteRoot);
                CmsWrappedResource wrap = new CmsWrappedResource(res);
                wrap.setRootPath(cms.getRequestContext().getSiteRoot() + (String)resourcename);
                return wrap.getResource();
            }
        }
        return null;
    }
}

