/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.file.wrapper;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.logging.Log;
import org.opencms.db.generic.Messages;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProperty;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.CmsVfsResourceAlreadyExistsException;
import org.opencms.file.CmsVfsResourceNotFoundException;
import org.opencms.file.wrapper.A_CmsResourceWrapper;
import org.opencms.file.wrapper.CmsResourceWrapperUtils;
import org.opencms.file.wrapper.CmsWrappedResource;
import org.opencms.lock.CmsLock;
import org.opencms.main.CmsException;
import org.opencms.main.CmsIllegalArgumentException;
import org.opencms.main.CmsLog;
import org.opencms.util.CmsUUID;

public class CmsResourceWrapperPropertyFile
extends A_CmsResourceWrapper {
    private static final Log LOG = CmsLog.getLog(CmsResourceWrapperPropertyFile.class);
    private static final String FOLDER_PREFIX = "__";
    private static final String PROPERTY_DIR = "__properties";
    private static final int TIME_DELAY = 60;
    private static final List<String> TMP_FILE_TABLE = new ArrayList<String>();

    @Override
    public List<CmsResource> addResourcesToFolder(CmsObject cms, String resourcename, CmsResourceFilter filter) throws CmsException {
        Object path = resourcename;
        if (!((String)path).endsWith("/")) {
            path = (String)path + "/";
        }
        if (((String)path).endsWith("__properties/")) {
            String parent = CmsResource.getParentFolder((String)path);
            ArrayList<CmsResource> ret = new ArrayList<CmsResource>();
            List<CmsResource> resources = cms.getResourcesInFolder(parent, filter);
            for (CmsResource res : resources) {
                if (!this.existsResource(res)) continue;
                ret.add(CmsResourceWrapperUtils.createPropertyFile(cms, res, this.getPropertyFileName(res)));
            }
            return ret;
        }
        try {
            CmsResource folder = cms.readResource(resourcename);
            if (folder.isFolder() && !cms.getResourcesInFolder(resourcename, CmsResourceFilter.DEFAULT).isEmpty() && this.existsResource(folder)) {
                ArrayList<CmsResource> ret = new ArrayList<CmsResource>();
                CmsWrappedResource wrap = new CmsWrappedResource(folder);
                wrap.setRootPath(folder.getRootPath() + "__properties/");
                ret.add(wrap.getResource());
                return ret;
            }
        }
        catch (CmsVfsResourceNotFoundException ex) {
            return null;
        }
        return null;
    }

    @Override
    public CmsResource createResource(CmsObject cms, String resourcename, int type, byte[] content, List<CmsProperty> properties) throws CmsException, CmsIllegalArgumentException {
        CmsResource res = this.getResource(cms, resourcename, CmsResourceFilter.DEFAULT);
        if (res != null) {
            if (resourcename.endsWith("/")) {
                resourcename = resourcename.substring(0, resourcename.length() - 1);
            }
            if (this.existsResource(res)) {
                throw new CmsVfsResourceAlreadyExistsException(Messages.get().container("ERR_RESOURCE_WITH_NAME_ALREADY_EXISTS_1", resourcename));
            }
            TMP_FILE_TABLE.add(res.getRootPath());
            cms.lockResource(cms.getRequestContext().removeSiteRoot(res.getRootPath()));
            if (resourcename.endsWith(PROPERTY_DIR)) {
                CmsWrappedResource wrap = new CmsWrappedResource(res);
                wrap.setRootPath(res.getRootPath() + "__properties/");
                wrap.setFolder(true);
                return wrap.getResource();
            }
            if (resourcename.endsWith("properties")) {
                CmsResourceWrapperUtils.writePropertyFile(cms, cms.getRequestContext().removeSiteRoot(res.getRootPath()), content);
                return res;
            }
        }
        return null;
    }

    @Override
    public boolean deleteResource(CmsObject cms, String resourcename, CmsResource.CmsResourceDeleteMode siblingMode) throws CmsException {
        CmsResource res = this.getResource(cms, resourcename, CmsResourceFilter.DEFAULT);
        if (res != null) {
            TMP_FILE_TABLE.remove(res.getRootPath());
            return true;
        }
        return false;
    }

    @Override
    public CmsLock getLock(CmsObject cms, CmsResource resource) throws CmsException {
        CmsResource org = this.getResource(cms, resource.getStructureId());
        if (org != null) {
            return cms.getLock(org);
        }
        return null;
    }

    @Override
    public boolean isWrappedResource(CmsObject cms, CmsResource res) {
        String path = res.getRootPath();
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        return path.endsWith(PROPERTY_DIR);
    }

    @Override
    public boolean lockResource(CmsObject cms, String resourcename, boolean temporary) throws CmsException {
        CmsResource res = this.getResource(cms, resourcename, CmsResourceFilter.DEFAULT);
        if (res != null) {
            String path = cms.getRequestContext().removeSiteRoot(res.getRootPath());
            if (temporary) {
                cms.lockResourceTemporary(path);
            } else {
                cms.lockResource(path);
            }
            return true;
        }
        return false;
    }

    @Override
    public CmsFile readFile(CmsObject cms, String resourcename, CmsResourceFilter filter) throws CmsException {
        CmsResource res;
        if (!resourcename.endsWith(PROPERTY_DIR) && (res = this.getResource(cms, resourcename, filter)) != null) {
            if (!this.existsResource(res)) {
                return null;
            }
            return CmsResourceWrapperUtils.createPropertyFile(cms, res, this.getPropertyFileName(res));
        }
        return null;
    }

    @Override
    public CmsResource readResource(CmsObject cms, String resourcename, CmsResourceFilter filter) throws CmsException {
        CmsResource res = this.getResource(cms, resourcename, filter);
        if (res != null) {
            if (!this.existsResource(res)) {
                return null;
            }
            if (resourcename.endsWith("/")) {
                resourcename = resourcename.substring(0, resourcename.length() - 1);
            }
            if (!resourcename.endsWith(PROPERTY_DIR)) {
                return CmsResourceWrapperUtils.createPropertyFile(cms, res, this.getPropertyFileName(res));
            }
            CmsWrappedResource wrap = new CmsWrappedResource(res);
            wrap.setRootPath(res.getRootPath() + PROPERTY_DIR);
            wrap.setFolder(true);
            return wrap.getResource();
        }
        return null;
    }

    @Override
    public String restoreLink(CmsObject cms, String uri) {
        try {
            CmsResource res = this.getResource(cms, uri, CmsResourceFilter.DEFAULT);
            if (res != null) {
                return res.getRootPath();
            }
        }
        catch (CmsException cmsException) {
            // empty catch block
        }
        return null;
    }

    @Override
    public boolean unlockResource(CmsObject cms, String resourcename) throws CmsException {
        CmsResource res = this.getResource(cms, resourcename, CmsResourceFilter.DEFAULT);
        if (res != null) {
            cms.unlockResource(cms.getRequestContext().removeSiteRoot(res.getRootPath()));
            return true;
        }
        return false;
    }

    @Override
    public CmsFile writeFile(CmsObject cms, CmsFile resource) throws CmsException {
        CmsResource res = this.getResource(cms, resource.getStructureId());
        if (res != null) {
            CmsResourceWrapperUtils.writePropertyFile(cms, cms.getRequestContext().removeSiteRoot(res.getRootPath()), resource.getContents());
            return resource;
        }
        return null;
    }

    CmsResource getResource(CmsObject cms, CmsUUID structureId) {
        try {
            CmsResource result = cms.readResource(structureId);
            return result;
        }
        catch (CmsVfsResourceNotFoundException e) {
            return null;
        }
        catch (CmsException e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            return null;
        }
    }

    private boolean existsResource(CmsResource res) {
        long created;
        long now = new Date().getTime();
        long diff = (now - (created = res.getDateCreated())) / 1000L;
        if (diff <= 60L) {
            return TMP_FILE_TABLE.contains(res.getRootPath());
        }
        TMP_FILE_TABLE.remove(res.getRootPath());
        return true;
    }

    private String getPropertyFileName(CmsResource res) {
        StringBuffer ret = new StringBuffer();
        String parentFolder = CmsResource.getParentFolder(res.getRootPath());
        ret.append(parentFolder);
        if (!parentFolder.endsWith("/")) {
            ret.append("/");
        }
        ret.append(PROPERTY_DIR);
        ret.append("/");
        if (res.isFolder()) {
            ret.append(FOLDER_PREFIX);
        }
        ret.append(res.getName());
        return ret.toString();
    }

    private CmsResource getResource(CmsObject cms, String resourcename, CmsResourceFilter filter) throws CmsException {
        String path = CmsResource.getParentFolder(resourcename);
        if (path == null) {
            return null;
        }
        String parent = CmsResource.getParentFolder(path);
        String name = CmsResource.getName(resourcename);
        if (name.endsWith("/")) {
            name = name.substring(0, name.length() - 1);
        }
        if (name.equals(PROPERTY_DIR)) {
            return cms.readResource(path, filter);
        }
        if (path.endsWith("__properties/") && name.endsWith("properties")) {
            CmsResource res = null;
            if (name.startsWith(FOLDER_PREFIX)) {
                name = name.substring(2);
            }
            try {
                String resPath = CmsResourceWrapperUtils.removeFileExtension(cms, parent + name, "properties");
                res = cms.readResource(resPath, filter);
            }
            catch (CmsException cmsException) {
                // empty catch block
            }
            return res;
        }
        return null;
    }
}

