/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.file.wrapper;

import java.util.List;
import java.util.regex.Pattern;
import org.opencms.db.Messages;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProperty;
import org.opencms.file.CmsResource;
import org.opencms.file.wrapper.A_CmsResourceWrapper;
import org.opencms.file.wrapper.CmsSilentWrapperException;
import org.opencms.main.CmsException;
import org.opencms.main.CmsIllegalArgumentException;
import org.opencms.security.CmsPermissionViolationException;

public class CmsResourceWrapperPreventCreateNameRegex
extends A_CmsResourceWrapper {
    private Pattern m_pattern;

    @Override
    public void configure(String configString) {
        this.m_pattern = Pattern.compile(configString);
    }

    @Override
    public CmsResource createResource(CmsObject cms, String resourcepath, int type, byte[] content, List<CmsProperty> properties) throws CmsIllegalArgumentException {
        String name = CmsResource.getName(resourcepath);
        if (this.m_pattern.matcher(name).matches()) {
            throw new CmsSilentWrapperException(new CmsPermissionViolationException(Messages.get().container("ERR_PERM_DENIED_2", resourcepath, "+c")));
        }
        return null;
    }

    @Override
    public boolean isWrappedResource(CmsObject cms, CmsResource res) {
        return false;
    }

    @Override
    public boolean moveResource(CmsObject cms, String source, String destination) throws CmsException, CmsIllegalArgumentException {
        String name = CmsResource.getName(destination);
        if (this.m_pattern.matcher(name).matches()) {
            throw new CmsPermissionViolationException(Messages.get().container("ERR_PERM_DENIED_2", destination, "+c"));
        }
        return false;
    }
}

