/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.file.wrapper;

import java.util.List;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProperty;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.wrapper.A_CmsResourceWrapper;
import org.opencms.file.wrapper.CmsResourceWrapperUtils;
import org.opencms.file.wrapper.CmsWrappedResource;
import org.opencms.file.wrapper.Messages;
import org.opencms.lock.CmsLock;
import org.opencms.main.CmsException;
import org.opencms.main.CmsIllegalArgumentException;

public abstract class A_CmsResourceExtensionWrapper
extends A_CmsResourceWrapper {
    @Override
    public boolean copyResource(CmsObject cms, String source, String destination, CmsResource.CmsResourceCopyMode siblingMode) throws CmsException, CmsIllegalArgumentException {
        CmsResource res = this.getResource(cms, source);
        if (res != null) {
            cms.copyResource(CmsResourceWrapperUtils.removeFileExtension(cms, source, this.getExtension()), CmsResourceWrapperUtils.removeFileExtension(cms, destination, this.getExtension()), siblingMode);
            return true;
        }
        return false;
    }

    @Override
    public CmsResource createResource(CmsObject cms, String resourcename, int type, byte[] content, List<CmsProperty> properties) throws CmsException, CmsIllegalArgumentException {
        if (this.checkTypeId(type)) {
            return cms.createResource(CmsResourceWrapperUtils.removeFileExtension(cms, resourcename, this.getExtension()), type, content, properties);
        }
        return null;
    }

    @Override
    public boolean deleteResource(CmsObject cms, String resourcename, CmsResource.CmsResourceDeleteMode siblingMode) throws CmsException {
        CmsResource res = this.getResource(cms, resourcename);
        if (res != null) {
            cms.deleteResource(CmsResourceWrapperUtils.removeFileExtension(cms, resourcename, this.getExtension()), siblingMode);
            return true;
        }
        return false;
    }

    @Override
    public CmsLock getLock(CmsObject cms, CmsResource resource) throws CmsException {
        if (this.checkTypeId(resource.getTypeId())) {
            CmsWrappedResource wrap = new CmsWrappedResource(resource);
            wrap.setRootPath(CmsResourceWrapperUtils.removeFileExtension(cms, resource.getRootPath(), this.getExtension()));
            return cms.getLock(wrap.getResource());
        }
        return null;
    }

    @Override
    public boolean isWrappedResource(CmsObject cms, CmsResource res) {
        return this.checkTypeId(res.getTypeId());
    }

    @Override
    public boolean lockResource(CmsObject cms, String resourcename, boolean temporary) throws CmsException {
        CmsResource res = this.getResource(cms, resourcename);
        if (res != null) {
            String path = cms.getRequestContext().removeSiteRoot(res.getRootPath());
            if (temporary) {
                cms.lockResourceTemporary(path);
            } else {
                cms.lockResource(path);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean moveResource(CmsObject cms, String source, String destination) throws CmsException, CmsIllegalArgumentException {
        CmsResource res = this.getResource(cms, source);
        if (res != null) {
            if (!destination.endsWith("." + this.getExtension())) {
                throw new CmsIllegalArgumentException(Messages.get().container("ERR_BAD_RESOURCE_EXTENSION_1", destination));
            }
            cms.moveResource(CmsResourceWrapperUtils.removeFileExtension(cms, source, this.getExtension()), CmsResourceWrapperUtils.removeFileExtension(cms, destination, this.getExtension()));
            return true;
        }
        return false;
    }

    @Override
    public CmsFile readFile(CmsObject cms, String resourcename, CmsResourceFilter filter) throws CmsException {
        CmsResource res = this.getResource(cms, resourcename, filter);
        if (res != null) {
            CmsFile file = cms.readFile(res);
            CmsWrappedResource wrap = new CmsWrappedResource(file);
            wrap.setRootPath(CmsResourceWrapperUtils.addFileExtension(cms, res.getRootPath(), this.getExtension()));
            return wrap.getFile();
        }
        return null;
    }

    @Override
    public CmsResource readResource(CmsObject cms, String resourcename, CmsResourceFilter filter) {
        CmsResource res = this.getResource(cms, resourcename, filter);
        if (res != null) {
            CmsWrappedResource wrap = new CmsWrappedResource(res);
            wrap.setRootPath(CmsResourceWrapperUtils.addFileExtension(cms, res.getRootPath(), this.getExtension()));
            return wrap.getResource();
        }
        return null;
    }

    @Override
    public String restoreLink(CmsObject cms, String uri) {
        CmsResource res = this.getResource(cms, uri);
        if (res != null) {
            return res.getRootPath();
        }
        return null;
    }

    @Override
    public String rewriteLink(CmsObject cms, CmsResource res) {
        if (this.checkTypeId(res.getTypeId())) {
            return CmsResourceWrapperUtils.addFileExtension(cms, res.getRootPath(), this.getExtension());
        }
        return null;
    }

    @Override
    public boolean unlockResource(CmsObject cms, String resourcename) throws CmsException {
        CmsResource res = this.getResource(cms, resourcename);
        if (res != null) {
            cms.unlockResource(cms.getRequestContext().removeSiteRoot(res.getRootPath()));
            return true;
        }
        return false;
    }

    @Override
    public CmsResource wrapResource(CmsObject cms, CmsResource res) {
        if (this.checkTypeId(res.getTypeId())) {
            CmsWrappedResource wrap = new CmsWrappedResource(res);
            wrap.setRootPath(CmsResourceWrapperUtils.addFileExtension(cms, res.getRootPath(), this.getExtension()));
            return wrap.getResource();
        }
        return res;
    }

    @Override
    public CmsFile writeFile(CmsObject cms, CmsFile resource) throws CmsException {
        if (this.checkTypeId(resource.getTypeId())) {
            CmsWrappedResource wrap = new CmsWrappedResource(resource);
            wrap.setRootPath(CmsResourceWrapperUtils.removeFileExtension(cms, resource.getRootPath(), this.getExtension()));
            return cms.writeFile(wrap.getFile());
        }
        return null;
    }

    protected abstract boolean checkTypeId(int var1);

    protected abstract String getExtension();

    private CmsResource getResource(CmsObject cms, String resourcename) {
        return this.getResource(cms, resourcename, CmsResourceFilter.DEFAULT);
    }

    private CmsResource getResource(CmsObject cms, String resourcename, CmsResourceFilter filter) {
        CmsResource res = null;
        try {
            res = cms.readResource(CmsResourceWrapperUtils.removeFileExtension(cms, resourcename, this.getExtension()), filter);
        }
        catch (CmsException ex) {
            return null;
        }
        if (this.checkTypeId(res.getTypeId())) {
            return res;
        }
        return null;
    }
}

