/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.file.types;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import org.apache.commons.logging.Log;
import org.opencms.configuration.CmsConfigurationException;
import org.opencms.db.CmsSecurityManager;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProperty;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.types.A_CmsResourceTypeLinkParseable;
import org.opencms.file.types.Messages;
import org.opencms.i18n.CmsLocaleManager;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.relations.CmsLink;
import org.opencms.security.CmsPermissionSet;
import org.opencms.staticexport.CmsLinkTable;
import org.opencms.util.CmsHtmlConverter;
import org.opencms.xml.CmsXmlEntityResolver;
import org.opencms.xml.CmsXmlException;
import org.opencms.xml.page.CmsXmlPage;
import org.opencms.xml.page.CmsXmlPageFactory;

public class CmsResourceTypeXmlPage
extends A_CmsResourceTypeLinkParseable {
    private static final String DEFAULT_BODY = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n\n<pages xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:noNamespaceSchemaLocation=\"http://www.opencms.org/dtd/6.0/xmlpage.xsd\">\n</pages>";
    private static final Log LOG = CmsLog.getLog(CmsResourceTypeXmlPage.class);
    private static int m_staticTypeId;
    private static final int RESOURCE_TYPE_ID = 6;
    private static final String RESOURCE_TYPE_NAME = "xmlpage";
    private static final long serialVersionUID = 4218077530657122699L;

    public CmsResourceTypeXmlPage() {
        this.m_typeId = 6;
        this.m_typeName = RESOURCE_TYPE_NAME;
    }

    public static int getStaticTypeId() {
        return m_staticTypeId;
    }

    public static String getStaticTypeName() {
        return RESOURCE_TYPE_NAME;
    }

    public static boolean isXmlPage(CmsResource resource) {
        boolean result = false;
        if (resource != null) {
            result = resource.getTypeId() == m_staticTypeId;
        }
        return result;
    }

    @Override
    public CmsResource createResource(CmsObject cms, CmsSecurityManager securityManager, String resourcename, byte[] content, List<CmsProperty> properties) throws CmsException {
        if (content == null) {
            try {
                String encoding = CmsLocaleManager.getResourceEncoding(cms, cms.readResource(CmsResource.getParentFolder(resourcename)));
                content = DEFAULT_BODY.getBytes(encoding);
            }
            catch (Exception e) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        return super.createResource(cms, securityManager, resourcename, content, properties);
    }

    @Override
    public String getCachePropertyDefault() {
        return "element;locale;";
    }

    @Override
    public int getLoaderId() {
        return 9;
    }

    @Override
    public void initConfiguration(String name, String id, String className) throws CmsConfigurationException {
        super.initConfiguration(name, id, className);
        m_staticTypeId = this.m_typeId;
    }

    @Override
    public List<CmsLink> parseLinks(CmsObject cms, CmsFile file) {
        LinkedHashSet<CmsLink> links = new LinkedHashSet<CmsLink>();
        try {
            CmsXmlPage xmlPage = CmsXmlPageFactory.unmarshal(cms, file);
            List<Locale> locales = xmlPage.getLocales();
            for (Locale locale : locales) {
                List<String> elementNames = xmlPage.getNames(locale);
                for (String elementName : elementNames) {
                    CmsLinkTable linkTable = xmlPage.getLinkTable(elementName, locale);
                    Iterator<CmsLink> k = linkTable.iterator();
                    while (k.hasNext()) {
                        CmsLink link = k.next();
                        if (!link.isInternal()) continue;
                        link.checkConsistency(cms);
                        links.add(link);
                    }
                }
            }
        }
        catch (CmsXmlException e) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)Messages.get().getBundle().key("ERR_PROCESS_HTML_CONTENT_1", cms.getSitePath(file)), (Throwable)e);
            }
            return Collections.emptyList();
        }
        return new ArrayList<CmsLink>(links);
    }

    @Override
    public CmsFile writeFile(CmsObject cms, CmsSecurityManager securityManager, CmsFile resource) throws CmsException {
        securityManager.checkPermissions(cms.getRequestContext(), (CmsResource)resource, CmsPermissionSet.ACCESS_WRITE, true, CmsResourceFilter.ALL);
        if (resource.getLength() > 0) {
            CmsXmlPage xmlPage = CmsXmlPageFactory.unmarshal(cms, resource, false);
            xmlPage.validateXmlStructure(new CmsXmlEntityResolver(cms));
            String contentConversion = CmsHtmlConverter.getConversionSettings(cms, resource);
            xmlPage.setConversion(contentConversion);
            resource = xmlPage.correctXmlStructure(cms);
        }
        return super.writeFile(cms, securityManager, resource);
    }
}

