/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.file.types;

import org.opencms.db.CmsSecurityManager;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.types.CmsResourceTypeXmlAdeConfiguration;
import org.opencms.main.CmsException;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsWaitHandle;

public class CmsResourceTypeFunctionConfig
extends CmsResourceTypeXmlAdeConfiguration {
    public static final String FORMATTER_PATH = "/system/modules/org.opencms.base/formatters/function.jsp";
    public static final String TYPE_NAME = "function_config";
    private static final long serialVersionUID = -2378978201570511075L;

    public static String getStaticTypeName() {
        return TYPE_NAME;
    }

    public static boolean isFunction(CmsResource res) {
        return OpenCms.getResourceManager().matchResourceType(TYPE_NAME, res.getTypeId());
    }

    @Override
    public String getCachePropertyDefault() {
        return null;
    }

    @Override
    public CmsFile writeFile(CmsObject cms, CmsSecurityManager securityManager, CmsFile resource) throws CmsException {
        String savingStr = (String)cms.getRequestContext().getAttribute("__EDITOR_SAVING");
        CmsFile file = super.writeFile(cms, securityManager, resource);
        if (Boolean.valueOf(savingStr).booleanValue()) {
            CmsWaitHandle waitHandle = OpenCms.getADEManager().addFormatterCacheWaitHandle(false);
            waitHandle.enter(10000L);
        }
        return file;
    }
}

