/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.file.types;

import java.util.List;
import org.opencms.db.CmsSecurityManager;
import org.opencms.file.CmsDataNotImplementedException;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProperty;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.CmsVfsException;
import org.opencms.file.CmsVfsResourceNotFoundException;
import org.opencms.file.Messages;
import org.opencms.file.types.A_CmsResourceType;
import org.opencms.file.types.I_CmsResourceType;
import org.opencms.lock.CmsLockType;
import org.opencms.main.CmsException;
import org.opencms.main.CmsIllegalArgumentException;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsFileUtil;
import org.opencms.util.CmsStringUtil;

public abstract class A_CmsResourceTypeFolderBase
extends A_CmsResourceType {
    public static final String ATTR_SHALLOW_FOLDER_COPY = "shallow_folder_copy";
    private static final long serialVersionUID = -698470184142645873L;

    @Override
    public void chtype(CmsObject cms, CmsSecurityManager securityManager, CmsResource filename, int newType) throws CmsException, CmsDataNotImplementedException {
        if (!OpenCms.getResourceManager().getResourceType(newType).isFolder()) {
            throw new CmsDataNotImplementedException(org.opencms.file.types.Messages.get().container("ERR_CHTYPE_FOLDER_1", cms.getSitePath(filename)));
        }
        super.chtype(cms, securityManager, filename, newType);
    }

    @Override
    public void copyResource(CmsObject cms, CmsSecurityManager securityManager, CmsResource source, String destination, CmsResource.CmsResourceCopyMode siblingMode) throws CmsIllegalArgumentException, CmsException {
        destination = this.validateFoldername(destination);
        List<CmsResource> resources = securityManager.readChildResources(cms.getRequestContext(), source, CmsResourceFilter.IGNORE_EXPIRATION, true, true);
        super.copyResource(cms, securityManager, source, destination, siblingMode);
        Boolean shallow = (Boolean)cms.getRequestContext().getAttribute(ATTR_SHALLOW_FOLDER_COPY);
        if (shallow == null || !shallow.booleanValue()) {
            for (int i = 0; i < resources.size(); ++i) {
                CmsResource childResource = resources.get(i);
                String childDestination = destination.concat(childResource.getName());
                this.getResourceType(childResource).copyResource(cms, securityManager, childResource, childDestination, siblingMode);
            }
        }
    }

    @Override
    public CmsResource createResource(CmsObject cms, CmsSecurityManager securityManager, String resourcename, byte[] content, List<CmsProperty> properties) throws CmsException {
        resourcename = this.validateFoldername(resourcename);
        return super.createResource(cms, securityManager, resourcename, content, properties);
    }

    @Override
    public int getLoaderId() {
        return -1;
    }

    @Override
    public boolean isFolder() {
        return true;
    }

    @Override
    public void moveResource(CmsObject cms, CmsSecurityManager securityManager, CmsResource resource, String destination) throws CmsException, CmsIllegalArgumentException {
        String dest = cms.getRequestContext().addSiteRoot(destination);
        if (!CmsResource.isFolder(dest)) {
            dest = dest.concat("/");
        }
        if (resource.getRootPath().equals(dest)) {
            throw new CmsVfsException(Messages.get().container("ERR_MOVE_SAME_NAME_1", destination));
        }
        if (dest.startsWith(resource.getRootPath())) {
            throw new CmsVfsException(Messages.get().container("ERR_MOVE_SAME_FOLDER_2", cms.getSitePath(resource), destination));
        }
        try {
            String destinationWithoutTrailingSlash = dest;
            if (destinationWithoutTrailingSlash.length() > 1) {
                destinationWithoutTrailingSlash = CmsFileUtil.removeTrailingSeparator(dest);
            }
            securityManager.readResource(cms.getRequestContext(), destinationWithoutTrailingSlash, CmsResourceFilter.ALL);
            throw new CmsVfsException(Messages.get().container("ERR_OVERWRITE_RESOURCE_2", cms.getRequestContext().removeSiteRoot(resource.getRootPath()), destinationWithoutTrailingSlash));
        }
        catch (CmsVfsResourceNotFoundException destinationWithoutTrailingSlash) {
            dest = this.validateFoldername(dest);
            String targetName = CmsResource.getName(destination).replace("/", "");
            CmsResource.checkResourceName(targetName);
            securityManager.moveResource(cms.getRequestContext(), resource, dest);
            return;
        }
    }

    @Override
    public void replaceResource(CmsObject cms, CmsSecurityManager securityManager, CmsResource resource, int type, byte[] content, List<CmsProperty> properties) throws CmsException, CmsDataNotImplementedException {
        if (type != this.getTypeId()) {
            throw new CmsDataNotImplementedException(org.opencms.file.types.Messages.get().container("ERR_REPLACE_RESOURCE_FOLDER_1", cms.getSitePath(resource)));
        }
        super.replaceResource(cms, securityManager, resource, this.getTypeId(), null, properties);
    }

    @Override
    public void setDateExpired(CmsObject cms, CmsSecurityManager securityManager, CmsResource resource, long dateLastModified, boolean recursive) throws CmsException {
        super.setDateExpired(cms, securityManager, resource, dateLastModified, recursive);
        if (recursive) {
            List<CmsResource> resources = securityManager.readChildResources(cms.getRequestContext(), resource, CmsResourceFilter.IGNORE_EXPIRATION, true, true);
            for (int i = 0; i < resources.size(); ++i) {
                CmsResource childResource = resources.get(i);
                this.getResourceType(childResource).setDateExpired(cms, securityManager, childResource, dateLastModified, recursive);
            }
        }
    }

    @Override
    public void setDateLastModified(CmsObject cms, CmsSecurityManager securityManager, CmsResource resource, long dateLastModified, boolean recursive) throws CmsException {
        super.setDateLastModified(cms, securityManager, resource, dateLastModified, recursive);
        if (recursive) {
            List<CmsResource> resources = securityManager.readChildResources(cms.getRequestContext(), resource, CmsResourceFilter.IGNORE_EXPIRATION, true, true);
            for (int i = 0; i < resources.size(); ++i) {
                CmsResource childResource = resources.get(i);
                this.getResourceType(childResource).setDateLastModified(cms, securityManager, childResource, dateLastModified, recursive);
            }
        }
    }

    @Override
    public void setDateReleased(CmsObject cms, CmsSecurityManager securityManager, CmsResource resource, long dateLastModified, boolean recursive) throws CmsException {
        super.setDateReleased(cms, securityManager, resource, dateLastModified, recursive);
        if (recursive) {
            List<CmsResource> resources = securityManager.readChildResources(cms.getRequestContext(), resource, CmsResourceFilter.IGNORE_EXPIRATION, true, true);
            for (int i = 0; i < resources.size(); ++i) {
                CmsResource childResource = resources.get(i);
                this.getResourceType(childResource).setDateReleased(cms, securityManager, childResource, dateLastModified, recursive);
            }
        }
    }

    @Override
    public void undelete(CmsObject cms, CmsSecurityManager securityManager, CmsResource resource, boolean recursive) throws CmsException {
        super.undelete(cms, securityManager, resource, recursive);
        if (recursive) {
            List<CmsResource> resources = securityManager.readChildResources(cms.getRequestContext(), resource, CmsResourceFilter.ALL, true, true);
            for (int i = 0; i < resources.size(); ++i) {
                CmsResource childResource = resources.get(i);
                this.getResourceType(childResource).undelete(cms, securityManager, childResource, recursive);
            }
        }
    }

    @Override
    public void undoChanges(CmsObject cms, CmsSecurityManager securityManager, CmsResource resource, CmsResource.CmsResourceUndoMode mode) throws CmsException {
        boolean isMoved;
        String originalPath;
        boolean recursive = mode.isRecursive();
        if (mode == CmsResource.UNDO_MOVE_CONTENT && (originalPath = securityManager.resourceOriginalPath(cms.getRequestContext(), resource)).equals(resource.getRootPath())) {
            recursive = false;
        }
        List<CmsResource> resources = null;
        if (recursive) {
            resources = securityManager.readChildResources(cms.getRequestContext(), resource, CmsResourceFilter.ALL, true, true);
        }
        super.undoChanges(cms, securityManager, resource, mode);
        CmsResource undoneResource2 = securityManager.readResource(cms.getRequestContext(), resource.getStructureId(), CmsResourceFilter.ALL);
        boolean bl = isMoved = !undoneResource2.getRootPath().equals(resource.getRootPath());
        if (recursive && resources != null) {
            CmsResource childResource;
            int i;
            for (i = 0; i < resources.size(); ++i) {
                String newPath;
                childResource = resources.get(i);
                I_CmsResourceType type = this.getResourceType(childResource);
                if (isMoved) {
                    securityManager.lockResource(cms.getRequestContext(), childResource, CmsLockType.EXCLUSIVE);
                }
                if (!childResource.getState().isNew()) {
                    if (childResource.isFolder()) {
                        type.undoChanges(cms, securityManager, childResource, mode);
                        continue;
                    }
                    if (!childResource.getState().isNew()) {
                        securityManager.undoChanges(cms.getRequestContext(), childResource, mode);
                        continue;
                    }
                    if (!mode.isUndoMove()) continue;
                    newPath = cms.getRequestContext().removeSiteRoot(securityManager.readResource(cms.getRequestContext(), resource.getStructureId(), CmsResourceFilter.ALL).getRootPath() + childResource.getName());
                    type.moveResource(cms, securityManager, childResource, newPath);
                    continue;
                }
                if (!isMoved) continue;
                newPath = cms.getRequestContext().removeSiteRoot(securityManager.readResource(cms.getRequestContext(), resource.getStructureId(), CmsResourceFilter.ALL).getRootPath() + childResource.getName());
                type.moveResource(cms, securityManager, childResource, newPath);
            }
            for (i = 0; i < resources.size(); ++i) {
                childResource = resources.get(i);
                this.updateRelationForUndo(cms, securityManager, childResource);
            }
        }
    }

    private String validateFoldername(String resourcename) throws CmsIllegalArgumentException {
        if (CmsStringUtil.isEmpty(resourcename)) {
            throw new CmsIllegalArgumentException(org.opencms.db.Messages.get().container("ERR_BAD_RESOURCENAME_1", resourcename));
        }
        if (!CmsResource.isFolder(resourcename)) {
            resourcename = resourcename.concat("/");
        }
        if (resourcename.charAt(0) != '/') {
            resourcename = "/".concat(resourcename);
        }
        return resourcename;
    }
}

