/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.file.quota;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.opencms.db.CmsPublishedResource;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.quota.CmsFolderReportEntry;
import org.opencms.file.quota.CmsFolderSizeTable;
import org.opencms.main.CmsEvent;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsCollectionsGenericWrapper;
import org.opencms.util.CmsUUID;

public class CmsFolderSizeTracker {
    public static final long DEFAULT_TIMER_INTERVAL = 30000L;
    private static final Log LOG = CmsLog.getLog(CmsFolderSizeTracker.class);
    private CmsObject m_cms;
    private boolean m_initialized;
    private Object m_lock = new Object();
    private volatile CmsFolderSizeTable m_table;
    private LinkedBlockingQueue<String> m_todo = new LinkedBlockingQueue();
    private long m_interval;
    private LoadingCache<String, String> m_pathCache;
    private boolean m_online;

    public CmsFolderSizeTracker(CmsObject cms, boolean online) {
        try {
            this.m_cms = OpenCms.initCmsObject(cms);
        }
        catch (CmsException e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        this.m_table = new CmsFolderSizeTable(this.m_cms, online);
        this.m_online = online;
        CacheLoader loader = CacheLoader.from((Function)Functions.identity());
        this.m_pathCache = CacheBuilder.newBuilder().concurrencyLevel(4).expireAfterAccess(30L, TimeUnit.SECONDS).build(loader);
    }

    public Map<String, CmsFolderReportEntry> getFolderReport(Collection<String> folders) {
        if (!this.m_initialized) {
            return Collections.emptyMap();
        }
        return this.m_table.getFolderReport(folders);
    }

    public long getTimerInterval() {
        return this.m_interval;
    }

    public long getTotalFolderSize(String rootPath) {
        if (!this.m_initialized) {
            return -1L;
        }
        return this.m_table.getTotalFolderSize(rootPath);
    }

    public long getTotalFolderSizeExclusive(String rootPath, Collection<String> otherPaths) {
        if (!this.m_initialized) {
            return -1L;
        }
        return this.m_table.getTotalFolderSizeExclusive(rootPath, otherPaths);
    }

    public CmsFolderSizeTracker initialize() {
        if (!this.m_initialized) {
            Object prop = OpenCms.getRuntimeProperty("folderSizeTrackerInterval");
            this.m_interval = 30000L;
            if (prop != null) {
                try {
                    this.m_interval = Long.parseLong(String.valueOf(prop));
                }
                catch (Exception e) {
                    LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                }
            }
            if (this.m_interval > 0L) {
                this.reload();
                OpenCms.getEventManager().addCmsEventListener(this::handleEvent);
                OpenCms.getExecutor().scheduleWithFixedDelay(this::processUpdates, this.m_interval, this.m_interval, TimeUnit.MILLISECONDS);
                OpenCms.getExecutor().scheduleWithFixedDelay(this::reload, 24L, 24L, TimeUnit.HOURS);
                this.m_initialized = true;
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processUpdates() {
        long start = System.currentTimeMillis();
        try {
            Object object = this.m_lock;
            synchronized (object) {
                HashSet paths = new HashSet();
                this.m_todo.drainTo(paths);
                LOG.debug((Object)("Processing path update set of size " + paths.size()));
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)("Update set: " + String.valueOf(paths)));
                }
                if (paths.size() > 0) {
                    CmsFolderSizeTable newTable = new CmsFolderSizeTable(this.m_table);
                    for (String path : paths) {
                        newTable.updateSingle(path);
                    }
                    newTable.updateSubtreeCache();
                    this.m_table = newTable;
                }
            }
        }
        catch (Exception e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        long end = System.currentTimeMillis();
        long duration = end - start;
        if (LOG.isDebugEnabled() && duration > 250L) {
            LOG.debug((Object)("folder size tracker update took " + duration + "ms"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh(String rootPath) {
        Object object = this.m_lock;
        synchronized (object) {
            try {
                CmsFolderSizeTable newTable = new CmsFolderSizeTable(this.m_table);
                newTable.updateTree(rootPath);
                newTable.updateSubtreeCache();
                this.m_table = newTable;
            }
            catch (CmsException e) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reload() {
        Object object = this.m_lock;
        synchronized (object) {
            try {
                CmsFolderSizeTable newTable = new CmsFolderSizeTable(this.m_table);
                newTable.loadAll();
                newTable.updateSubtreeCache();
                this.m_table = newTable;
            }
            catch (CmsException e) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
    }

    private void addPath(String parentFolder) {
        try {
            this.m_todo.add((String)this.m_pathCache.get((Object)parentFolder));
        }
        catch (ExecutionException e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
    }

    private void addUpdate(CmsPublishedResource resource) {
        if (resource.isFile()) {
            this.addPath(CmsResource.getParentFolder(resource.getRootPath()));
        } else {
            this.addPath(resource.getRootPath());
        }
    }

    private void addUpdate(CmsResource resource) {
        if (resource.isFile()) {
            this.addPath(CmsResource.getParentFolder(resource.getRootPath()));
        } else {
            this.addPath(resource.getRootPath());
        }
    }

    private void handleEvent(CmsEvent event) {
        block22: {
            List<CmsResource> resources;
            CmsResource resource;
            block23: {
                resource = null;
                resources = null;
                if (!this.m_online) break block23;
                switch (event.getType()) {
                    case 2: {
                        String publishIdStr = (String)event.getData().get("publishHistoryId");
                        if (publishIdStr != null) {
                            CmsUUID publishId = new CmsUUID(publishIdStr);
                            try {
                                List<CmsPublishedResource> publishedResources = this.m_cms.readPublishedResources(publishId);
                                for (CmsPublishedResource res : publishedResources) {
                                    this.addUpdate(res);
                                }
                                break block22;
                            }
                            catch (CmsException e) {
                                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                                break;
                            }
                        } else {
                            break;
                        }
                    }
                }
                break block22;
            }
            ArrayList<Integer> irrelevantChangeTypes = new ArrayList<Integer>();
            irrelevantChangeTypes.add(0);
            irrelevantChangeTypes.add(32);
            switch (event.getType()) {
                case 11: 
                case 15: 
                case 23: {
                    Object change = event.getData().get("change");
                    if (change != null && irrelevantChangeTypes.contains(change)) {
                        return;
                    }
                    resource = (CmsResource)event.getData().get("resource");
                    this.addUpdate(resource);
                    break;
                }
                case 27: {
                    resources = CmsCollectionsGenericWrapper.list(event.getData().get("resources"));
                    for (CmsResource res : resources) {
                        this.addUpdate(res);
                    }
                    break;
                }
                case 22: {
                    resources = CmsCollectionsGenericWrapper.list(event.getData().get("resources"));
                    this.addUpdate(resources.get(0));
                    this.addUpdate(resources.get(resources.size() - 2));
                    break;
                }
                case 25: {
                    resources = CmsCollectionsGenericWrapper.list(event.getData().get("resources"));
                    for (CmsResource res : resources) {
                        this.addUpdate(res);
                    }
                    break;
                }
                case 12: {
                    resources = CmsCollectionsGenericWrapper.list(event.getData().get("resources"));
                    for (CmsResource res : resources) {
                        this.addUpdate(res);
                    }
                    break;
                }
                case 2: {
                    String publishIdStr = (String)event.getData().get("publishHistoryId");
                    if (publishIdStr == null) break;
                    CmsUUID publishId = new CmsUUID(publishIdStr);
                    try {
                        List<CmsPublishedResource> publishedResources = this.m_cms.readPublishedResources(publishId);
                        for (CmsPublishedResource res : publishedResources) {
                            this.addUpdate(res);
                        }
                        break;
                    }
                    catch (CmsException e) {
                        LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                        break;
                    }
                }
            }
        }
    }
}

