/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.file.quota;

import com.google.common.collect.ArrayListMultimap;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.quota.CmsFolderReportEntry;
import org.opencms.file.quota.CmsFolderSizeEntry;
import org.opencms.file.quota.CmsFolderSizeOptions;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsFileUtil;

public class CmsFolderSizeTable {
    private static final Log LOG = CmsLog.getLog(CmsFolderSizeTable.class);
    private CmsObject m_cms;
    private TreeMap<String, Long> m_folders = new TreeMap();
    private Map<String, Long> m_subtreeCache;
    private boolean m_online;

    public CmsFolderSizeTable(CmsFolderSizeTable other) {
        try {
            this.m_cms = OpenCms.initCmsObject(other.m_cms);
        }
        catch (Exception e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            this.m_cms = other.m_cms;
        }
        this.m_online = other.m_online;
        this.m_folders = new TreeMap<String, Long>((SortedMap<String, Long>)other.m_folders);
    }

    public CmsFolderSizeTable(CmsObject cms, boolean online) {
        this.m_cms = cms;
        this.m_online = online;
    }

    public Map<String, CmsFolderReportEntry> getFolderReport(Collection<String> folders) {
        Map<String, Long> subtreeCache = this.getSubtreeCache();
        HashSet<String> folderSet = new HashSet<String>();
        for (String string : folders) {
            folderSet.add(this.normalize(string));
        }
        ArrayListMultimap directDescendants = ArrayListMultimap.create();
        for (String folder : folderSet) {
            String currentAncestor = CmsResource.getParentFolder(folder);
            String directAncestor = null;
            while (currentAncestor != null) {
                if (folderSet.contains(currentAncestor)) {
                    directAncestor = currentAncestor;
                    break;
                }
                currentAncestor = CmsResource.getParentFolder(currentAncestor);
            }
            if (directAncestor == null) continue;
            directDescendants.put((Object)directAncestor, (Object)folder);
        }
        HashMap<String, CmsFolderReportEntry> hashMap = new HashMap<String, CmsFolderReportEntry>();
        for (String folder : folderSet) {
            long size;
            long exclusiveSize = size = subtreeCache.getOrDefault(folder, 0L).longValue();
            for (String child : directDescendants.get((Object)folder)) {
                exclusiveSize -= subtreeCache.getOrDefault(child, 0L).longValue();
            }
            hashMap.put(folder, new CmsFolderReportEntry(size, exclusiveSize));
        }
        return hashMap;
    }

    public long getTotalFolderSize(String rootPath) {
        Long size = this.getSubtreeCache().get(this.normalize(rootPath));
        if (size != null) {
            return size;
        }
        return 0L;
    }

    public long getTotalFolderSizeExclusive(String rootPath, Collection<String> otherPaths) {
        HashSet<String> paths = new HashSet<String>(otherPaths);
        rootPath = this.normalize(rootPath);
        paths.add(rootPath);
        return this.getFolderReport(paths).get(rootPath).getTreeSizeExclusive();
    }

    public void loadAll() throws CmsException {
        TreeMap<String, Long> folders = new TreeMap<String, Long>();
        List<CmsFolderSizeEntry> stats = this.m_cms.readFolderSizeStats(new CmsFolderSizeOptions("/", this.m_online, true));
        for (CmsFolderSizeEntry entry : stats) {
            folders.put(this.normalize(entry.getRootPath()), entry.getSize());
        }
        this.m_folders = folders;
        this.m_subtreeCache = null;
    }

    public void updateSingle(String rootPath) throws CmsException {
        List<CmsFolderSizeEntry> entries = this.m_cms.readFolderSizeStats(new CmsFolderSizeOptions(rootPath, this.m_online, false));
        this.m_folders.remove(this.normalize(rootPath));
        if (entries.size() > 0) {
            this.m_folders.put(this.normalize(entries.get(0).getRootPath()), entries.get(0).getSize());
        }
        this.m_subtreeCache = null;
    }

    public void updateSubtreeCache() {
        HashMap<String, Long> subtreeCache = new HashMap<String, Long>();
        for (Map.Entry<String, Long> entry : this.m_folders.entrySet()) {
            String currentPath = entry.getKey();
            while (currentPath != null) {
                subtreeCache.put(currentPath, subtreeCache.computeIfAbsent(currentPath, key -> 0L) + entry.getValue());
                currentPath = CmsResource.getParentFolder(currentPath);
            }
        }
        this.m_subtreeCache = subtreeCache;
    }

    public void updateTree(String rootPath) throws CmsException {
        List<CmsFolderSizeEntry> entries = this.m_cms.readFolderSizeStats(new CmsFolderSizeOptions(rootPath, this.m_online, true));
        rootPath = this.normalize(rootPath);
        this.m_folders.subMap(rootPath, rootPath + "\uffff").clear();
        for (CmsFolderSizeEntry entry : entries) {
            this.m_folders.put(this.normalize(entry.getRootPath()), entry.getSize());
        }
        this.m_subtreeCache = null;
    }

    private Map<String, Long> getSubtreeCache() {
        if (this.m_subtreeCache == null) {
            this.updateSubtreeCache();
        }
        return this.m_subtreeCache;
    }

    private String normalize(String path) {
        if ("".equals(path)) {
            return "/";
        }
        if ("/".equals(path)) {
            return path;
        }
        return CmsFileUtil.addTrailingSeparator(path);
    }
}

