/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.file.quota;

import java.util.ArrayList;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.opencms.file.CmsResource;
import org.opencms.util.CmsUUID;

public class CmsFolderSizeEntry {
    private String m_rootPath;
    private CmsUUID m_structureId;
    private long m_size;
    private int m_typeId;

    public CmsFolderSizeEntry(CmsUUID structureId, String rootPath, long size, int typeId) {
        this.m_structureId = structureId;
        this.m_rootPath = rootPath.endsWith("/") ? rootPath : rootPath + "/";
        this.m_size = size;
        this.m_typeId = typeId;
    }

    public static void main(String[] args) {
        for (int j = 0; j < 10; ++j) {
            ArrayList<CmsFolderSizeEntry> list = new ArrayList<CmsFolderSizeEntry>();
            for (int i = 0; i < 200000; ++i) {
                list.add(new CmsFolderSizeEntry(new CmsUUID(), "/blah/foo/xyz/quorb/wuz/norg" + i, 371 * i % 10000, 1));
            }
            long result = 0L;
            long start = System.currentTimeMillis();
            for (CmsFolderSizeEntry entry : list) {
                result += entry.getSize();
                String path = entry.getRootPath();
                while (path != null) {
                    path = CmsResource.getParentFolder(path);
                }
            }
            long end = System.currentTimeMillis();
            System.out.println(end - start);
        }
    }

    public String getRootPath() {
        return this.m_rootPath;
    }

    public long getSize() {
        return this.m_size;
    }

    public CmsUUID getStructureId() {
        return this.m_structureId;
    }

    public int getTypeId() {
        return this.m_typeId;
    }

    public String toString() {
        return ReflectionToStringBuilder.toString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }
}

