/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.file.collectors;

import java.util.List;
import org.apache.commons.logging.Log;
import org.opencms.file.collectors.Messages;
import org.opencms.file.types.I_CmsResourceType;
import org.opencms.loader.CmsLoaderException;
import org.opencms.main.CmsIllegalArgumentException;
import org.opencms.main.CmsLog;
import org.opencms.main.CmsRuntimeException;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsStringUtil;

public class CmsCollectorData {
    public static final String PARAM_EXCLUDETIMERANGE = "excludeTimerange";
    private static final Log LOG = CmsLog.getLog(CmsCollectorData.class);
    private int m_count;
    private boolean m_excludeTimerange;
    private String m_fileName;
    private int m_type;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public CmsCollectorData(String data) {
        if (data == null) {
            throw new CmsIllegalArgumentException(Messages.get().container("ERR_COLLECTOR_PARAM_EMPTY_0"));
        }
        if (!data.contains("|")) {
            throw new CmsIllegalArgumentException(Messages.get().container("ERR_COLLECTOR_PARAM_INVALID_1", data));
        }
        List<String> args = CmsStringUtil.splitAsList(data, '|', true);
        this.m_fileName = args.get(0);
        String type = args.get(1);
        this.m_count = 0;
        if (args.size() >= 3) {
            String value = args.get(2);
            if (PARAM_EXCLUDETIMERANGE.equalsIgnoreCase(value)) {
                this.m_excludeTimerange = true;
            } else {
                try {
                    this.m_count = Integer.parseInt(value);
                }
                catch (NumberFormatException e) {
                    throw new CmsIllegalArgumentException(Messages.get().container("ERR_COLLECTOR_PARAM_INVALID_1", data));
                }
            }
            if (args.size() == 4 && PARAM_EXCLUDETIMERANGE.equalsIgnoreCase(args.get(3))) {
                this.m_excludeTimerange = true;
            }
        }
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(type)) {
            try {
                I_CmsResourceType resourceType = OpenCms.getResourceManager().getResourceType(type);
                this.m_type = resourceType.getTypeId();
                return;
            }
            catch (CmsLoaderException e) {
                try {
                    int typeInt = Integer.valueOf(type);
                    I_CmsResourceType resourceType = OpenCms.getResourceManager().getResourceType(typeInt);
                    this.m_type = resourceType.getTypeId();
                    if (!LOG.isWarnEnabled()) return;
                    LOG.warn((Object)Messages.get().getBundle().key("LOG_RESTYPE_INTID_2", resourceType.getTypeName(), resourceType.getTypeId()));
                    return;
                }
                catch (NumberFormatException | CmsLoaderException e1) {
                    throw new CmsRuntimeException(Messages.get().container("ERR_UNKNOWN_RESTYPE_1", type), (Throwable)e1);
                }
            }
        } else {
            this.m_type = -1;
        }
    }

    protected CmsCollectorData() {
    }

    public int getCount() {
        return this.m_count;
    }

    public String getFileName() {
        return this.m_fileName;
    }

    public int getType() {
        return this.m_type;
    }

    public boolean isExcludeTimerange() {
        return this.m_excludeTimerange;
    }

    public void setExcludeTimerange(boolean excludeTimerange) {
        this.m_excludeTimerange = excludeTimerange;
    }

    public void setFileName(String fileName) {
        this.m_fileName = fileName;
    }

    public void setType(int type) {
        this.m_type = type;
    }

    protected void setCount(int count) {
        this.m_count = count;
    }
}

