/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.file;

import org.opencms.db.CmsResourceState;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsRequestContext;
import org.opencms.file.CmsResource;
import org.opencms.file.types.I_CmsResourceType;

public final class CmsResourceFilter {
    public static final CmsResourceFilter ALL = new CmsResourceFilter();
    public static final CmsResourceFilter ALL_MODIFIED = ALL.addExcludeState(CmsResource.STATE_UNCHANGED);
    public static final CmsResourceFilter DEFAULT = ALL.addExcludeState(CmsResource.STATE_DELETED).addRequireTimerange();
    public static final CmsResourceFilter DEFAULT_FILES = DEFAULT.addRequireFile();
    public static final CmsResourceFilter DEFAULT_FOLDERS = DEFAULT.addRequireFolder();
    public static final CmsResourceFilter DEFAULT_ONLY_VISIBLE = DEFAULT.addRequireVisible();
    public static final CmsResourceFilter IGNORE_EXPIRATION = ALL.addExcludeState(CmsResource.STATE_DELETED);
    public static final CmsResourceFilter ONLY_VISIBLE = ALL.addRequireVisible();
    public static final CmsResourceFilter ONLY_VISIBLE_NO_DELETED = ONLY_VISIBLE.addExcludeState(CmsResource.STATE_DELETED);
    private static final int EXCLUDED = 2;
    private static final int IGNORED = 0;
    private static final int REQUIRED = 1;
    private String m_cacheId;
    private long m_expireAfter = 0L;
    private long m_expireBefore = 0L;
    private boolean m_filterExpire = false;
    private int m_filterFlags = 0;
    private boolean m_filterLastModified = false;
    private boolean m_filterRelease = false;
    private int m_filterState = 0;
    private boolean m_filterTimerange = false;
    private int m_filterType = 0;
    private boolean m_filterVisible = false;
    private int m_flags = -1;
    private long m_modifiedAfter = 0L;
    private long m_modifiedBefore = 0L;
    private Boolean m_onlyFolders;
    private long m_releaseAfter = 0L;
    private long m_releaseBefore = 0L;
    private CmsResourceState m_state = null;
    private int m_type = -1;

    private CmsResourceFilter() {
        this.updateCacheId();
    }

    public static CmsResourceFilter ignoreExpirationOffline(CmsObject cms) {
        return cms.getRequestContext().getCurrentProject().isOnlineProject() ? DEFAULT : IGNORE_EXPIRATION;
    }

    public static CmsResourceFilter requireType(I_CmsResourceType type) {
        return new CmsResourceFilter().addRequireType(type);
    }

    @Deprecated
    public static CmsResourceFilter requireType(int type) {
        return new CmsResourceFilter().addRequireType(type);
    }

    public CmsResourceFilter addExcludeFlags(int flags) {
        CmsResourceFilter extendedFilter = (CmsResourceFilter)this.clone();
        extendedFilter.m_flags = flags;
        extendedFilter.m_filterFlags = 2;
        extendedFilter.updateCacheId();
        return extendedFilter;
    }

    public CmsResourceFilter addExcludeState(CmsResourceState state) {
        CmsResourceFilter extendedFilter = (CmsResourceFilter)this.clone();
        extendedFilter.m_state = state;
        extendedFilter.m_filterState = 2;
        extendedFilter.updateCacheId();
        return extendedFilter;
    }

    public CmsResourceFilter addExcludeTimerange() {
        CmsResourceFilter extendedFilter = (CmsResourceFilter)this.clone();
        extendedFilter.m_filterTimerange = false;
        extendedFilter.updateCacheId();
        return extendedFilter;
    }

    public CmsResourceFilter addExcludeType(I_CmsResourceType type) {
        return this.addExcludeType(type.getTypeId());
    }

    @Deprecated
    public CmsResourceFilter addExcludeType(int type) {
        CmsResourceFilter extendedFilter = (CmsResourceFilter)this.clone();
        extendedFilter.m_type = type;
        extendedFilter.m_filterType = 2;
        extendedFilter.updateCacheId();
        return extendedFilter;
    }

    public CmsResourceFilter addRequireExpireAfter(long time) {
        CmsResourceFilter extendedFilter = (CmsResourceFilter)this.clone();
        extendedFilter.m_filterExpire = true;
        extendedFilter.m_expireAfter = time;
        extendedFilter.updateCacheId();
        return extendedFilter;
    }

    public CmsResourceFilter addRequireExpireBefore(long time) {
        CmsResourceFilter extendedFilter = (CmsResourceFilter)this.clone();
        extendedFilter.m_filterExpire = true;
        extendedFilter.m_expireBefore = time;
        extendedFilter.updateCacheId();
        return extendedFilter;
    }

    public CmsResourceFilter addRequireFile() {
        CmsResourceFilter extendedFilter = (CmsResourceFilter)this.clone();
        extendedFilter.m_onlyFolders = Boolean.FALSE;
        extendedFilter.updateCacheId();
        return extendedFilter;
    }

    public CmsResourceFilter addRequireFlags(int flags) {
        CmsResourceFilter extendedFilter = (CmsResourceFilter)this.clone();
        extendedFilter.m_flags = flags;
        extendedFilter.m_filterFlags = 1;
        extendedFilter.updateCacheId();
        return extendedFilter;
    }

    public CmsResourceFilter addRequireFolder() {
        CmsResourceFilter extendedFilter = (CmsResourceFilter)this.clone();
        extendedFilter.m_onlyFolders = Boolean.TRUE;
        extendedFilter.updateCacheId();
        return extendedFilter;
    }

    public CmsResourceFilter addRequireLastModifiedAfter(long time) {
        CmsResourceFilter extendedFilter = (CmsResourceFilter)this.clone();
        extendedFilter.m_filterLastModified = true;
        extendedFilter.m_modifiedAfter = time;
        extendedFilter.updateCacheId();
        return extendedFilter;
    }

    public CmsResourceFilter addRequireLastModifiedBefore(long time) {
        CmsResourceFilter extendedFilter = (CmsResourceFilter)this.clone();
        extendedFilter.m_filterLastModified = true;
        extendedFilter.m_modifiedBefore = time;
        extendedFilter.updateCacheId();
        return extendedFilter;
    }

    public CmsResourceFilter addRequireReleaseAfter(long time) {
        CmsResourceFilter extendedFilter = (CmsResourceFilter)this.clone();
        extendedFilter.m_filterRelease = true;
        extendedFilter.m_releaseAfter = time;
        extendedFilter.updateCacheId();
        return extendedFilter;
    }

    public CmsResourceFilter addRequireReleaseBefore(long time) {
        CmsResourceFilter extendedFilter = (CmsResourceFilter)this.clone();
        extendedFilter.m_filterRelease = true;
        extendedFilter.m_releaseBefore = time;
        extendedFilter.updateCacheId();
        return extendedFilter;
    }

    public CmsResourceFilter addRequireState(CmsResourceState state) {
        CmsResourceFilter extendedFilter = (CmsResourceFilter)this.clone();
        extendedFilter.m_state = state;
        extendedFilter.m_filterState = 1;
        extendedFilter.updateCacheId();
        return extendedFilter;
    }

    public CmsResourceFilter addRequireTimerange() {
        CmsResourceFilter extendedFilter = (CmsResourceFilter)this.clone();
        extendedFilter.m_filterTimerange = true;
        extendedFilter.updateCacheId();
        return extendedFilter;
    }

    public CmsResourceFilter addRequireType(I_CmsResourceType type) {
        return this.addRequireType(type.getTypeId());
    }

    @Deprecated
    public CmsResourceFilter addRequireType(int type) {
        if (type != -1) {
            CmsResourceFilter extendedFilter = (CmsResourceFilter)this.clone();
            extendedFilter.m_type = type;
            extendedFilter.m_filterType = 1;
            extendedFilter.updateCacheId();
            return extendedFilter;
        }
        return this;
    }

    public CmsResourceFilter addRequireVisible() {
        CmsResourceFilter extendedFilter = (CmsResourceFilter)this.clone();
        extendedFilter.m_filterVisible = true;
        extendedFilter.updateCacheId();
        return extendedFilter;
    }

    public Object clone() {
        CmsResourceFilter filter = new CmsResourceFilter();
        filter.m_cacheId = this.m_cacheId;
        filter.m_expireAfter = this.m_expireAfter;
        filter.m_expireBefore = this.m_expireBefore;
        filter.m_filterExpire = this.m_filterExpire;
        filter.m_filterFlags = this.m_filterFlags;
        filter.m_filterLastModified = this.m_filterLastModified;
        filter.m_filterRelease = this.m_filterRelease;
        filter.m_filterState = this.m_filterState;
        filter.m_filterTimerange = this.m_filterTimerange;
        filter.m_filterType = this.m_filterType;
        filter.m_filterVisible = this.m_filterVisible;
        filter.m_flags = this.m_flags;
        filter.m_modifiedAfter = this.m_modifiedAfter;
        filter.m_modifiedBefore = this.m_modifiedBefore;
        filter.m_onlyFolders = this.m_onlyFolders;
        filter.m_releaseAfter = this.m_releaseAfter;
        filter.m_releaseBefore = this.m_releaseBefore;
        filter.m_state = this.m_state;
        filter.m_type = this.m_type;
        return filter;
    }

    public boolean excludeFlags() {
        return this.m_filterFlags == 2;
    }

    public boolean excludeState() {
        return this.m_filterState == 2;
    }

    public boolean excludeType() {
        return this.m_filterType == 2;
    }

    public String getCacheId() {
        return this.m_cacheId;
    }

    public long getExpireAfter() {
        return this.m_expireAfter;
    }

    public long getExpireBefore() {
        return this.m_expireBefore;
    }

    public int getFlags() {
        return this.m_flags;
    }

    public long getModifiedAfter() {
        return this.m_modifiedAfter;
    }

    public long getModifiedBefore() {
        return this.m_modifiedBefore;
    }

    public Boolean getOnlyFolders() {
        return this.m_onlyFolders;
    }

    public long getReleaseAfter() {
        return this.m_releaseAfter;
    }

    public long getReleaseBefore() {
        return this.m_releaseBefore;
    }

    public CmsResourceState getState() {
        return this.m_state;
    }

    public int getType() {
        return this.m_type;
    }

    public boolean includeDeleted() {
        return this.m_filterState == 0 || this.m_filterState == 1 && this.m_state.isDeleted() || this.m_filterState == 2 && !this.m_state.isDeleted();
    }

    public boolean isValid(CmsRequestContext context, CmsResource resource) {
        if (this == ALL) {
            return true;
        }
        switch (this.m_filterState) {
            case 2: {
                if (!resource.getState().equals(this.m_state)) break;
                return false;
            }
            case 1: {
                if (resource.getState().equals(this.m_state)) break;
                return false;
            }
        }
        switch (this.m_filterFlags) {
            case 2: {
                if ((resource.getFlags() & this.m_flags) == 0) break;
                return false;
            }
            case 1: {
                if ((resource.getFlags() & this.m_flags) == this.m_flags) break;
                return false;
            }
        }
        switch (this.m_filterType) {
            case 2: {
                if (resource.getTypeId() != this.m_type) break;
                return false;
            }
            case 1: {
                if (resource.getTypeId() == this.m_type) break;
                return false;
            }
        }
        if (this.m_onlyFolders != null && (this.m_onlyFolders != false ? !resource.isFolder() : resource.isFolder())) {
            return false;
        }
        if (this.m_filterLastModified) {
            if (this.m_modifiedAfter > 0L && resource.getDateLastModified() < this.m_modifiedAfter) {
                return false;
            }
            if (this.m_modifiedBefore > 0L && resource.getDateLastModified() > this.m_modifiedBefore) {
                return false;
            }
        }
        if (this.m_filterExpire) {
            if (this.m_expireAfter > 0L && resource.getDateExpired() < this.m_expireAfter) {
                return false;
            }
            if (this.m_expireBefore > 0L && resource.getDateExpired() > this.m_expireBefore) {
                return false;
            }
        }
        if (this.m_filterRelease) {
            if (this.m_releaseAfter > 0L && resource.getDateReleased() < this.m_releaseAfter) {
                return false;
            }
            if (this.m_releaseBefore > 0L && resource.getDateReleased() > this.m_releaseBefore) {
                return false;
            }
        }
        return !this.m_filterTimerange || resource.isReleasedAndNotExpired(context.getRequestTime());
    }

    public boolean requireFlags() {
        return this.m_filterFlags == 1;
    }

    public boolean requireState() {
        return this.m_filterState == 1;
    }

    public boolean requireTimerange() {
        return this.m_filterTimerange;
    }

    public boolean requireType() {
        return this.m_filterType == 1;
    }

    public boolean requireVisible() {
        return this.m_filterVisible;
    }

    public String toString() {
        if (this.equals(ALL)) {
            return "ALL";
        }
        if (this.equals(ALL_MODIFIED)) {
            return "ALL_MODIFIED";
        }
        if (this.equals(DEFAULT)) {
            return "DEFAULT";
        }
        if (this.equals(DEFAULT_FILES)) {
            return "DEFAULT_FILES";
        }
        if (this.equals(DEFAULT_FOLDERS)) {
            return "DEFAULT_FOLDERS";
        }
        if (this.equals(IGNORE_EXPIRATION)) {
            return "IGNORE_EXPIRATION";
        }
        if (this.equals(ONLY_VISIBLE)) {
            return "ONLY_VISIBLE";
        }
        if (this.equals(ONLY_VISIBLE_NO_DELETED)) {
            return "ONLY_VISIBLE_NO_DELETED";
        }
        return "Nonstandard Resource Filter";
    }

    private void updateCacheId() {
        StringBuffer result = new StringBuffer(32);
        if (this.m_filterVisible) {
            result.append(" Vi");
        }
        if (this.m_filterTimerange) {
            result.append(" Ti");
        }
        switch (this.m_filterState) {
            case 1: {
                result.append(" Sr");
                result.append(this.m_state);
                break;
            }
            case 2: {
                result.append(" Sx");
                result.append(this.m_state);
                break;
            }
        }
        switch (this.m_filterFlags) {
            case 1: {
                result.append(" Fr");
                result.append(this.m_flags);
                break;
            }
            case 2: {
                result.append(" Fx");
                result.append(this.m_flags);
                break;
            }
        }
        switch (this.m_filterType) {
            case 1: {
                result.append(" Tr");
                result.append(this.m_type);
                break;
            }
            case 2: {
                result.append(" Tx");
                result.append(this.m_type);
                break;
            }
        }
        if (this.m_onlyFolders != null) {
            if (this.m_onlyFolders.booleanValue()) {
                result.append(" Fo");
            } else {
                result.append(" Fi");
            }
        }
        if (this.m_filterLastModified) {
            result.append(" Lt");
            result.append(this.m_modifiedAfter);
            result.append("-");
            result.append(this.m_modifiedBefore);
        }
        if (this.m_filterExpire) {
            result.append(" Ex");
            result.append(this.m_expireAfter);
            result.append("-");
            result.append(this.m_expireBefore);
        }
        if (this.m_filterRelease) {
            result.append(" Re");
            result.append(this.m_releaseAfter);
            result.append("-");
            result.append(this.m_releaseBefore);
        }
        this.m_cacheId = result.toString();
    }
}

