/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.file;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.dom4j.Document;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.Messages;
import org.opencms.file.types.A_CmsResourceTypeLinkParseable;
import org.opencms.file.types.CmsResourceTypeJsp;
import org.opencms.file.types.CmsResourceTypeXmlContent;
import org.opencms.file.types.I_CmsResourceType;
import org.opencms.i18n.CmsEncoder;
import org.opencms.loader.CmsLoaderException;
import org.opencms.lock.CmsLock;
import org.opencms.main.CmsException;
import org.opencms.main.CmsIllegalArgumentException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.relations.CmsRelation;
import org.opencms.relations.CmsRelationFilter;
import org.opencms.relations.CmsRelationType;
import org.opencms.relations.I_CmsLinkParseable;
import org.opencms.util.CmsFileUtil;
import org.opencms.util.CmsPair;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;
import org.opencms.util.I_CmsRegexSubstitution;
import org.opencms.xml.CmsXmlEntityResolver;
import org.opencms.xml.CmsXmlException;
import org.opencms.xml.CmsXmlUtils;
import org.opencms.xml.content.CmsXmlContent;
import org.opencms.xml.content.CmsXmlContentFactory;
import org.xml.sax.EntityResolver;

public class CmsLinkRewriter {
    private static final Log LOG = CmsLog.getLog(CmsLinkRewriter.class);
    protected Map<CmsUUID, CmsResource> m_translationsById = new HashMap<CmsUUID, CmsResource>();
    protected Map<String, CmsResource> m_translationsByPath = new HashMap<String, CmsResource>();
    private Map<CmsUUID, CmsResource> m_cachedResources = new HashMap<CmsUUID, CmsResource>();
    private CmsObject m_cms;
    private boolean m_rewriteAllXmlContents = true;
    private Set<CmsUUID> m_rewrittenContent = new HashSet<CmsUUID>();
    private List<CmsPair<String, String>> m_sourceTargetPairs = new ArrayList<CmsPair<String, String>>();
    private String m_targetPath;

    public CmsLinkRewriter(CmsObject cms, List<String> sources, String target) {
        this.m_sourceTargetPairs = new ArrayList<CmsPair<String, String>>();
        for (String source : sources) {
            this.checkNotSubPath(source, target);
            String targetSub = CmsStringUtil.joinPaths(target, CmsResource.getName(source));
            this.m_sourceTargetPairs.add(CmsPair.create(source, targetSub));
        }
        this.m_targetPath = target;
        this.m_cms = cms;
    }

    public CmsLinkRewriter(CmsObject cms, String targetPath, List<CmsPair<String, String>> sourceTargetPairs) {
        this.m_cms = cms;
        this.m_targetPath = targetPath;
        this.m_sourceTargetPairs = sourceTargetPairs;
    }

    public CmsLinkRewriter(CmsObject cms, String source, String target) {
        this.m_sourceTargetPairs = new ArrayList<CmsPair<String, String>>();
        this.checkNotSubPath(source, target);
        this.m_sourceTargetPairs.add(CmsPair.create(source, target));
        this.m_targetPath = target;
        this.m_cms = cms;
    }

    protected static void checkIsFolder(CmsResource resource) throws CmsException {
        if (!CmsLinkRewriter.isFolder(resource)) {
            throw new CmsIllegalArgumentException(org.opencms.xml.content.Messages.get().container("ERR_REWRITE_LINKS_ROOT_NOT_FOLDER_1", resource.getRootPath()));
        }
    }

    protected static boolean isFolder(CmsResource resource) throws CmsLoaderException {
        I_CmsResourceType resourceType = OpenCms.getResourceManager().getResourceType(resource.getTypeId());
        return resourceType.isFolder();
    }

    public void rewriteLinks() throws CmsException {
        CmsResource resource;
        this.init();
        List<CmsRelation> relationsToCorrect = this.findRelationsFromTargetToSource();
        ArrayListMultimap relationsBySourceId = ArrayListMultimap.create();
        for (CmsRelation relation : relationsToCorrect) {
            LOG.info((Object)("Found relation which needs to be corrected: " + relation.getSourcePath() + " -> " + relation.getTargetPath() + " [" + relation.getType().getName() + "]"));
            relationsBySourceId.put((Object)relation.getSourceId(), (Object)relation);
        }
        CmsLock lock = this.m_cms.getLock(this.m_targetPath);
        if (lock.isUnlocked() || !lock.isOwnedBy(this.m_cms.getRequestContext().getCurrentUser())) {
            this.m_cms.lockResource(this.m_targetPath);
        }
        for (CmsUUID cmsUUID : relationsBySourceId.keySet()) {
            Collection relationsForResource = relationsBySourceId.get((Object)cmsUUID);
            resource = null;
            try {
                resource = this.getResource(cmsUUID);
                this.rewriteLinks(resource, relationsForResource);
            }
            catch (Exception e) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        if (!this.m_rewriteAllXmlContents) {
            return;
        }
        for (Map.Entry entry : this.m_cachedResources.entrySet()) {
            I_CmsResourceType resType;
            CmsUUID key = (CmsUUID)entry.getKey();
            resource = (CmsResource)entry.getValue();
            if (!this.isInTargets(resource.getRootPath()) || this.m_rewrittenContent.contains(key) || !((resType = OpenCms.getResourceManager().getResourceType(resource.getTypeId())) instanceof A_CmsResourceTypeLinkParseable)) continue;
            try {
                CmsFile file = this.m_cms.readFile(resource);
                if (resType instanceof CmsResourceTypeXmlContent) {
                    CmsXmlContent content = CmsXmlContentFactory.unmarshal(this.m_cms, file);
                    try {
                        content.validateXmlStructure(new CmsXmlEntityResolver(this.m_cms));
                    }
                    catch (CmsException e) {
                        LOG.info((Object)("XML content was corrected automatically for resource " + file.getRootPath()));
                        content.setAutoCorrectionEnabled(true);
                        content.correctXmlStructure(this.m_cms);
                        file.setContents(content.marshal());
                    }
                }
                this.m_cms.writeFile(file);
            }
            catch (CmsException e) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        this.copyLocaleRelations();
    }

    public void setRewriteAllContents(boolean rewriteAllContents) {
        this.m_rewriteAllXmlContents = rewriteAllContents;
    }

    protected void checkNotSubPath(String source, String target) {
        source = CmsStringUtil.joinPaths("/", source, "/");
        if ((target = CmsStringUtil.joinPaths("/", target, "/")).startsWith(source)) {
            throw new CmsIllegalArgumentException(Messages.get().container("ERR_REWRITE_LINKS_ROOTS_DEPENDENT_2", source, target));
        }
    }

    protected void copyLocaleRelations() throws CmsException {
        long start = System.currentTimeMillis();
        List<CmsRelation> localeRelations = this.m_cms.readRelations(CmsRelationFilter.ALL.filterType(CmsRelationType.LOCALE_VARIANT));
        for (CmsRelation rel : localeRelations) {
            if (!this.isInSources(rel.getSourcePath()) || !this.isInSources(rel.getTargetPath())) continue;
            CmsResource newRelationSource = this.m_translationsById.get(rel.getSourceId());
            CmsResource newRelationTarget = this.m_translationsById.get(rel.getTargetId());
            if (newRelationSource != null && newRelationTarget != null) {
                try {
                    this.m_cms.addRelationToResource(newRelationSource, newRelationTarget, CmsRelationType.LOCALE_VARIANT.getName());
                }
                catch (CmsException e) {
                    LOG.error((Object)("Could not transfer locale relation: " + e.getLocalizedMessage()), (Throwable)e);
                }
                continue;
            }
            LOG.warn((Object)("Could not transfer locale relation because source/target not found in copy: " + String.valueOf(rel)));
        }
        long end = System.currentTimeMillis();
        LOG.info((Object)("Copied locale relations, took " + (end - start) + "ms"));
    }

    protected String decode(byte[] bytes, String encoding) {
        try {
            return new String(bytes, encoding);
        }
        catch (UnsupportedEncodingException e) {
            return new String(bytes);
        }
    }

    protected CmsPair<String, String> decode(CmsFile file) throws CmsException {
        String content = null;
        String encoding = this.getConfiguredEncoding(this.m_cms, file);
        I_CmsResourceType resType = OpenCms.getResourceManager().getResourceType(file.getTypeId());
        if (resType instanceof CmsResourceTypeJsp) {
            content = this.decode(file.getContents(), encoding);
        } else {
            try {
                CmsXmlEntityResolver resolver = new CmsXmlEntityResolver(this.m_cms);
                Document doc = CmsXmlUtils.unmarshalHelper(file.getContents(), (EntityResolver)resolver);
                content = CmsXmlUtils.marshal(doc, encoding);
            }
            catch (Exception e) {
                content = this.decode(file.getContents(), encoding);
            }
        }
        return CmsPair.create(content, encoding);
    }

    protected List<CmsRelation> findRelationsFromTargetToSource() throws CmsException {
        List<CmsRelation> relations = this.m_cms.readRelations(CmsRelationFilter.SOURCES.filterPath(this.m_targetPath).filterIncludeChildren());
        ArrayList<CmsRelation> result = new ArrayList<CmsRelation>();
        for (CmsRelation rel : relations) {
            if (!this.isInTargets(rel.getSourcePath()) || !this.isInSources(rel.getTargetPath())) continue;
            result.add(rel);
        }
        return result;
    }

    protected String getConfiguredEncoding(CmsObject cms, CmsResource resource) throws CmsException {
        String encoding = null;
        try {
            encoding = cms.readPropertyObject(resource.getRootPath(), "content-encoding", true).getValue();
        }
        catch (CmsException cmsException) {
            // empty catch block
        }
        if (encoding == null) {
            encoding = OpenCms.getSystemInfo().getDefaultEncoding();
        } else if ((encoding = CmsEncoder.lookupEncoding(encoding, null)) == null) {
            throw new CmsXmlException(org.opencms.xml.content.Messages.get().container("ERR_XMLCONTENT_INVALID_ENC_1", resource.getRootPath()));
        }
        return encoding;
    }

    protected List<CmsPair<CmsResource, CmsResource>> getMatchingResources(String source, String target) throws CmsException {
        List<CmsResource> sourceResources = this.readTree(source);
        Map<String, CmsResource> sourceRelative = this.getResourcesByRelativePath(sourceResources, source);
        List<CmsResource> targetResources = this.readTree(target);
        Map<String, CmsResource> targetRelative = this.getResourcesByRelativePath(targetResources, target);
        ArrayList<CmsPair<CmsResource, CmsResource>> result = new ArrayList<CmsPair<CmsResource, CmsResource>>();
        sourceRelative.keySet().retainAll(targetRelative.keySet());
        for (Map.Entry<String, CmsResource> entry : sourceRelative.entrySet()) {
            String key = entry.getKey();
            CmsResource sourceRes = entry.getValue();
            CmsResource targetRes = targetRelative.get(key);
            result.add(CmsPair.create(sourceRes, targetRes));
        }
        return result;
    }

    protected String getRelativePath(String ancestor, String rootPath) {
        String result = rootPath.substring(ancestor.length());
        result = CmsStringUtil.joinPaths("/", result, "/");
        return result;
    }

    protected CmsResource getResource(CmsUUID structureId) throws CmsException {
        if (this.m_cachedResources.containsKey(structureId)) {
            return this.m_cachedResources.get(structureId);
        }
        return this.m_cms.readResource(structureId);
    }

    protected Map<String, CmsResource> getResourcesByRelativePath(List<CmsResource> resources, String basePath) {
        HashMap<String, CmsResource> result = new HashMap<String, CmsResource>();
        for (CmsResource resource : resources) {
            String relativeSubPath = CmsStringUtil.getRelativeSubPath(basePath, resource.getRootPath());
            if (relativeSubPath == null) continue;
            result.put(relativeSubPath, resource);
        }
        return result;
    }

    protected void init() throws CmsException {
        this.m_cms = OpenCms.initCmsObject(this.m_cms);
        this.m_cms.getRequestContext().setSiteRoot("");
        ArrayList allMatchingResources = Lists.newArrayList();
        for (CmsPair<String, String> pair : this.m_sourceTargetPairs) {
            List<CmsPair<CmsResource, CmsResource>> matchingResources = this.getMatchingResources(pair.getFirst(), pair.getSecond());
            allMatchingResources.addAll(matchingResources);
        }
        for (CmsPair<String, String> resPair : allMatchingResources) {
            CmsResource source = (CmsResource)((Object)resPair.getFirst());
            CmsResource target = (CmsResource)((Object)resPair.getSecond());
            this.m_translationsById.put(source.getStructureId(), target);
            this.m_translationsByPath.put(source.getRootPath(), target);
        }
    }

    protected boolean isInSources(String path) {
        for (CmsPair<String, String> sourceTargetPair : this.m_sourceTargetPairs) {
            String source = sourceTargetPair.getFirst();
            if (!CmsStringUtil.joinPaths(path, "/").startsWith(CmsStringUtil.joinPaths(source, "/"))) continue;
            return true;
        }
        return false;
    }

    protected boolean isInTargets(String path) {
        for (CmsPair<String, String> sourceTargetPair : this.m_sourceTargetPairs) {
            String target = sourceTargetPair.getSecond();
            if (!CmsStringUtil.joinPaths(path, "/").startsWith(CmsStringUtil.joinPaths(target, "/"))) continue;
            return true;
        }
        return false;
    }

    protected List<CmsResource> readTree(String rootPath) throws CmsException {
        rootPath = CmsFileUtil.removeTrailingSeparator(rootPath);
        CmsResource base = this.m_cms.readResource(rootPath);
        I_CmsResourceType resType = OpenCms.getResourceManager().getResourceType(base);
        ArrayList<CmsResource> result = new ArrayList<CmsResource>();
        if (resType.isFolder()) {
            rootPath = CmsStringUtil.joinPaths(rootPath, "/");
            List<CmsResource> subResources = this.m_cms.readResources(rootPath, CmsResourceFilter.ALL, true);
            result.add(base);
            result.addAll(subResources);
        } else {
            result.add(base);
        }
        for (CmsResource resource : result) {
            this.m_cachedResources.put(resource.getStructureId(), resource);
        }
        return result;
    }

    protected void rewriteContent(CmsFile file, Collection<CmsRelation> relations) throws CmsException {
        byte[] newContentBytes;
        LOG.info((Object)("Rewriting in-content links for " + file.getRootPath()));
        CmsPair<String, String> contentAndEncoding = this.decode(file);
        String content = "";
        if (OpenCms.getResourceManager().getResourceType(file) instanceof CmsResourceTypeXmlContent) {
            CmsXmlContent contentXml = CmsXmlContentFactory.unmarshal(this.m_cms, file);
            try {
                contentXml.validateXmlStructure(new CmsXmlEntityResolver(this.m_cms));
            }
            catch (CmsException e) {
                LOG.info((Object)("XML content was corrected automatically for resource " + file.getRootPath()));
                contentXml.setAutoCorrectionEnabled(true);
                contentXml.correctXmlStructure(this.m_cms);
                try {
                    content = new String(contentXml.marshal(), contentAndEncoding.getSecond());
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
            }
        }
        if (content.isEmpty()) {
            content = contentAndEncoding.getFirst();
        }
        String encodingForSave = contentAndEncoding.getSecond();
        String newContent = this.rewriteContentString(content);
        try {
            newContentBytes = newContent.getBytes(encodingForSave);
        }
        catch (UnsupportedEncodingException e) {
            newContentBytes = newContent.getBytes();
        }
        file.setContents(newContentBytes);
        this.m_cms.writeFile(file);
    }

    protected String rewriteContentString(String originalContent) {
        Pattern uuidPattern = Pattern.compile("[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}");
        I_CmsRegexSubstitution substitution = new I_CmsRegexSubstitution(){

            @Override
            public String substituteMatch(String text, Matcher matcher) {
                String uuidString = text.substring(matcher.start(), matcher.end());
                CmsUUID uuid = new CmsUUID(uuidString);
                String result = uuidString;
                if (CmsLinkRewriter.this.m_translationsById.containsKey(uuid)) {
                    result = CmsLinkRewriter.this.m_translationsById.get(uuid).getStructureId().toString();
                }
                return result;
            }
        };
        return CmsStringUtil.substitute(uuidPattern, originalContent, substitution);
    }

    protected void rewriteLinks(CmsResource resource, Collection<CmsRelation> relations) throws CmsException {
        LOG.info((Object)("Rewriting relations for resource " + resource.getRootPath()));
        I_CmsResourceType resourceType = OpenCms.getResourceManager().getResourceType(resource.getTypeId());
        boolean hasContentLinks = false;
        boolean hasOtherLinks = false;
        for (CmsRelation relation : relations) {
            if (relation.getType().isDefinedInContent()) {
                hasContentLinks = true;
                continue;
            }
            hasOtherLinks = true;
        }
        if (hasContentLinks) {
            LOG.info((Object)("The resource " + resource.getRootPath() + " has links in the content."));
        }
        if (hasOtherLinks) {
            LOG.info((Object)("The resource " + resource.getRootPath() + " has non-content links."));
        }
        if (hasContentLinks && resourceType instanceof I_CmsLinkParseable) {
            CmsFile file = this.m_cms.readFile(resource);
            this.rewriteContent(file, relations);
            this.m_rewrittenContent.add(file.getStructureId());
        }
        if (hasOtherLinks) {
            this.rewriteOtherRelations(resource, relations);
        }
    }

    protected void rewriteOtherRelations(CmsResource res, Collection<CmsRelation> relations) throws CmsException {
        LOG.info((Object)("Rewriting non-content links for " + res.getRootPath()));
        for (CmsRelation rel : relations) {
            CmsUUID targetId = rel.getTargetId();
            CmsResource newTargetResource = this.m_translationsById.get(targetId);
            CmsRelationType relType = rel.getType();
            if (relType.isDefinedInContent() || newTargetResource == null) continue;
            this.m_cms.deleteRelationsFromResource(rel.getSourcePath(), CmsRelationFilter.TARGETS.filterStructureId(rel.getTargetId()).filterType(relType));
            this.m_cms.addRelationToResource(rel.getSourcePath(), newTargetResource.getRootPath(), relType.getName());
        }
    }
}

