/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.db.urlname;

import java.util.ArrayList;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;

public class CmsUrlNameMappingFilter {
    public static final CmsUrlNameMappingFilter ALL = new CmsUrlNameMappingFilter();
    private String m_locale;
    private String m_name;
    private String m_namePattern;
    private CmsUUID m_rejectStructureId;
    private int[] m_states;
    private CmsUUID m_structureId;

    protected CmsUrlNameMappingFilter() {
    }

    protected CmsUrlNameMappingFilter(CmsUrlNameMappingFilter filter) {
        this.m_name = filter.m_name;
        this.m_structureId = filter.m_structureId;
        this.m_rejectStructureId = filter.m_rejectStructureId;
        this.m_states = filter.m_states;
        this.m_namePattern = filter.m_namePattern;
        this.m_locale = filter.m_locale;
    }

    public CmsUrlNameMappingFilter filterLocale(String locale) {
        if (locale == null) {
            throw new IllegalArgumentException();
        }
        CmsUrlNameMappingFilter result = new CmsUrlNameMappingFilter(this);
        result.m_locale = locale;
        return result;
    }

    public CmsUrlNameMappingFilter filterName(String name) {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        CmsUrlNameMappingFilter result = new CmsUrlNameMappingFilter(this);
        result.m_name = name;
        return result;
    }

    public CmsUrlNameMappingFilter filterNamePattern(String namePattern) {
        if (namePattern == null) {
            throw new IllegalArgumentException();
        }
        CmsUrlNameMappingFilter result = new CmsUrlNameMappingFilter(this);
        result.m_namePattern = namePattern;
        return result;
    }

    public CmsUrlNameMappingFilter filterRejectStructureId(CmsUUID id) {
        if (id == null) {
            throw new IllegalArgumentException();
        }
        if (this.m_structureId != null) {
            throw new IllegalStateException();
        }
        CmsUrlNameMappingFilter result = new CmsUrlNameMappingFilter(this);
        result.m_rejectStructureId = id;
        return result;
    }

    public CmsUrlNameMappingFilter filterStates(int ... states) {
        CmsUrlNameMappingFilter result = new CmsUrlNameMappingFilter(this);
        result.m_states = states;
        return result;
    }

    public CmsUrlNameMappingFilter filterStructureId(CmsUUID structureId) {
        if (structureId == null) {
            throw new IllegalArgumentException();
        }
        CmsUrlNameMappingFilter result = new CmsUrlNameMappingFilter(this);
        result.m_structureId = structureId;
        return result;
    }

    public String getLocale() {
        return this.m_locale;
    }

    public String getName() {
        return this.m_name;
    }

    public String getNamePattern() {
        return this.m_namePattern;
    }

    public CmsUUID getRejectStructureId() {
        return this.m_rejectStructureId;
    }

    public int[] getStates() {
        return this.m_states;
    }

    public CmsUUID getStructureId() {
        return this.m_structureId;
    }

    public boolean isIdFilter() {
        return this.m_structureId != null && this.m_name == null && this.m_namePattern == null && this.m_states == null && this.m_rejectStructureId == null && this.m_locale == null;
    }

    public boolean isNameFilter() {
        return this.m_structureId == null && this.m_name != null && this.m_namePattern == null && this.m_states == null && this.m_rejectStructureId == null && this.m_locale == null;
    }

    public String toString() {
        ArrayList<Object> resultParts = new ArrayList<Object>();
        resultParts.add("[CmsUrlNameMappingFilter:");
        if (this.m_name != null) {
            resultParts.add("name='" + this.m_name + "'");
        }
        if (this.m_structureId != null) {
            resultParts.add("id=" + String.valueOf(this.m_structureId));
        }
        if (this.m_states != null) {
            resultParts.add("states=" + String.valueOf(this.m_states));
        }
        if (this.m_namePattern != null) {
            resultParts.add("pattern='" + this.m_namePattern + "'");
        }
        if (this.m_rejectStructureId != null) {
            resultParts.add("rejectId=" + String.valueOf(this.m_rejectStructureId));
        }
        resultParts.add("]");
        return CmsStringUtil.listAsString(resultParts, " ");
    }
}

