/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.db.oracle;

import com.google.common.base.Joiner;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.opencms.db.CmsDbContext;
import org.opencms.db.CmsDbEntryNotFoundException;
import org.opencms.db.CmsDbIoException;
import org.opencms.db.CmsDbSqlException;
import org.opencms.db.CmsSelectQuery;
import org.opencms.db.CmsSimpleQueryFragment;
import org.opencms.db.I_CmsQueryFragment;
import org.opencms.db.generic.CmsUserQueryBuilder;
import org.opencms.db.generic.Messages;
import org.opencms.db.oracle.CmsSqlManager;
import org.opencms.file.CmsDataAccessException;
import org.opencms.util.CmsDataTypeUtil;
import org.opencms.util.CmsUUID;

public class CmsUserDriver
extends org.opencms.db.generic.CmsUserDriver {
    public static OutputStream getOutputStreamFromBlob(ResultSet res, String name) throws SQLException {
        Blob blob = res.getBlob(name);
        blob.truncate(0L);
        return blob.setBinaryStream(0L);
    }

    @Override
    public CmsUserQueryBuilder createUserQueryBuilder() {
        return new CmsUserQueryBuilder(){

            @Override
            protected I_CmsQueryFragment createFlagCondition(CmsSelectQuery.TableAlias users, int flags) {
                return new CmsSimpleQueryFragment("BITAND(" + users.column("USER_FLAGS") + ", ?) = ? ", flags, flags);
            }

            @Override
            protected String generateConcat(String ... expressions) {
                return Joiner.on((String)" || ").join((Object[])expressions);
            }

            @Override
            protected String getUserFlagExpression(CmsSelectQuery.TableAlias users, int flags) {
                return "BITAND(" + users.column("USER_FLAGS") + ", " + flags + ")";
            }

            @Override
            protected boolean useWindowFunctionsForPaging() {
                return true;
            }
        };
    }

    @Override
    public org.opencms.db.generic.CmsSqlManager initSqlManager(String classname) {
        return org.opencms.db.generic.CmsSqlManager.getInstance(classname);
    }

    @Override
    protected void internalUpdateUserInfo(CmsDbContext dbc, CmsUUID userId, String key, Object value) throws CmsDataAccessException {
        PreparedStatement stmt = null;
        Connection conn = null;
        try {
            conn = this.m_sqlManager.getConnection(dbc);
            stmt = this.m_sqlManager.getPreparedStatement(conn, "C_ORACLE_USERDATA_UPDATE_3");
            stmt.setString(1, value.getClass().getName());
            stmt.setString(2, userId.toString());
            stmt.setString(3, key);
            stmt.executeUpdate();
            this.m_sqlManager.closeAll(dbc, conn, stmt, null);
        }
        catch (SQLException e) {
            try {
                throw new CmsDbSqlException(Messages.get().container("ERR_GENERIC_SQL_1", CmsDbSqlException.getErrorQuery(stmt)), (Throwable)e);
            }
            catch (Throwable throwable) {
                this.m_sqlManager.closeAll(dbc, conn, stmt, null);
                throw throwable;
            }
        }
        this.internalUpdateUserInfoData(dbc, userId, key, value);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void internalUpdateUserInfoData(CmsDbContext dbc, CmsUUID userId, String key, Object value) throws CmsDataAccessException {
        PreparedStatement stmt = null;
        PreparedStatement commit = null;
        ResultSet res = null;
        Connection conn = null;
        boolean wasInTransaction = false;
        try {
            conn = this.m_sqlManager.getConnection(dbc);
            boolean bl = wasInTransaction = !conn.getAutoCommit();
            if (!wasInTransaction) {
                conn.setAutoCommit(false);
            }
            stmt = this.m_sqlManager.getPreparedStatement(conn, "C_ORACLE_USERDATA_UPDATE_2");
            stmt.setString(1, userId.toString());
            stmt.setString(2, key);
            res = stmt.executeQuery();
            if (!res.next()) {
                throw new CmsDbEntryNotFoundException(Messages.get().container("ERR_NO_USER_WITH_ID_1", userId));
            }
            OutputStream output = CmsUserDriver.getOutputStreamFromBlob(res, "DATA_VALUE");
            output.write(CmsDataTypeUtil.dataSerialize(value));
            output.close();
            value = null;
            if (!wasInTransaction) {
                commit = this.m_sqlManager.getPreparedStatement(conn, "C_COMMIT");
                commit.execute();
                this.m_sqlManager.closeAll(dbc, null, commit, null);
            }
            this.m_sqlManager.closeAll(dbc, null, stmt, res);
            commit = null;
            stmt = null;
            res = null;
            if (!wasInTransaction) {
                conn.setAutoCommit(true);
            }
        }
        catch (SQLException e) {
            try {
                throw new CmsDbSqlException(Messages.get().container("ERR_GENERIC_SQL_1", CmsDbSqlException.getErrorQuery(stmt)), (Throwable)e);
                catch (IOException e2) {
                    throw new CmsDbIoException(Messages.get().container("ERR_SERIALIZING_USER_DATA_1", userId), (Throwable)e2);
                }
            }
            catch (Throwable throwable) {
                CmsSqlManager.closeAllInTransaction(this.m_sqlManager, dbc, conn, stmt, res, commit, wasInTransaction);
                throw throwable;
            }
        }
        CmsSqlManager.closeAllInTransaction(this.m_sqlManager, dbc, conn, stmt, res, commit, wasInTransaction);
    }

    @Override
    protected void internalWriteUserInfo(CmsDbContext dbc, CmsUUID userId, String key, Object value) throws CmsDataAccessException {
        PreparedStatement stmt = null;
        Connection conn = null;
        try {
            conn = this.m_sqlManager.getConnection(dbc);
            stmt = this.m_sqlManager.getPreparedStatement(conn, "C_ORACLE_USERDATA_WRITE_3");
            stmt.setString(1, userId.toString());
            stmt.setString(2, key);
            stmt.setString(3, value.getClass().getName());
            stmt.executeUpdate();
            this.m_sqlManager.closeAll(dbc, conn, stmt, null);
        }
        catch (SQLException e) {
            try {
                throw new CmsDbSqlException(Messages.get().container("ERR_GENERIC_SQL_1", CmsDbSqlException.getErrorQuery(stmt)), (Throwable)e);
            }
            catch (Throwable throwable) {
                this.m_sqlManager.closeAll(dbc, conn, stmt, null);
                throw throwable;
            }
        }
        this.internalUpdateUserInfoData(dbc, userId, key, value);
    }
}

