/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.db;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.opencms.db.CmsExportPoint;
import org.opencms.db.CmsExportPointDriver;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsStringUtil;

public class CmsTempFolderExportPointDriver
extends CmsExportPointDriver {
    private static final Log LOG = CmsLog.getLog(CmsTempFolderExportPointDriver.class);
    public static final String DELETE_MARKER = "--OCMS-TEMP-EXPORTPOINT-DELETED-FILE-MARKER--";
    protected static byte[] DELETE_MARKER_BYTES;
    public static final String TEMP_EXPORTPOINT_FOLDER = "WEB-INF/exportpoint-temp";
    private Map<String, CmsExportPoint> m_exportPointMap = Maps.newHashMap();
    private Set<String> m_urisWithTempFolderDestinations = Sets.newHashSet();
    private List<String> m_tempFolderDestinations;

    public CmsTempFolderExportPointDriver(Set<CmsExportPoint> exportpoints, List<String> tempFolderDestinations) {
        this.m_tempFolderDestinations = tempFolderDestinations;
        this.m_exportpoints = exportpoints;
        this.m_exportpointLookupMap = new HashMap();
        for (CmsExportPoint point : this.m_exportpoints) {
            String dest = point.getConfiguredDestination();
            this.m_exportPointMap.put(point.getUri(), point);
            if (this.shouldUseTempFolderForDestination(dest)) {
                String realDest = OpenCms.getSystemInfo().getAbsoluteRfsPathRelativeToWebApplication(CmsStringUtil.joinPaths(TEMP_EXPORTPOINT_FOLDER, point.getConfiguredDestination()));
                this.m_exportpointLookupMap.put(point.getUri(), realDest);
                this.m_urisWithTempFolderDestinations.add(point.getUri());
                continue;
            }
            if (point.getDestinationPath() == null) continue;
            this.m_exportpointLookupMap.put(point.getUri(), point.getDestinationPath());
        }
    }

    private static String removeLeadingSlash(String path) {
        return path.replaceFirst("^/+", "");
    }

    @Override
    public void deleteResource(String resourceName, String exportpoint) {
        File file = this.getExportPointFile(resourceName, exportpoint);
        if (this.m_urisWithTempFolderDestinations.contains(exportpoint)) {
            if (resourceName.endsWith("/")) {
                return;
            }
            this.writeFile(resourceName, exportpoint, DELETE_MARKER_BYTES);
        } else if (file.exists() && file.canWrite()) {
            file.delete();
            File parent = file.getParentFile();
            if (parent.canWrite()) {
                parent.delete();
            }
        }
    }

    @Override
    public void writeFile(String resourceName, String exportpoint, byte[] content) {
        StringBuffer exportpath = new StringBuffer(128);
        exportpath.append((String)this.m_exportpointLookupMap.get(exportpoint));
        exportpath.append(resourceName.substring(exportpoint.length()));
        File file = new File(exportpath.toString());
        this.writeResource(file, content);
        CmsExportPoint point = this.m_exportPointMap.get(exportpoint);
        if (content != DELETE_MARKER_BYTES && this.shouldUseTempFolderForDestination(point.getConfiguredDestination())) {
            exportpath = new StringBuffer(128);
            exportpath.append(point.getDestinationPath());
            exportpath.append(resourceName.substring(exportpoint.length()));
            file = new File(exportpath.toString());
            if (!file.exists()) {
                this.writeResource(file, content);
            }
        }
    }

    private boolean shouldUseTempFolderForDestination(String destination) {
        destination = CmsTempFolderExportPointDriver.removeLeadingSlash(destination);
        for (String tempFolderDestination : this.m_tempFolderDestinations) {
            if (!CmsStringUtil.isPrefixPath(tempFolderDestination = CmsTempFolderExportPointDriver.removeLeadingSlash(tempFolderDestination), destination)) continue;
            return true;
        }
        return false;
    }

    static {
        try {
            DELETE_MARKER_BYTES = DELETE_MARKER.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
    }
}

