/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.db;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.opencms.db.CmsDbException;
import org.opencms.db.CmsDbPoolV11;
import org.opencms.db.CmsDriverManager;

public class CmsSqlManager {
    private CmsDriverManager m_driverManager;

    protected CmsSqlManager() {
    }

    protected CmsSqlManager(CmsDriverManager driverManager) {
        this.m_driverManager = driverManager;
    }

    public int getActiveConnections(String dbPoolUrl) throws CmsDbException {
        return this.m_driverManager.getActiveConnections(dbPoolUrl);
    }

    public Connection getConnection(String dbPoolName) throws SQLException {
        return this.getConnectionByUrl("opencms:" + dbPoolName);
    }

    public Connection getConnectionByUrl(String dbPoolUrl) throws SQLException {
        return ((CmsDbPoolV11)CmsDriverManager.m_pools.get(dbPoolUrl)).getConnection();
    }

    public List<String> getDbPoolUrls() {
        return new ArrayList<String>(CmsDriverManager.m_pools.keySet());
    }

    public String getDefaultDbPoolName() {
        return CmsDbPoolV11.getDefaultDbPoolName();
    }

    public int getIdleConnections(String dbPoolUrl) throws CmsDbException {
        return this.m_driverManager.getIdleConnections(dbPoolUrl);
    }
}

