/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.db;

import java.util.ArrayList;
import java.util.List;
import org.opencms.db.CmsStatementBuilder;
import org.opencms.db.I_CmsQueryFragment;

public class CmsSqlBooleanClause
implements I_CmsQueryFragment {
    private List<I_CmsQueryFragment> m_fragments = new ArrayList<I_CmsQueryFragment>();
    private String m_operator;

    public CmsSqlBooleanClause(String operator) {
        this.m_operator = operator;
    }

    public static CmsSqlBooleanClause makeAnd(I_CmsQueryFragment ... fragments) {
        CmsSqlBooleanClause result = new CmsSqlBooleanClause("AND");
        for (I_CmsQueryFragment fragment : fragments) {
            result.addCondition(fragment);
        }
        return result;
    }

    public static CmsSqlBooleanClause makeOr(I_CmsQueryFragment ... fragments) {
        CmsSqlBooleanClause result = new CmsSqlBooleanClause("OR");
        for (I_CmsQueryFragment fragment : fragments) {
            result.addCondition(fragment);
        }
        return result;
    }

    public CmsSqlBooleanClause addCondition(I_CmsQueryFragment fragment) {
        this.m_fragments.add(fragment);
        return this;
    }

    @Override
    public void visit(CmsStatementBuilder builder) {
        String connector = " " + this.m_operator + " ";
        if (this.m_fragments.size() == 0) {
            throw new IllegalStateException();
        }
        if (this.m_fragments.size() == 1) {
            this.m_fragments.get(0).visit(builder);
        } else {
            builder.add("(", new Object[0]);
            for (int i = 0; i < this.m_fragments.size(); ++i) {
                if (i != 0) {
                    builder.add(connector, new Object[0]);
                }
                this.m_fragments.get(i).visit(builder);
            }
            builder.add(")", new Object[0]);
        }
    }
}

