/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.db;

import java.util.Collections;
import java.util.List;
import org.opencms.configuration.CmsParameterConfiguration;
import org.opencms.util.CmsStringUtil;

public class CmsOnlineFolderOptions {
    public static final String PARAM_INDEXING_INTERVAL = "indexing-interval";
    public static final String PARAM_FLEX_CACHE_DELAY = "flex-cache-delay";
    private List<String> m_paths;
    private CmsParameterConfiguration m_params;

    public CmsOnlineFolderOptions(List<String> paths, CmsParameterConfiguration params) {
        this.m_paths = Collections.unmodifiableList(paths);
        this.m_params = CmsParameterConfiguration.unmodifiableVersion(params);
    }

    public long getFlexCacheDelay() {
        String delayStr = this.m_params.getString(PARAM_FLEX_CACHE_DELAY, "5s");
        return CmsStringUtil.parseDuration(delayStr, 5000L);
    }

    public long getIndexingInterval() {
        String indexingIntervalStr = this.m_params.getString(PARAM_INDEXING_INTERVAL, "2s");
        return CmsStringUtil.parseDuration(indexingIntervalStr, 2000L);
    }

    public CmsParameterConfiguration getParams() {
        return this.m_params;
    }

    public List<String> getPaths() {
        return this.m_paths;
    }
}

